/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.movies.server;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXKey;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import webobjectsexamples.businesslogic.movies.common.Movie;
import webobjectsexamples.businesslogic.movies.server.Studio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _Studio
extends ERXGenericRecord {
    public static final String ENTITY_NAME = "Studio";
    public static final ERXKey<BigDecimal> BUDGET = new ERXKey("budget");
    public static final ERXKey<String> NAME = new ERXKey("name");
    public static final ERXKey<Movie> MOVIES = new ERXKey("movies");
    public static final String BUDGET_KEY = BUDGET.key();
    public static final String NAME_KEY = NAME.key();
    public static final String MOVIES_KEY = MOVIES.key();
    private static Logger LOG = Logger.getLogger(_Studio.class);

    public Studio localInstanceIn(EOEditingContext editingContext) {
        Studio localInstance = (Studio)EOUtilities.localInstanceOfObject((EOEditingContext)editingContext, (EOEnterpriseObject)this);
        if (localInstance == null) {
            throw new IllegalStateException("You attempted to localInstance " + (Object)((Object)this) + ", which has not yet committed.");
        }
        return localInstance;
    }

    public BigDecimal budget() {
        return (BigDecimal)this.storedValueForKey(BUDGET_KEY);
    }

    public void setBudget(BigDecimal value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating budget from " + this.budget() + " to " + value));
        }
        this.takeStoredValueForKey(value, BUDGET_KEY);
    }

    public String name() {
        return (String)this.storedValueForKey(NAME_KEY);
    }

    public void setName(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating name from " + this.name() + " to " + value));
        }
        this.takeStoredValueForKey(value, NAME_KEY);
    }

    public NSArray<Movie> movies() {
        return (NSArray)this.storedValueForKey(MOVIES_KEY);
    }

    public NSArray<Movie> movies(EOQualifier qualifier) {
        return this.movies(qualifier, null, false);
    }

    public NSArray<Movie> movies(EOQualifier qualifier, boolean fetch) {
        return this.movies(qualifier, null, fetch);
    }

    public NSArray<Movie> movies(EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings, boolean fetch) {
        NSArray<Movie> results;
        if (fetch) {
            EOKeyValueQualifier fullQualifier;
            EOKeyValueQualifier inverseQualifier = new EOKeyValueQualifier(Movie.STUDIO_KEY, EOQualifier.QualifierOperatorEqual, (Object)this);
            if (qualifier == null) {
                fullQualifier = inverseQualifier;
            } else {
                NSMutableArray qualifiers = new NSMutableArray();
                qualifiers.addObject((Object)qualifier);
                qualifiers.addObject((Object)inverseQualifier);
                fullQualifier = new EOAndQualifier((NSArray)qualifiers);
            }
            results = Movie.fetchMovies(this.editingContext(), (EOQualifier)fullQualifier, sortOrderings);
        } else {
            results = this.movies();
            if (qualifier != null) {
                results = EOQualifier.filteredArrayWithQualifier(results, (EOQualifier)qualifier);
            }
            if (sortOrderings != null) {
                results = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)results, sortOrderings);
            }
        }
        return results;
    }

    public void addToMovies(Movie object) {
        this.includeObjectIntoPropertyWithKey((Object)object, MOVIES_KEY);
    }

    public void removeFromMovies(Movie object) {
        this.excludeObjectFromPropertyWithKey((Object)object, MOVIES_KEY);
    }

    public void addToMoviesRelationship(Movie object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding " + (Object)((Object)object) + " to movies relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.addToMovies(object);
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, MOVIES_KEY);
        }
    }

    public void removeFromMoviesRelationship(Movie object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + (Object)((Object)object) + " from movies relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.removeFromMovies(object);
        } else {
            this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, MOVIES_KEY);
        }
    }

    public Movie createMoviesRelationship() {
        EOClassDescription eoClassDesc = EOClassDescription.classDescriptionForEntityName((String)"Movie");
        EOEnterpriseObject eo = eoClassDesc.createInstanceWithEditingContext(this.editingContext(), null);
        this.editingContext().insertObject(eo);
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)eo, MOVIES_KEY);
        return (Movie)eo;
    }

    public void deleteMoviesRelationship(Movie object) {
        this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, MOVIES_KEY);
        this.editingContext().deleteObject((EOEnterpriseObject)object);
    }

    public void deleteAllMoviesRelationships() {
        Enumeration objects = this.movies().immutableClone().objectEnumerator();
        while (objects.hasMoreElements()) {
            this.deleteMoviesRelationship((Movie)((Object)objects.nextElement()));
        }
    }

    public static Studio createStudio(EOEditingContext editingContext, BigDecimal budget, String name) {
        Studio eo = (Studio)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)ENTITY_NAME);
        eo.setBudget(budget);
        eo.setName(name);
        return eo;
    }

    public static NSArray<Studio> fetchAllStudios(EOEditingContext editingContext) {
        return _Studio.fetchAllStudios(editingContext, null);
    }

    public static NSArray<Studio> fetchAllStudios(EOEditingContext editingContext, NSArray<EOSortOrdering> sortOrderings) {
        return _Studio.fetchStudios(editingContext, null, sortOrderings);
    }

    public static NSArray<Studio> fetchStudios(EOEditingContext editingContext, EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings) {
        ERXFetchSpecification fetchSpec = new ERXFetchSpecification(ENTITY_NAME, qualifier, sortOrderings);
        fetchSpec.setIsDeep(true);
        NSArray eoObjects = fetchSpec.fetchObjects(editingContext);
        return eoObjects;
    }

    public static Studio fetchStudio(EOEditingContext editingContext, String keyName, Object value) {
        return _Studio.fetchStudio(editingContext, (EOQualifier)new EOKeyValueQualifier(keyName, EOQualifier.QualifierOperatorEqual, value));
    }

    public static Studio fetchStudio(EOEditingContext editingContext, EOQualifier qualifier) {
        Studio eoObject;
        NSArray<Studio> eoObjects = _Studio.fetchStudios(editingContext, qualifier, null);
        int count = eoObjects.count();
        if (count == 0) {
            eoObject = null;
        } else if (count == 1) {
            eoObject = (Studio)((Object)eoObjects.objectAtIndex(0));
        } else {
            throw new IllegalStateException("There was more than one Studio that matched the qualifier '" + qualifier + "'.");
        }
        return eoObject;
    }

    public static Studio fetchRequiredStudio(EOEditingContext editingContext, String keyName, Object value) {
        return _Studio.fetchRequiredStudio(editingContext, (EOQualifier)new EOKeyValueQualifier(keyName, EOQualifier.QualifierOperatorEqual, value));
    }

    public static Studio fetchRequiredStudio(EOEditingContext editingContext, EOQualifier qualifier) {
        Studio eoObject = _Studio.fetchStudio(editingContext, qualifier);
        if (eoObject == null) {
            throw new NoSuchElementException("There was no Studio that matched the qualifier '" + qualifier + "'.");
        }
        return eoObject;
    }

    public static Studio localInstanceIn(EOEditingContext editingContext, Studio eo) {
        Studio localInstance;
        Studio studio = localInstance = eo == null ? null : (Studio)ERXEOControlUtilities.localInstanceOfObject((EOEditingContext)editingContext, (EOEnterpriseObject)eo);
        if (localInstance == null && eo != null) {
            throw new IllegalStateException("You attempted to localInstance " + (Object)((Object)eo) + ", which has not yet committed.");
        }
        return localInstance;
    }

    public static NSArray<NSDictionary> fetchRawFetchAllStudios(EOEditingContext editingContext, NSDictionary<String, Object> bindings) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"RawFetchAllStudios", (String)ENTITY_NAME);
        fetchSpec = fetchSpec.fetchSpecificationWithQualifierBindings(bindings);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }

    public static NSArray<NSDictionary> fetchRawFetchAllStudios(EOEditingContext editingContext) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"RawFetchAllStudios", (String)ENTITY_NAME);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }
}

