/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.rentals.common;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import webobjectsexamples.businesslogic.rentals.common.Rental;

public class Unit
extends EOGenericRecord {
    private static final long serialVersionUID = -1282298842109267336L;
    public static final String DateAcquiredKey = "dateAcquired";
    public static final String NotesKey = "notes";
    public static final String RentalsKey = "rentals";
    public static final String UnitIDKey = "unitID";
    public static final String VideoKey = "video";

    public void awakeFromInsertion(EOEditingContext editingContext) {
        super.awakeFromInsertion(editingContext);
        if (this.dateAcquired() == null) {
            this.setDateAcquired(new NSTimestamp());
        }
    }

    public void validateForSave() throws NSValidation.ValidationException {
        int rentalsOut = 0;
        NSArray rentals = this.rentals();
        if (rentals != null) {
            int count = rentals.count();
            for (int i = 0; i < count; ++i) {
                if (!((Rental)((Object)rentals.objectAtIndex(i))).isOut()) continue;
                ++rentalsOut;
            }
        }
        if (rentalsOut > 1) {
            throw new NSValidation.ValidationException("The unit with ID " + this.unitID() + " may not be rented twice!");
        }
        super.validateForSave();
    }

    public Number unitID() {
        return (Number)this.storedValueForKey(UnitIDKey);
    }

    public NSTimestamp dateAcquired() {
        return (NSTimestamp)this.storedValueForKey(DateAcquiredKey);
    }

    public void setDateAcquired(NSTimestamp value) {
        this.takeStoredValueForKey(value, DateAcquiredKey);
    }

    public NSArray rentals() {
        return (NSArray)this.storedValueForKey(RentalsKey);
    }

    public boolean isAvailableForRent() {
        NSArray rentals = this.rentals();
        if (rentals != null) {
            int count = rentals.count();
            for (int i = 0; i < count; ++i) {
                if (!((Rental)((Object)rentals.objectAtIndex(i))).isOut()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isCheckedOut() {
        return !this.isAvailableForRent();
    }

    public String isAvailableString() {
        return this.isAvailableForRent() ? "Yes" : "No";
    }
}

