/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WPage;
import com.webobjects.directtoweb.ERD2WContext;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.directtoweb.ErrorPageInterface;
import com.webobjects.directtoweb.InspectPageInterface;
import com.webobjects.directtoweb.ListPageInterface;
import com.webobjects.directtoweb.QueryPageInterface;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestampFormatter;
import er.directtoweb.interfaces.ERDErrorPageInterface;
import er.directtoweb.pages.ERD2WEditableListPage;
import er.directtoweb.pages.ERD2WQueryPage;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXDirectAction;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.text.Format;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class ERD2WDirectAction
extends ERXDirectAction {
    protected static final Logger log = Logger.getLogger(ERD2WDirectAction.class);
    protected final Logger actionLog = Logger.getLogger((String)(ERD2WDirectAction.class.getName() + ".actions"));
    static final String primaryKeyKey = "__key";
    static final String keyPathKey = "__keypath";
    static final String fetchSpecificationKey = "__fs";
    static final String fetchLimitKey = "__fs_fetchLimit";
    static final String usesDistinctKey = "__fs_usesDistinct";
    static final String contextIDKey = "__cid";
    static final String createPrefix = "Create";

    public ERD2WDirectAction(WORequest r) {
        super(r);
    }

    protected EOEditingContext newEditingContext() {
        return ERXEC.newEditingContext((EOObjectStore)this.session().defaultEditingContext().parentObjectStore());
    }

    protected Object qualifierValueForAttribute(EOAttribute attribute, String stringValue) {
        return ERXStringUtilities.attributeValueFromString((EOAttribute)attribute, (String)stringValue, (String)this.context().request().formValueEncoding(), (Format)new NSTimestampFormatter());
    }

    public EOFetchSpecification fetchSpecificationFromRequest(String entityName) {
        EOFetchSpecification fs = null;
        if (this.context().request().formValueKeys().containsObject((Object)fetchSpecificationKey)) {
            String fsName = this.context().request().stringFormValueForKey(fetchSpecificationKey);
            if (ERXStringUtilities.stringIsNullOrEmpty((String)fsName)) {
                EOEntity rootEntity = ERXEOAccessUtilities.entityNamed((EOEditingContext)this.session().defaultEditingContext(), (String)entityName);
                NSMutableArray qualifiers = new NSMutableArray();
                Enumeration e = this.context().request().formValueKeys().objectEnumerator();
                while (e.hasMoreElements()) {
                    String stringValue;
                    String key = (String)e.nextElement();
                    EOEntity entity = rootEntity;
                    EOAttribute attribute = null;
                    String attributeName = key;
                    if (key.indexOf(".") > 0) {
                        String path = ERXStringUtilities.keyPathWithoutLastProperty((String)key);
                        attributeName = ERXStringUtilities.lastPropertyKeyInKeyPath((String)key);
                        entity = ERXEOAccessUtilities.destinationEntityForKeyPath((EOEntity)rootEntity, (String)path);
                    }
                    if (entity == null || (attribute = entity.attributeNamed(attributeName)) == null || (stringValue = this.context().request().stringFormValueForKey(key)) == null) continue;
                    Object value = null;
                    NSSelector selector = EOKeyValueQualifier.QualifierOperatorEqual;
                    if (stringValue.indexOf(42) >= 0) {
                        selector = EOKeyValueQualifier.QualifierOperatorCaseInsensitiveLike;
                    }
                    if (!NSKeyValueCoding.NullValue.toString().equals(stringValue)) {
                        value = this.qualifierValueForAttribute(attribute, stringValue);
                        if (value == null) continue;
                        qualifiers.addObject((Object)new EOKeyValueQualifier(key, selector, value));
                        continue;
                    }
                    qualifiers.addObject((Object)new EOKeyValueQualifier(key, selector, value));
                }
                EOAndQualifier qualifier = null;
                if (qualifiers.count() > 0) {
                    qualifier = new EOAndQualifier((NSArray)qualifiers);
                }
                fs = new EOFetchSpecification(entityName, (EOQualifier)qualifier, null);
                boolean usesDictinct = ERXValueUtilities.booleanValueWithDefault((Object)this.context().request().stringFormValueForKey(usesDistinctKey), (boolean)true);
                fs.setUsesDistinct(usesDictinct);
                int limit = ERXValueUtilities.intValueWithDefault((Object)this.context().request().stringFormValueForKey(fetchLimitKey), (int)200);
                fs.setFetchLimit(limit);
            } else {
                fs = EOFetchSpecification.fetchSpecificationNamed((String)fsName, (String)entityName);
                NSMutableDictionary bindings = new NSMutableDictionary();
                Enumeration e = fs.qualifier().bindingKeys().objectEnumerator();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String formValue = this.context().request().stringFormValueForKey(key);
                    if (formValue == null) continue;
                    bindings.setObjectForKey((Object)formValue, (Object)key);
                }
                if (bindings.count() > 0) {
                    fs = fs.fetchSpecificationWithQualifierBindings((NSDictionary)bindings);
                }
            }
        }
        return fs;
    }

    public Number primaryKeyFromRequest() {
        return this.context().request().numericFormValueForKey(primaryKeyKey, new NSNumberFormatter("#"));
    }

    public NSDictionary primaryKeyFromRequest(EOEditingContext ec, String entityName) {
        String pkString = this.context().request().stringFormValueForKey(primaryKeyKey);
        return ERXEOControlUtilities.primaryKeyDictionaryForString((EOEditingContext)ec, (String)entityName, (String)pkString);
    }

    public WOComponent previousPageFromRequest() {
        String cid = this.context().request().stringFormValueForKey(contextIDKey);
        if (cid == null) {
            return this.context().page();
        }
        WOComponent comp = this.session().restorePageForContextID(cid);
        if (comp != null && !ERXApplication.isWO54()) {
            comp._sleepInContext(comp.context());
        }
        return comp;
    }

    public String keyPathFromRequest() {
        return this.context().request().stringFormValueForKey(keyPathKey);
    }

    public EOArrayDataSource relationshipArrayFromRequest(EOEditingContext ec, EOClassDescription cd) {
        int indexOfDot;
        String keyPath = this.context().request().stringFormValueForKey(keyPathKey);
        if (keyPath != null && (indexOfDot = keyPath.indexOf(".")) > 0) {
            String entityName = keyPath.substring(0, indexOfDot);
            String relationshipPath = keyPath.substring(indexOfDot + 1, keyPath.length());
            EOEnterpriseObject eo = EOUtilities.objectWithPrimaryKey((EOEditingContext)ec, (String)entityName, (NSDictionary)this.primaryKeyFromRequest(ec, entityName));
            EOArrayDataSource ds = new EOArrayDataSource(cd, ec);
            ds.setArray((NSArray)eo.valueForKeyPath(relationshipPath));
            return ds;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareEditPage(D2WContext context, EditPageInterface epi, String entityName) {
        EOEditingContext ec = this.newEditingContext();
        EOEnterpriseObject eo = null;
        ec.lock();
        try {
            eo = context.dynamicPage().startsWith(createPrefix) || this.primaryKeyFromRequest(ec, entityName) == null ? EOUtilities.createAndInsertInstance((EOEditingContext)ec, (String)entityName) : ERXEOControlUtilities.objectWithPrimaryKeyValue((EOEditingContext)ec, (String)entityName, (Object)this.primaryKeyFromRequest(ec, entityName), null);
        }
        finally {
            ec.unlock();
        }
        epi.setObject(eo);
        epi.setNextPage(this.previousPageFromRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareInspectPage(D2WContext context, InspectPageInterface ipi, String entityName) {
        EOEditingContext ec = this.session().defaultEditingContext();
        EOEnterpriseObject eo = null;
        ec.lock();
        try {
            eo = EOUtilities.objectWithPrimaryKey((EOEditingContext)ec, (String)entityName, (NSDictionary)this.primaryKeyFromRequest(ec, entityName));
        }
        finally {
            ec.unlock();
        }
        ipi.setObject(eo);
        ipi.setNextPage(this.previousPageFromRequest());
    }

    protected void prepareQueryPage(D2WContext context, QueryPageInterface qpi, String entityName) {
        EOFetchSpecification fs = this.fetchSpecificationFromRequest(entityName);
        if (qpi instanceof ERD2WQueryPage && fs != null) {
            ((ERD2WQueryPage)qpi).setFetchSpecification(fs);
        }
    }

    protected void prepareListPage(D2WContext context, ListPageInterface lpi, String entityName) {
        EOEntity entity;
        EOArrayDataSource ds;
        EOEditingContext ec = this.session().defaultEditingContext();
        if (lpi instanceof ERD2WEditableListPage) {
            ec = ERXEC.newEditingContext((EOObjectStore)this.session().defaultEditingContext().parentObjectStore());
        }
        if ((ds = this.relationshipArrayFromRequest(ec, (entity = ERXEOAccessUtilities.entityNamed((EOEditingContext)ec, (String)entityName)).classDescriptionForInstances())) == null) {
            ds = new EODatabaseDataSource(ec, entityName);
            EOFetchSpecification fs = this.fetchSpecificationFromRequest(entityName);
            if (fs == null) {
                fs = new EOFetchSpecification(entityName, null, null);
            }
            if (!this.context().request().formValueKeys().contains((Object)fetchLimitKey)) {
                int fetchLimit = ERXValueUtilities.intValueWithDefault((Object)context.valueForKey("fetchLimit"), (int)200);
                fs.setFetchLimit(fetchLimit);
            }
            boolean refresh = ERXValueUtilities.booleanValueWithDefault((Object)context.valueForKey("refreshRefetchedObjects"), (boolean)false);
            fs.setRefreshesRefetchedObjects(refresh);
            ((EODatabaseDataSource)ds).setFetchSpecification(fs);
        }
        lpi.setDataSource((EODataSource)ds);
        lpi.setNextPage(this.previousPageFromRequest());
    }

    public WOActionResults dynamicPageForActionNamed(String anActionName) {
        WOComponent newPage = null;
        try {
            newPage = D2W.factory().pageForConfigurationNamed(anActionName, this.session());
        }
        catch (IllegalStateException ex) {
            this.actionLog.debug((Object)("dynamicPageForActionNamed failed for Action:" + anActionName), (Throwable)ex);
            return null;
        }
        D2WContext context = null;
        if (newPage instanceof D2WPage) {
            context = ((D2WPage)newPage).d2wContext();
        } else {
            context = ERD2WContext.newContext(this.session());
            context.setDynamicPage(anActionName);
        }
        EOEntity entity = context.entity();
        if (entity != null) {
            String entityName = entity.name();
            String taskName = context.task();
            if (newPage instanceof EditPageInterface && taskName.equals("edit")) {
                this.prepareEditPage(context, (EditPageInterface)newPage, entityName);
            } else if (newPage instanceof InspectPageInterface) {
                this.prepareInspectPage(context, (InspectPageInterface)newPage, entityName);
            } else if (newPage instanceof QueryPageInterface) {
                this.prepareQueryPage(context, (QueryPageInterface)newPage, entityName);
            } else if (newPage instanceof ListPageInterface) {
                this.prepareListPage(context, (ListPageInterface)newPage, entityName);
            } else if (newPage instanceof ErrorPageInterface) {
                this.prepareErrorPage(context, (ErrorPageInterface)newPage);
            }
        } else if (newPage instanceof ErrorPageInterface) {
            this.prepareErrorPage(context, (ErrorPageInterface)newPage);
        }
        return newPage;
    }

    protected WOActionResults prepareErrorPage(D2WContext d2wContext, ErrorPageInterface epi) {
        WOActionResults newPage = null;
        try {
            String message = this.context().request().stringFormValueForKey("__message");
            if (message != null) {
                message = message.replaceAll("<.*?>", "");
            }
            epi.setMessage(message);
            epi.setNextPage(this.previousPageFromRequest());
            newPage = (WOActionResults)epi;
        }
        catch (Exception otherException) {
            log.error((Object)"Exception while trying to report exception!", (Throwable)otherException);
        }
        return newPage;
    }

    public WOActionResults reportException(Exception ex) {
        WOActionResults newPage = null;
        try {
            ErrorPageInterface epf = D2W.factory().errorPage(this.session());
            if (epf instanceof ERDErrorPageInterface) {
                ((ERDErrorPageInterface)epf).setException(ex);
            }
            epf.setMessage(ex.toString());
            epf.setNextPage(this.previousPageFromRequest());
            newPage = (WOActionResults)epf;
        }
        catch (Exception otherException) {
            log.error((Object)"Exception while trying to report exception!", (Throwable)otherException);
        }
        return newPage;
    }

    protected boolean allowPageConfiguration(String pageConfiguration) {
        return true;
    }

    public WOActionResults forbiddenAction() {
        WOResponse response = new WOResponse();
        response.setStatus(401);
        response.setContent("Access denied");
        return response;
    }

    public WOActionResults performActionNamed(String anActionName) {
        WOActionResults newPage = null;
        try {
            try {
                newPage = super.performActionNamed(anActionName);
            }
            catch (NSForwardException fwe) {
                if (!(fwe.originalException() instanceof NoSuchMethodException)) {
                    throw fwe;
                }
                this.actionLog.debug((Object)("performActionNamed for action: " + anActionName), (Throwable)fwe);
            }
            catch (NoSuchMethodException nsm) {
                this.actionLog.debug((Object)("performActionNamed for action: " + anActionName), (Throwable)nsm);
            }
            if (newPage == null) {
                newPage = this.allowPageConfiguration(anActionName) ? this.dynamicPageForActionNamed(anActionName) : this.forbiddenAction();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error with action " + anActionName + ":" + ex + ", formValues:" + this.context().request().formValues()), (Throwable)ex);
            newPage = this.reportException(ex);
        }
        return newPage;
    }
}

