/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.components.dates;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.directtoweb.components.ERDCustomEditComponent;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;

public class ERDEditDatePopupCommon
extends ERDCustomEditComponent {
    protected String day;
    protected String month;
    protected String year;
    public String currentMonth;
    protected NSMutableArray yearList;
    protected static NSArray monthList;
    protected NSArray monthNameList;
    protected static NSArray defaultMonthNameList;
    protected static NSArray dayList;
    protected static final NSTimestampFormatter DAY_FORMAT;
    protected static final NSTimestampFormatter MONTH_FORMAT;
    protected static final NSTimestampFormatter YEAR_FORMAT;
    protected static final NSTimestampFormatter TIME_FORMAT;
    protected static final NSTimestampFormatter ALL_FORMAT;
    protected static final NSTimestampFormatter ALL_FORMAT_AND_TIME;
    protected String time;
    private Integer _editTime;

    public ERDEditDatePopupCommon(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void reset() {
        super.reset();
        this.yearList = null;
        this.time = null;
        this._editTime = null;
        this.day = null;
        this.month = null;
        this.year = null;
        this.monthNameList = null;
    }

    public NSArray dayList() {
        if (dayList == null) {
            dayList = new NSMutableArray(new Object[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"});
        }
        return dayList;
    }

    public NSArray monthNameList() {
        if (this.monthNameList == null) {
            this.monthNameList = (NSArray)ERXLocalizer.currentLocalizer().valueForKey("ERDDatePopup.monthList");
            if (this.monthNameList == null) {
                if (defaultMonthNameList == null) {
                    defaultMonthNameList = new NSArray(new Object[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
                }
                this.monthNameList = defaultMonthNameList;
            }
        }
        return this.monthNameList;
    }

    public NSArray monthList() {
        if (monthList == null) {
            monthList = new NSArray(new Object[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"});
        }
        return monthList;
    }

    public NSArray yearList() {
        if (this.yearList == null) {
            this.yearList = new NSMutableArray();
            int startYear = 1950;
            int endYear = 2050;
            String yearRangeTop = null;
            String yearRangeBottom = null;
            if (this.valueForBinding("yearRangeTop") != null && this.valueForBinding("yearRangeBottom") != null) {
                yearRangeTop = (String)this.valueForBinding("yearRangeTop");
                yearRangeBottom = (String)this.valueForBinding("yearRangeBottom");
            }
            if (yearRangeBottom != null && yearRangeTop != null) {
                try {
                    Integer start = ERXConstant.integerForString(yearRangeBottom);
                    Integer end = ERXConstant.integerForString((String)yearRangeTop);
                    if (end > start) {
                        startYear = start;
                        endYear = end;
                    }
                }
                catch (NumberFormatException e) {
                    NSLog.err.appendln((Object)("Binding exception in D2WEditDatePopup: " + e.toString()));
                }
            }
            for (int year = startYear; year <= endYear; ++year) {
                this.yearList.addObject((Object)("" + year));
            }
        }
        return this.yearList;
    }

    public String time() throws Exception {
        NSTimestamp date = (NSTimestamp)this.objectPropertyValue();
        this.time = date != null ? TIME_FORMAT.format((Object)date) : TIME_FORMAT.format((Object)new NSTimestamp());
        return this.time;
    }

    public void setTime(String newTime) {
        this.time = newTime;
    }

    public String day() throws Exception {
        NSTimestamp date = (NSTimestamp)this.objectPropertyValue();
        this.day = date != null ? DAY_FORMAT.format((Object)date) : DAY_FORMAT.format((Object)new NSTimestamp());
        return this.day;
    }

    public void setDay(String newDay) throws Exception {
        this.day = newDay;
    }

    public String monthName() throws Exception {
        return (String)this.monthNameList().objectAtIndex(Integer.parseInt(this.currentMonth) - 1);
    }

    public String month() throws Exception {
        NSTimestamp date = (NSTimestamp)this.objectPropertyValue();
        this.month = date != null ? MONTH_FORMAT.format((Object)date) : MONTH_FORMAT.format((Object)new NSTimestamp());
        return this.month;
    }

    public void setMonth(String newMonth) throws Exception {
        this.month = newMonth;
    }

    public String year() throws Exception {
        NSTimestamp date = (NSTimestamp)this.objectPropertyValue();
        this.year = date != null ? YEAR_FORMAT.format((Object)date) : YEAR_FORMAT.format((Object)new NSTimestamp());
        return this.year;
    }

    public void setYear(String newYear) throws Exception {
        this.year = newYear;
    }

    public boolean checkFutureDate() {
        return false;
    }

    public boolean editTime() {
        if (this._editTime == null) {
            Integer n = this._editTime = ERXValueUtilities.booleanValue((Object)this.valueForBinding("editTime")) ? ERXConstant.OneInteger : ERXConstant.ZeroInteger;
        }
        return this._editTime != null ? this._editTime != 0 : false;
    }

    public String today() {
        return "var mydate=new Date() /n var year=mydate.getYear() /n if (year < 1000) /n year+=1900 /n var day=mydate.getDay() /n var month=mydate.getMonth()+1 /n if (month<10) /n month=\"0\"+month /n var daym=mydate.getDate() /n if (daym<10) /n daym=\"0\"+daym /n document.write(\"<small><font color='000000' face='Arial'><b>\"+month+\"/\"+daym+\"/\"+year+\"</b></font></small>)\"";
    }

    static {
        DAY_FORMAT = new NSTimestampFormatter("%d");
        MONTH_FORMAT = new NSTimestampFormatter("%m");
        YEAR_FORMAT = new NSTimestampFormatter("%Y");
        TIME_FORMAT = new NSTimestampFormatter("%H:%M");
        ALL_FORMAT = new NSTimestampFormatter("%d %m %Y");
        ALL_FORMAT_AND_TIME = new NSTimestampFormatter("%d %m %Y %H:%M");
    }
}

