/*
 * Decompiled with CFR 0.152.
 */
package er.corebusinesslogic;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSValidation;
import er.corebusinesslogic.ERCMailState;
import er.corebusinesslogic.ERCMessageAttachment;
import er.corebusinesslogic._ERCMailMessage;
import er.extensions.eof.EOEnterpriseObjectClazz;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXFetchSpecificationBatchIterator;
import er.extensions.foundation.ERXCompressionUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.validation.ERXValidationException;
import er.extensions.validation.ERXValidationFactory;
import org.apache.log4j.Logger;

public class ERCMailMessage
extends _ERCMailMessage {
    public static final Logger log = Logger.getLogger(ERCMailMessage.class);
    public static final String AddressSeparator = ",";

    public static ERCMailMessageClazz mailMessageClazz() {
        return (ERCMailMessageClazz)EOEnterpriseObjectClazz.clazzForEntityNamed((String)"ERCMailMessage");
    }

    public void init(EOEditingContext anEditingContext) {
        super.init(anEditingContext);
        this.setState(ERCMailState.READY_TO_BE_SENT_STATE);
        boolean shouldArchive = ERXProperties.booleanForKeyWithDefault((String)"er.corebusinesslogic.ERCMailMessage.ShouldArchive", (boolean)false);
        this.setShouldArchiveSentMail(shouldArchive);
        boolean shouldZip = ERXProperties.booleanForKeyWithDefault((String)"er.corebusinesslogic.ERCMailMessage.ShouldGzipContent", (boolean)true);
        this.setContentGzipped(shouldZip);
        this.setIsRead(false);
    }

    public boolean isReadyToSendState() {
        return this.state() == ERCMailState.READY_TO_BE_SENT_STATE;
    }

    public boolean isSentState() {
        return this.state() == ERCMailState.SENT_STATE;
    }

    public boolean isExceptionState() {
        return this.state() == ERCMailState.EXCEPTION_STATE;
    }

    public boolean isReceivedState() {
        return this.state() == ERCMailState.RECEIVED_STATE;
    }

    public void markReadBy(EOEnterpriseObject by) {
        this.setIsRead(true);
    }

    public void setReadAsBoolean(boolean read) {
        this.setIsRead(read);
    }

    public boolean isReadAsBoolean() {
        return ERXValueUtilities.booleanValue((Object)this.isRead());
    }

    public NSArray toAddressesAsArray() {
        return this.toAddresses() != null ? NSArray.componentsSeparatedByString((String)this.toAddresses(), (String)AddressSeparator) : NSArray.EmptyArray;
    }

    public void setToAddressesAsArray(NSArray toAddresses) {
        if (toAddresses != null && toAddresses.count() > 0) {
            this.setToAddresses(toAddresses.componentsJoinedByString(AddressSeparator));
        }
    }

    public NSArray ccAddressesAsArray() {
        return this.ccAddresses() != null ? NSArray.componentsSeparatedByString((String)this.ccAddresses(), (String)AddressSeparator) : NSArray.EmptyArray;
    }

    public void setCcAddressesAsArray(NSArray ccAddresses) {
        if (ccAddresses != null && ccAddresses.count() > 0) {
            this.setCcAddresses(ccAddresses.componentsJoinedByString(AddressSeparator));
        }
    }

    public NSArray bccAddressesAsArray() {
        return this.bccAddresses() != null ? NSArray.componentsSeparatedByString((String)this.bccAddresses(), (String)AddressSeparator) : NSArray.EmptyArray;
    }

    public void setBccAddressesAsArray(NSArray bccAddresses) {
        if (bccAddresses != null && bccAddresses.count() > 0) {
            this.setBccAddresses(bccAddresses.componentsJoinedByString(AddressSeparator));
        }
    }

    public boolean shouldArchiveSentMailAsBoolean() {
        return ERXValueUtilities.booleanValue((Object)this.shouldArchiveSentMail());
    }

    public String longDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("To: ");
        sb.append(this.toAddresses());
        sb.append("\n");
        sb.append("cc: ");
        sb.append(this.ccAddresses());
        sb.append("\n");
        sb.append("Created: ");
        sb.append(this.created());
        sb.append("\n");
        sb.append("Title: ");
        sb.append(this.title());
        sb.append("\n");
        sb.append("Text: ");
        sb.append(this.text());
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("To: ");
        sb.append(this.toAddresses());
        sb.append("\n");
        sb.append("cc: ");
        sb.append(this.ccAddresses());
        sb.append("\n");
        sb.append("Created: ");
        sb.append(this.created());
        sb.append("\n");
        sb.append("Title: ");
        sb.append(this.title());
        return sb.toString();
    }

    public String toLongString() {
        return this.toString();
    }

    public ERCMailMessage archive() {
        return (ERCMailMessage)ERXEOControlUtilities.createAndInsertObject((EOEditingContext)this.editingContext(), (String)"ERCMailMessageArchive", (NSDictionary)this.snapshot());
    }

    public void appendText(String text) {
        String storedText = this.text();
        this.setText((storedText == null ? "" : storedText) + " " + text);
    }

    public Object validateEmptyStringForKey(Object value, String field) {
        if (value == null || "".equals(value) || ((String)value).length() == 0) {
            ERXValidationException e = ERXValidationFactory.defaultFactory().createCustomException((EOEnterpriseObject)this, field, value, "empty" + field);
            throw e;
        }
        return value;
    }

    public boolean hasAttachments() {
        return this.attachments().count() > 0;
    }

    public Object validateFromAddress(String newValue) {
        return this.validateEmptyStringForKey(newValue, "fromAddress");
    }

    public Object validateTitle(String newValue) {
        return this.validateEmptyStringForKey(newValue, "title");
    }

    public Object validateToAddresses(String newValue) {
        return this.validateEmptyStringForKey(newValue, "toAddresses");
    }

    public void validateForSave() throws NSValidation.ValidationException {
        String text = this.text();
        String plainText = this.plainText();
        super.validateForSave();
        if (!(text != null && text.length() != 0 || plainText != null && plainText.length() != 0)) {
            throw ERXValidationFactory.defaultFactory().createException((EOEnterpriseObject)this, "plainText,text", (Object)text, "eitherPlainTextOrText");
        }
    }

    public void attachFileWithMimeType(String filePath, String mimeType) {
        ERCMessageAttachment attachment = (ERCMessageAttachment)ERXEOControlUtilities.createAndInsertObject((EOEditingContext)this.editingContext(), (String)"ERCMessageAttachment");
        attachment.setFilePath(filePath);
        if (mimeType != null) {
            attachment.setMimeType(mimeType);
        }
        this.addToBothSidesOfAttachments(attachment);
    }

    public void addToBothSidesOfAttachments(ERCMessageAttachment attachement) {
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)attachement, "attachments");
    }

    public String storedGzippedValueForKey(String key) {
        NSData data = (NSData)this.storedValueForKey(key);
        String value = null;
        if (data != null && data.bytes().length > 0) {
            value = ERXCompressionUtilities.gunzipByteArrayAsString((byte[])data.bytes());
        }
        return value;
    }

    public void takeStoredGzippedValueForKey(String aValue, String key) {
        byte[] bytes;
        NSData valueToSet = null;
        if (aValue != null && (bytes = ERXCompressionUtilities.gzipStringAsByteArray((String)aValue)).length > 0) {
            valueToSet = new NSData(bytes);
        }
        this.takeStoredValueForKey(valueToSet, key);
    }

    public String text() {
        String value = null;
        value = this.contentGzipped() != false ? this.storedGzippedValueForKey("textCompressed") : (String)this.storedValueForKey("text");
        return value;
    }

    public void setText(String aValue) {
        if (this.contentGzipped().booleanValue()) {
            this.takeStoredGzippedValueForKey(aValue, "textCompressed");
        } else {
            this.takeStoredValueForKey(aValue, "text");
        }
    }

    public static class ERCMailMessageClazz
    extends _ERCMailMessage._ERCMailMessageClazz {
        public ERXFetchSpecificationBatchIterator batchIteratorForUnsentMessages() {
            EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"messagesToBeSent", (String)"ERCMailMessage");
            return new ERXFetchSpecificationBatchIterator(fetchSpec);
        }
    }
}

