/*
 * Decompiled with CFR 0.152.
 */
package er.wopaypal;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.foundation.ERXProperties;

public class PayPalAction
extends WODirectAction {
    public static final String paypalSite = "www.paypal.com";
    public static final String paypalCgi = "/cgi-bin/webscr";
    public static final String sandboxSite = "www.sandbox.paypal.com";

    public PayPalAction(WORequest aRequest) {
        super(aRequest);
    }

    public WOActionResults ipnAction() {
        boolean isSandboxMode = false;
        WORequest ppIPNRequest = this.request();
        if (NSLog.debugLoggingAllowedForLevel((int)2)) {
            NSLog.debug.appendln((Object)("PayPal's request looks like: " + ppIPNRequest + "\n\n"));
            NSLog.debug.appendln((Object)("PayPal's request content looks like: " + ppIPNRequest.contentString() + "\n\n"));
        }
        WOResponse ppValidationResponse = null;
        String ppValidationResponseString = null;
        isSandboxMode = ppIPNRequest.formValues().containsKey((Object)"test_ipn");
        String returnString = ppIPNRequest.contentString() + "&cmd=_notify-validate";
        WOHTTPConnection ppEchoConnection = new WOHTTPConnection(paypalSite, 80);
        if (isSandboxMode) {
            ppEchoConnection = new WOHTTPConnection(sandboxSite, 80);
        }
        StringBuffer ua = new StringBuffer();
        ua.append("WebObjects/ " + ERXProperties.webObjectsVersion() + " (");
        ua.append(System.getProperty("os.arch"));
        ua.append("; ");
        ua.append(System.getProperty("os.name"));
        ua.append(" ");
        ua.append(System.getProperty("os.version"));
        ua.append(")");
        NSMutableDictionary headers = new NSMutableDictionary();
        headers.setObjectForKey((Object)"en", (Object)"Accept-Language");
        headers.setObjectForKey((Object)"iso-8859-1,*,utf-8", (Object)"Accept-Charset");
        headers.setObjectForKey((Object)"image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*", (Object)"Accept");
        headers.setObjectForKey((Object)ua.toString(), (Object)"User-Agent");
        WORequest paypalEchoRequest = new WORequest("POST", paypalCgi, "HTTP/1.1", (NSDictionary)headers, null, null);
        paypalEchoRequest.setContent(returnString);
        ppEchoConnection.setReceiveTimeout(90000);
        boolean connectionSuccess = ppEchoConnection.sendRequest(paypalEchoRequest);
        if (connectionSuccess) {
            ppValidationResponse = ppEchoConnection.readResponse();
        }
        ppValidationResponseString = ppValidationResponse.contentString();
        if (connectionSuccess) {
            if (NSLog.debugLoggingAllowedForLevel((int)2)) {
                NSLog.debug.appendln((Object)("the response looks like: " + ppValidationResponse + "\n\n"));
                NSLog.debug.appendln((Object)("the response content looks like: " + ppValidationResponseString + "\n\n"));
            }
            if (ppValidationResponseString.equalsIgnoreCase("VERIFIED")) {
                if (((String)ppIPNRequest.formValueForKey("payment_status")).equalsIgnoreCase("completed")) {
                    NSNotificationCenter.defaultCenter().postNotification("ValidPayPalPaymentReceivedNotification", (Object)ppIPNRequest);
                } else if (((String)ppIPNRequest.formValueForKey("payment_status")).equalsIgnoreCase("pending")) {
                    NSNotificationCenter.defaultCenter().postNotification("PendingPayPalPaymentReceivedNotification", (Object)ppIPNRequest);
                } else if (((String)ppIPNRequest.formValueForKey("payment_status")).equalsIgnoreCase("failed")) {
                    NSNotificationCenter.defaultCenter().postNotification("FailedPayPalPaymentReceivedNotification", (Object)ppIPNRequest);
                } else if (((String)ppIPNRequest.formValueForKey("payment_status")).equalsIgnoreCase("denied")) {
                    NSNotificationCenter.defaultCenter().postNotification("DeniedPayPalPaymentReceivedNotification", (Object)ppIPNRequest);
                }
            } else if (ppValidationResponseString.equalsIgnoreCase("INVALID")) {
                NSNotificationCenter.defaultCenter().postNotification("InvalidPayPalPaymentReceivedNotification", (Object)ppIPNRequest);
            } else {
                NSLog.err.appendln((Object)("PayPalAction->ipnAction: PayPal transaction validation returned unaccepted validation status from i.p: " + (ppIPNRequest.headerForKey((Object)"REMOTE_ADDR") != null ? ppIPNRequest.headerForKey((Object)"REMOTE_ADDR") : "- unknown -")));
            }
        } else {
            NSLog.err.appendln((Object)"PayPalAction->ipnAction: PayPal transaction validation connection failed.");
        }
        return new OKResponse();
    }

    public WOActionResults returnAction() {
        String componentName = System.getProperty("SuccessfulPayPalTransactionComponent");
        if (componentName == null || componentName.equals("")) {
            componentName = "SuccessfulPayPalTransaction";
        }
        return this.pageWithName(componentName);
    }

    public WOActionResults cancelAction() {
        String componentName = System.getProperty("CancelledPayPalTransactionComponent");
        if (componentName == null || componentName.equals("")) {
            componentName = "CancelledPayPalTransaction";
        }
        return this.pageWithName(componentName);
    }

    private static class OKResponse
    extends HTTPStatusResponse {
        public OKResponse() {
            super(200, "OK");
        }
    }

    private static class HTTPStatusResponse
    extends WOResponse {
        public static void setResponse(WOResponse response, int statusInt, String statusString) {
            String contentString = "HTTP/1.0 " + statusInt + " " + statusString;
            response.appendContentString(contentString);
            response.setHeader("" + contentString.length(), "content-length");
            response.setHeader("text/html", "content-type");
            response.setStatus(statusInt);
        }

        public HTTPStatusResponse(int statusInt, String statusString) {
            HTTPStatusResponse.setResponse(this, statusInt, statusString);
        }
    }
}

