/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSLog;

public abstract class WOLongResponsePage
extends WOComponent
implements Runnable {
    static String WOMetaRefreshSenderId = "WOMetaRefresh";
    protected Object _status;
    protected Object _result;
    protected Exception _exception;
    protected int _refreshInterval;
    protected boolean _performingAction;
    protected boolean _cancelled;
    protected boolean _done;
    protected boolean _doneAndRefreshed;

    protected void _finishInitialization() {
        if (!WOApplication.application().adaptorsDispatchRequestsConcurrently()) {
            throw new RuntimeException("<" + this.getClass().getName() + "> Cannot initialize because:\nThe application must be set to run with multiple threads to use this component. You must first increase the application's worker thread count to at least 1. You then have several options:\n1. If you set the count to 1, your code does not need to be thread safe.\n2. If you set the count above 1, and your code is not thread safe, disable concurrent request handling.\n3. you set the count above 1, and your code is thread safe, you can enable concurrent request handling.");
        }
        this._status = null;
        this._result = null;
        this._done = false;
        this._doneAndRefreshed = false;
        this._exception = null;
        this._cancelled = false;
        this._refreshInterval = 0;
        this._performingAction = false;
    }

    public WOLongResponsePage(WOContext aContext) {
        super(aContext);
        this._finishInitialization();
    }

    public Object status() {
        return this._status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Object anObject) {
        if (anObject != this._status) {
            WOLongResponsePage wOLongResponsePage = this;
            synchronized (wOLongResponsePage) {
                this._status = anObject;
            }
        }
    }

    protected Exception _exception() {
        return this._exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _setException(Exception anObject) {
        if (anObject != this._exception) {
            WOLongResponsePage wOLongResponsePage = this;
            synchronized (wOLongResponsePage) {
                this._exception = anObject;
            }
        }
    }

    public void setRefreshInterval(double interval) {
        this._refreshInterval = interval > 0.0 ? (int)interval : 0;
    }

    public double refreshInterval() {
        return this._refreshInterval;
    }

    public Object result() {
        return this._result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object anObject) {
        if (anObject != this._result) {
            WOLongResponsePage wOLongResponsePage = this;
            synchronized (wOLongResponsePage) {
                this._result = anObject;
            }
        }
    }

    public void run() {
        this.setResult(null);
        this._done = false;
        this._doneAndRefreshed = false;
        String name = this.getClass().getName();
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
            NSLog.debug.appendln((Object)("<" + name + ">: creating computation thread"));
        }
        try {
            this.setResult(this.performAction());
        }
        catch (Exception localException) {
            this._setException(localException);
            NSLog.err.appendln((Object)("<" + this.getClass().getName() + "> long response thread raised : " + localException.toString()));
            NSLog.err.appendln((Object)"STACK TRACE:");
            NSLog.err.appendln((Throwable)localException);
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
            NSLog.debug.appendln((Object)("<" + name + ">: exiting computation thread"));
        }
        this._done = true;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        String modifiedDynamicUrl;
        if (!this._performingAction) {
            this._performingAction = true;
            try {
                Thread t = new Thread((Runnable)this, "WOLongResponsePage: " + this.getClass().getName());
                t.start();
            }
            catch (Exception localException) {
                throw new RuntimeException("<WOLongResponsePage> Exception occurred while creating long response thread: " + localException.toString());
            }
        }
        if ((int)this.refreshInterval() != 0 && !this._done) {
            modifiedDynamicUrl = aContext.urlWithRequestHandlerKey(WOApplication.application().componentRequestHandlerKey(), null, null);
            String header = "" + this._refreshInterval + ";url=" + modifiedDynamicUrl + "/" + aContext.session().sessionID() + "/" + aContext.contextID() + "." + WOMetaRefreshSenderId;
            aResponse.setHeader(header, "Refresh");
        } else if (this._refreshInterval != 0 && this._done && !this._doneAndRefreshed) {
            modifiedDynamicUrl = aContext.urlWithRequestHandlerKey(WOApplication.application().componentRequestHandlerKey(), null, null);
            String header = "0;url=" + modifiedDynamicUrl + "/" + aContext.session().sessionID() + "/" + aContext.contextID() + "." + WOMetaRefreshSenderId;
            aResponse.setHeader(header, "Refresh");
            this._doneAndRefreshed = true;
        }
        super.appendToResponse(aResponse, aContext);
    }

    public WOComponent pageForException(Exception exception) {
        throw new RuntimeException("<WOLongResponsePage> Exception occurred in long response thread: " + exception.toString());
    }

    public WOComponent refreshPageForStatus(Object aStatus) {
        return this;
    }

    public WOComponent pageForResult(Object aResult) {
        return this;
    }

    public WOComponent cancelPageForStatus(Object aStatus) {
        return this.refreshPageForStatus(aStatus);
    }

    public WOActionResults invokeAction(WORequest aRequest, WOContext aContext) {
        if (aContext.senderID().equals(WOMetaRefreshSenderId)) {
            return this.refresh();
        }
        return super.invokeAction(aRequest, aContext);
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelled(boolean aBool) {
        if (aBool != this._cancelled) {
            WOLongResponsePage wOLongResponsePage = this;
            synchronized (wOLongResponsePage) {
                this._cancelled = aBool;
            }
        }
    }

    public WOComponent refresh() {
        Exception e = this._exception();
        if (e != null) {
            return this.pageForException(e);
        }
        if (this._done) {
            if (this._cancelled) {
                return this.cancelPageForStatus(this.status());
            }
            return this.pageForResult(this.result());
        }
        return this.refreshPageForStatus(this.status());
    }

    public WOComponent cancel() {
        this.setCancelled(true);
        return this.cancelPageForStatus(this.status());
    }

    public abstract Object performAction();
}

