/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.woextensions._WOJExtensionsUtil;
import java.util.Enumeration;

public class WOSortOrderManyKey
extends WOComponent {
    protected String _currentKey;
    protected String _selectedKey;
    protected WODisplayGroup _displayGroup;

    public WOSortOrderManyKey(WOContext aContext) {
        super(aContext);
    }

    public String _currentKey() {
        return this._currentKey;
    }

    public boolean isStateless() {
        return true;
    }

    public void reset() {
        this._currentKey = null;
        this._selectedKey = null;
        this._displayGroup = null;
    }

    public WODisplayGroup displayGroup() {
        if (null == this._displayGroup) {
            this._displayGroup = (WODisplayGroup)_WOJExtensionsUtil.valueForBindingOrNull("displayGroup", this);
        }
        return this._displayGroup;
    }

    protected EOSortOrdering _primarySortOrdering() {
        NSArray anArray = this.displayGroup().sortOrderings();
        if (anArray != null && anArray.count() > 0) {
            EOSortOrdering anOrdering = (EOSortOrdering)anArray.objectAtIndex(0);
            return anOrdering;
        }
        return null;
    }

    public void setSelectedKey(String aNewValue) {
        this._selectedKey = aNewValue;
        if (this._isCurrentKeyPrimary()) {
            this._removeSortOrderingWithKey(this.selectedKey());
        }
        this._makePrimarySortOrderingWithSelector(EOSortOrdering.CompareAscending);
    }

    public String selectedKey() {
        if (null == this._selectedKey && this._primarySortOrdering() != null) {
            this.setSelectedKey(this._primarySortOrdering().key());
        }
        return this._selectedKey;
    }

    protected boolean _isCurrentKeyPrimary() {
        EOSortOrdering anOrdering = this._primarySortOrdering();
        return anOrdering != null && this._selectedKey != null && anOrdering.key().equals(this.selectedKey());
    }

    protected NSSelector _primaryKeySortOrderingSelector() {
        EOSortOrdering anOrdering = this._primarySortOrdering();
        NSSelector anOrderingSelector = null;
        if (anOrdering != null) {
            anOrderingSelector = anOrdering.selector();
        }
        return anOrderingSelector;
    }

    protected void _removeSortOrderingWithKey(String aKey) {
        int anIndex = 0;
        EOSortOrdering aSortOrdering = null;
        WODisplayGroup aDisplayGroup = this.displayGroup();
        NSArray sortOrderings = aDisplayGroup.sortOrderings();
        if (sortOrderings != null) {
            NSMutableArray aSortOrderingArray = sortOrderings.mutableClone();
            Enumeration anEnumerator = aSortOrderingArray.objectEnumerator();
            while (anEnumerator.hasMoreElements()) {
                aSortOrdering = (EOSortOrdering)anEnumerator.nextElement();
                if (aKey.equals(aSortOrdering.key())) {
                    aSortOrderingArray.removeObjectAtIndex(anIndex);
                    break;
                }
                ++anIndex;
            }
            aDisplayGroup.setSortOrderings((NSArray)aSortOrderingArray);
        }
    }

    protected void _makePrimarySortOrderingWithSelector(NSSelector aSelector) {
        String aKey = this._selectedKey;
        WODisplayGroup aDisplayGroup = this.displayGroup();
        NSArray sortOrderings = aDisplayGroup.sortOrderings();
        NSMutableArray aSortOrderingArray = sortOrderings != null ? new NSMutableArray(sortOrderings) : new NSMutableArray();
        EOSortOrdering aNewSortOrdering = EOSortOrdering.sortOrderingWithKey((String)aKey, (NSSelector)aSelector);
        aSortOrderingArray.insertObjectAtIndex((Object)aNewSortOrdering, 0);
        if (aSortOrderingArray.count() > 3) {
            aSortOrderingArray.removeLastObject();
        }
        aDisplayGroup.setSortOrderings((NSArray)aSortOrderingArray);
    }

    public WOComponent sortAscendingClicked() {
        if (this._isCurrentKeyPrimary()) {
            this._removeSortOrderingWithKey(this.selectedKey());
        }
        this._makePrimarySortOrderingWithSelector(EOSortOrdering.CompareAscending);
        this.displayGroup().updateDisplayedObjects();
        return null;
    }

    public WOComponent sortDescendingClicked() {
        if (this._isCurrentKeyPrimary()) {
            this._removeSortOrderingWithKey(this.selectedKey());
        }
        this._makePrimarySortOrderingWithSelector(EOSortOrdering.CompareDescending);
        this.displayGroup().updateDisplayedObjects();
        return null;
    }
}

