/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.woextensions._WOJExtensionsUtil;
import java.util.Enumeration;

public class WXSortOrder
extends WOComponent {
    protected WODisplayGroup _displayGroup;
    protected String _key;
    protected String _displayKey;

    public WXSortOrder(WOContext aContext) {
        super(aContext);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public WODisplayGroup displayGroup() {
        if (null == this._displayGroup) {
            this._displayGroup = (WODisplayGroup)_WOJExtensionsUtil.valueForBindingOrNull("displayGroup", this);
        }
        return this._displayGroup;
    }

    public String key() {
        if (null == this._key) {
            this._key = (String)_WOJExtensionsUtil.valueForBindingOrNull("key", this);
        }
        return this._key;
    }

    public String displayKey() {
        if (null == this._displayKey) {
            this._displayKey = (String)_WOJExtensionsUtil.valueForBindingOrNull("displayKey", this);
        }
        return this._displayKey;
    }

    public String imageName() {
        if (this._isCurrentKeyPrimary()) {
            NSSelector aCurrentState = this._primaryKeyOrderingSelector();
            if (aCurrentState == EOSortOrdering.CompareCaseInsensitiveAscending) {
                return "Ascending.gif";
            }
            if (aCurrentState == EOSortOrdering.CompareCaseInsensitiveDescending) {
                return "Descending.gif";
            }
        }
        return "Unsorted.gif";
    }

    public boolean _isCurrentKeyPrimary() {
        EOSortOrdering anOrdering = this._primaryOrdering();
        return anOrdering.key().equals(this.key());
    }

    public NSSelector _primaryKeyOrderingSelector() {
        EOSortOrdering anOrdering = this._primaryOrdering();
        return anOrdering.selector();
    }

    public EOSortOrdering _primaryOrdering() {
        NSArray anArray = this._sortOrderingArray();
        if (anArray.count() > 0) {
            EOSortOrdering anOrdering = (EOSortOrdering)anArray.objectAtIndex(0);
            return anOrdering;
        }
        return null;
    }

    protected NSArray _sortOrderingArray() {
        return (NSArray)_WOJExtensionsUtil.valueForBindingOrNull("sortOrderings", this);
    }

    protected NSMutableArray XX_sortOrderingArray() {
        WODisplayGroup displayGroup = this.displayGroup();
        NSArray orderingArray = null != displayGroup ? displayGroup.sortOrderings() : (NSArray)_WOJExtensionsUtil.valueForBindingOrNull("sortOrderings", this);
        orderingArray = null == orderingArray ? new NSMutableArray() : new NSMutableArray(orderingArray);
        if (null != displayGroup) {
            displayGroup.setSortOrderings(orderingArray);
        } else {
            this.setValueForBinding(orderingArray, "sortOrderings");
        }
        return (NSMutableArray)orderingArray;
    }

    protected void _removeOrderingWithKey(String aKey) {
        int anIndex = 0;
        NSArray orderingArray = this._sortOrderingArray();
        Enumeration anEnumerator = orderingArray.objectEnumerator();
        while (anEnumerator.hasMoreElements()) {
            EOSortOrdering ordering = (EOSortOrdering)anEnumerator.nextElement();
            if (aKey.equals(ordering.key())) {
                ((NSMutableArray)orderingArray).removeObjectAtIndex(anIndex);
                return;
            }
            ++anIndex;
        }
    }

    protected void _makePrimaryOrderingWithSelector(NSSelector aSelector) {
        NSMutableArray orderingArray = (NSMutableArray)this._sortOrderingArray();
        EOSortOrdering aNewOrdering = EOSortOrdering.sortOrderingWithKey((String)this.key(), (NSSelector)aSelector);
        orderingArray.insertObjectAtIndex((Object)aNewOrdering, 0);
        if (orderingArray.count() > 3) {
            orderingArray.removeLastObject();
        }
    }

    public String helpString() {
        return "Push to toggle sorting order according to " + this.displayKey();
    }

    public WOComponent toggleClicked() {
        if (this._isCurrentKeyPrimary()) {
            NSSelector aCurrentState = this._primaryKeyOrderingSelector();
            if (aCurrentState == EOSortOrdering.CompareCaseInsensitiveAscending) {
                this._removeOrderingWithKey(this.key());
                this._makePrimaryOrderingWithSelector(EOSortOrdering.CompareCaseInsensitiveDescending);
            } else if (aCurrentState == EOSortOrdering.CompareCaseInsensitiveDescending) {
                this._removeOrderingWithKey(this.key());
            }
        } else {
            this._removeOrderingWithKey(this.key());
            this._makePrimaryOrderingWithSelector(EOSortOrdering.CompareCaseInsensitiveAscending);
        }
        this.displayGroup().updateDisplayedObjects();
        return null;
    }
}

