/*
 * Decompiled with CFR 0.152.
 */
package er.taggable.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.components.ERXComponent;
import er.extensions.eof.ERXQ;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.taggable.ERTaggable;
import er.taggable.ERTaggableEntity;
import er.taggable.model.ERTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERTagField
extends ERXComponent {
    private String _id;
    private NSArray<String> _availableTags;
    private String _tags;
    private ERTaggable<?> _taggable;

    public ERTagField(WOContext context) {
        super(context);
    }

    protected void clearCacheIfNecessary() {
        ERTaggable<?> taggable = this.taggable();
        if (taggable == null || taggable != this._taggable && !taggable.equals(this._taggable)) {
            this._tags = null;
            this._availableTags = null;
            this._taggable = taggable;
        }
    }

    public ERTaggable<?> taggable() {
        return (ERTaggable)this.valueForBinding("taggable");
    }

    public String size() {
        String size = this.hasBinding("size") ? this.stringValueForBinding("size") : "60";
        return size;
    }

    public int minimum() {
        return this.intValueForBinding("minimum", -1);
    }

    public int limit() {
        return this.intValueForBinding("limit", -1);
    }

    public EOQualifier additionalQualifier() {
        return (EOQualifier)this.valueForBinding("additionalQualifier");
    }

    public NSArray<String> availableTags() {
        this.clearCacheIfNecessary();
        if (this._availableTags == null) {
            NSArray availableTags;
            EOEditingContext editingContext = this.taggable().item().editingContext();
            int minimum = this.minimum();
            int limit = this.limit();
            if (minimum == -1) {
                NSDictionary<String, Integer> tagCount = this.taggable().taggableEntity().tagCount(editingContext, limit, this.additionalQualifier());
                availableTags = tagCount.allKeys();
            } else {
                NSDictionary<String, Integer> tagCount = this.taggable().taggableEntity().tagCount(editingContext, ERXQ.GTEQ, minimum, limit, this.additionalQualifier());
                availableTags = tagCount.allKeys();
            }
            this._availableTags = ERXArrayUtilities.sortedArrayUsingComparator((NSArray)availableTags, (NSComparator)NSComparator.AscendingStringComparator);
        }
        return this._availableTags;
    }

    public String javascriptAvailableTags() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        NSMutableArray availableTags = this.availableTags().mutableClone();
        int availableTagsCount = availableTags.count();
        if (availableTagsCount > 0) {
            for (int tagNum = 0; tagNum < availableTagsCount; ++tagNum) {
                String availableTag = (String)availableTags.objectAtIndex(tagNum);
                availableTag = availableTag.replaceAll("'", "\\\\'");
                availableTag = ERTag.escapeTagNamed(availableTag);
                availableTags.replaceObjectAtIndex((Object)availableTag, tagNum);
            }
            sb.append("'");
            sb.append(availableTags.componentsJoinedByString("','"));
            sb.append("'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String tags() {
        this.clearCacheIfNecessary();
        if (this._tags != null) {
            // empty if block
        }
        String separator = " ";
        NSMutableArray tagNames = this.taggable().tagNames().mutableClone();
        if (ERTaggableEntity.isWhitespaceSeparator(separator)) {
            int tagsCount = tagNames.count();
            for (int tagNum = 0; tagNum < tagsCount; ++tagNum) {
                String tagName = (String)tagNames.objectAtIndex(tagNum);
                tagNames.replaceObjectAtIndex((Object)ERTag.escapeTagNamed(tagName), tagNum);
            }
        }
        this._tags = tagNames.componentsJoinedByString(separator);
        if (this._tags.length() > 0) {
            this._tags = this._tags + separator;
        }
        return this._tags;
    }

    public void setTags(String tags) {
        this.clearCacheIfNecessary();
        if (tags == null || tags != this._tags && !tags.equals(this._tags)) {
            this.taggable().setTags(tags);
            this._tags = tags;
            this._availableTags = null;
        }
    }

    public String id() {
        if (this._id == null) {
            this._id = this.stringValueForBinding("id");
            if (this._id == null) {
                this._id = ERXStringUtilities.safeIdentifierName((String)this.context().elementID());
            }
        }
        return this._id;
    }

    public String tagsID() {
        return this.id() + "_tags";
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"Ajax", (String)"prototype.js");
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"ERTaggable", (String)"ERTagField.js");
        ERXResponseRewriter.addStylesheetResourceInHead((WOResponse)response, (WOContext)context, (String)"ERTaggable", (String)"ERTagField.css");
        super.appendToResponse(response, context);
    }
}

