/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSSizeLimitedLinkedHashMap;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSFileUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSProperties
implements NSKeyValueCoding,
NSKeyValueCodingAdditions {
    public static final String PropertiesDidChange = "PropertiesDidChange";
    public static final String PropertiesKey = "properties";
    private static final String _def = "-D";
    private static final char _dqc = '\"';
    private static final String _dqs = "\"";
    private static final String _eqs = "=";
    private static final String _false = "false";
    private static final String _hyphen = "-";
    private static final String _no = "NO";
    private static final char _sqc = '\'';
    private static final String _sqs = "'";
    private static final String _true = "true";
    private static final String _yes = "YES";
    private static String _undefinedMarker;
    private static NSProperties _sharedInstance;
    private Map<String, Object> _cache;
    private NSSizeLimitedLinkedHashMap<String, String> _appSpecificPropertyNames;
    private String _appName;
    private InitialContext _jndiContext;
    private Properties _jndiProperties;
    private static String _mainBundleName;

    static {
        NSProperties properties;
        _undefinedMarker = "-undefined-";
        String propertiesClassName = System.getProperty("NSProperties.className");
        if (propertiesClassName == null) {
            properties = new NSProperties();
        } else {
            try {
                properties = Class.forName(propertiesClassName).asSubclass(NSProperties.class).newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to create an NSProperties with the class named '" + propertiesClassName + "'.", t);
            }
        }
        if (NSValueUtilities.booleanValueWithDefault(System.getProperty("NSProperties.cacheEnabled"), false)) {
            properties.setCachingEnabled(true);
        }
        NSProperties.setSharedInstance(properties);
        _mainBundleName = null;
    }

    protected NSProperties() {
        this.initializeProperties();
    }

    protected void initializeProperties() {
        Properties jndiProperties;
        InitialContext ctx;
        try {
            ctx = new InitialContext();
            NamingEnumeration<NameClassPair> list = ctx.list("java:comp/env/wo");
            jndiProperties = new Properties();
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                String name = pair.isRelative() ? "java:comp/env/wo/" + pair.getName() : pair.getName();
                Object obj = ctx.lookup(name);
                jndiProperties.setProperty(pair.getName(), obj.toString());
            }
        }
        catch (NamingException e) {
            ctx = null;
            jndiProperties = null;
        }
        this._jndiProperties = jndiProperties;
        this._jndiContext = ctx;
        this._appSpecificPropertyNames = new NSSizeLimitedLinkedHashMap(128, false, null);
    }

    public static NSProperties sharedInstance() {
        return _sharedInstance;
    }

    public static void setSharedInstance(NSProperties sharedInstance) {
        if (_sharedInstance != null) {
            _sharedInstance.unregisterForNotifications();
        }
        if ((_sharedInstance = sharedInstance) != null) {
            _sharedInstance.registerForNotifications();
        }
    }

    public Object _removePropertyForKey(String key) {
        if (this._jndiContext == null) {
            return System.getProperties().remove(key);
        }
        return this._jndiProperties.remove(key);
    }

    public Object _setPropertyForKey(String value, String key) {
        if (this._jndiContext == null) {
            return System.setProperty(key, value);
        }
        return this._jndiProperties.setProperty(key, value);
    }

    public void _replaceProperties(Properties props) {
        if (this._jndiContext == null) {
            System.setProperties(props);
        } else {
            this._jndiProperties = props;
        }
    }

    public Properties _properties() {
        Properties ret = this._jndiContext == null ? System.getProperties() : this._jndiProperties;
        return ret;
    }

    public String _propertyForKeyWithDefault(String key, String defaultValue) {
        String value = null;
        if (this._jndiContext != null) {
            value = this._jndiProperties.getProperty(key);
        }
        if (value == null && (value = System.getProperty(key)) == null) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removePropertyForKey(String key) {
        String actualKey = this._applicationSpecificKey(key);
        if (this._cache != null) {
            this._cache.remove(actualKey);
        }
        NSSizeLimitedLinkedHashMap<String, String> nSSizeLimitedLinkedHashMap = this._appSpecificPropertyNames;
        synchronized (nSSizeLimitedLinkedHashMap) {
            if (!this._appSpecificPropertyNames.isEmpty()) {
                this._appSpecificPropertyNames.clear();
            }
        }
        return this._removePropertyForKey(actualKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setPropertyForKey(String value, String key) {
        String actualKey = this._applicationSpecificKey(key);
        if (this._cache != null) {
            this._cache.remove(actualKey);
        }
        NSSizeLimitedLinkedHashMap<String, String> nSSizeLimitedLinkedHashMap = this._appSpecificPropertyNames;
        synchronized (nSSizeLimitedLinkedHashMap) {
            if (!this._appSpecificPropertyNames.isEmpty()) {
                this._appSpecificPropertyNames.clear();
            }
        }
        return this._setPropertyForKey(value, actualKey);
    }

    public void replaceProperties(Properties props) {
        this._replaceProperties(props);
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    public Properties properties() {
        return this._properties();
    }

    public String propertyForKeyWithDefault(String key, String defaultValue) {
        String actualKey = this._applicationSpecificKey(key);
        return this._propertyForKeyWithDefault(actualKey, defaultValue);
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        if (cachingEnabled) {
            if (this._cache == null) {
                this._cache = Collections.synchronizedMap(new HashMap());
            }
        } else {
            this._cache = null;
        }
    }

    protected void registerForNotifications() {
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("propertiesChanged", new Class[]{NSNotification.class}), PropertiesDidChange, null);
    }

    protected void unregisterForNotifications() {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this, PropertiesDidChange, null);
    }

    public void propertiesChanged(NSNotification notification) {
        NSDictionary userInfo = notification.userInfo();
        if (userInfo == null) {
            this.clearCache();
        } else {
            NSArray propertyKeys = (NSArray)userInfo.objectForKey((Object)PropertiesKey);
            if (propertyKeys == null) {
                this.clearCache();
            } else {
                for (String key : propertyKeys) {
                    this.clearCacheForKey(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        NSSizeLimitedLinkedHashMap<String, String> nSSizeLimitedLinkedHashMap = this._appSpecificPropertyNames;
        synchronized (nSSizeLimitedLinkedHashMap) {
            this._appSpecificPropertyNames.clear();
        }
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    public void clearCacheForKey(String key) {
        if (this._cache != null) {
            String actualKey = this._applicationSpecificKey(key);
            this._cache.remove(actualKey);
        }
    }

    public void setCachedObjectForKey(Object value, String key) {
        if (this._cache != null) {
            String actualKey = this._applicationSpecificKey(key);
            this._cache.put(actualKey, value == null ? _undefinedMarker : value);
        }
    }

    public Object cachedObjectForKey(String key) {
        String actualKey = this._applicationSpecificKey(key);
        Object value = null;
        if (this._cache != null) {
            value = this._cache.get(actualKey);
        }
        if (value == null) {
            value = this._propertyForKeyWithDefault(actualKey, null);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setAppName(String appName) {
        this._appName = appName;
        NSSizeLimitedLinkedHashMap<String, String> nSSizeLimitedLinkedHashMap = this._appSpecificPropertyNames;
        synchronized (nSSizeLimitedLinkedHashMap) {
            this._appSpecificPropertyNames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _applicationSpecificKey(String key) {
        NSSizeLimitedLinkedHashMap<String, String> nSSizeLimitedLinkedHashMap = this._appSpecificPropertyNames;
        synchronized (nSSizeLimitedLinkedHashMap) {
            String appSpecificPropertyName = (String)this._appSpecificPropertyNames.get(key);
            if (appSpecificPropertyName == null) {
                appSpecificPropertyName = this._appName != null ? String.valueOf(key) + "." + this._appName : key;
                String value = this._propertyForKeyWithDefault(appSpecificPropertyName, null);
                if (value == null) {
                    appSpecificPropertyName = key;
                }
                this._appSpecificPropertyNames.put(key, appSpecificPropertyName);
            }
            return appSpecificPropertyName;
        }
    }

    public void takeValueForKey(Object value, String key) {
        if (value == null) {
            this.removePropertyForKey(key);
        } else {
            this.setPropertyForKey((String)value, key);
        }
    }

    public Object valueForKey(String key) {
        return this.propertyForKeyWithDefault(key, null);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        this.takeValueForKey(value, keyPath);
    }

    public Object valueForKeyPath(String keyPath) {
        return this.valueForKey(keyPath);
    }

    public static void _setProperties(Properties props) {
        NSProperties.sharedInstance().replaceProperties(props);
    }

    public static Object _setProperty(String name, String value) {
        return NSProperties.sharedInstance().setPropertyForKey(value, name);
    }

    public static Properties _getProperties() {
        return NSProperties.sharedInstance().properties();
    }

    public static String getProperty(String name) {
        return NSProperties.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        return NSProperties.sharedInstance().propertyForKeyWithDefault(name, defaultValue);
    }

    public static NSArray arrayForKey(String aKey) {
        return NSProperties.arrayForKeyWithDefault(aKey, null);
    }

    public static NSArray arrayForKeyWithDefault(String aKey, NSArray defaultValue) {
        NSArray value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof NSArray) {
            value = (NSArray)cachedValue;
        } else {
            value = NSValueUtilities.arrayValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(value, aKey);
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static NSSet setForKey(String aKey) {
        return NSProperties.setForKeyWithDefault(aKey, null);
    }

    public static NSSet setForKeyWithDefault(String aKey, NSSet defaultValue) {
        NSSet value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof NSSet) {
            value = (NSSet)cachedValue;
        } else {
            value = NSValueUtilities.setValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(value, aKey);
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static boolean booleanForKey(String aKey) {
        return NSProperties.booleanForKeyWithDefault(aKey, false);
    }

    public static boolean booleanForKeyWithDefault(String aKey, boolean defaultValue) {
        boolean value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Boolean) {
            value = (Boolean)cachedValue;
        } else {
            Boolean objValue = NSValueUtilities.BooleanValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(objValue, aKey);
            value = objValue == null ? defaultValue : objValue;
        }
        return value;
    }

    public static NSData dataForKey(String aKey) {
        return NSProperties.dataForKeyWithDefault(aKey, null);
    }

    public static NSData dataForKeyWithDefault(String aKey, NSData defaultValue) {
        NSData value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof NSData) {
            value = (NSData)cachedValue;
        } else {
            value = NSValueUtilities.dataValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(value, aKey);
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static NSDictionary dictionaryForKey(String aKey) {
        return NSProperties.dictionaryForKeyWithDefault(aKey, null);
    }

    public static NSDictionary dictionaryForKeyWithDefault(String aKey, NSDictionary defaultValue) {
        NSDictionary value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof NSDictionary) {
            value = (NSDictionary)cachedValue;
        } else {
            value = NSValueUtilities.dictionaryValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(value, aKey);
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static double doubleForKey(String aKey) {
        return NSProperties.doubleForKeyWithDefault(aKey, 0.0);
    }

    public static double doubleForKeyWithDefault(String aKey, double defaultValue) {
        double value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Double) {
            value = (Double)cachedValue;
        } else {
            Double objValue = NSValueUtilities.DoubleValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(objValue, aKey);
            value = objValue == null ? defaultValue : objValue;
        }
        return value;
    }

    public static float floatForKey(String aKey) {
        return NSProperties.floatForKeyWithDefault(aKey, 0.0f);
    }

    public static float floatForKeyWithDefault(String aKey, float defaultValue) {
        float value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Float) {
            value = ((Float)cachedValue).floatValue();
        } else {
            Float objValue = NSValueUtilities.FloatValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(objValue, aKey);
            value = objValue == null ? defaultValue : objValue.floatValue();
        }
        return value;
    }

    public static int integerForKey(String aKey) {
        return NSProperties.intForKey(aKey);
    }

    public static int integerForKeyWithDefault(String aKey, int defaultValue) {
        return NSProperties.intForKeyWithDefault(aKey, defaultValue);
    }

    public static int intForKey(String aKey) {
        return NSProperties.intForKeyWithDefault(aKey, 0);
    }

    public static int intForKeyWithDefault(String aKey, int defaultValue) {
        int value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Integer) {
            value = (Integer)cachedValue;
        } else {
            Integer objValue = NSValueUtilities.IntegerValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(objValue, aKey);
            value = objValue == null ? defaultValue : objValue;
        }
        return value;
    }

    public static <T> Class<T> classForKey(String aKey) {
        return NSProperties.classForKeyWithDefault(aKey, null);
    }

    public static <T> Class<T> classForKeyWithDefault(String aKey, Class<T> defaultValue) {
        Class value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Class) {
            value = (Class)cachedValue;
        } else if (cachedValue == null) {
            value = defaultValue;
            properties.setCachedObjectForKey(null, aKey);
        } else if (cachedValue instanceof String) {
            String strValue = (String)cachedValue;
            if (strValue.length() > 0) {
                value = _NSUtilities.classWithName((String)cachedValue);
                if (value == null) {
                    throw new IllegalArgumentException("Failed to load the class named '" + cachedValue + "'.");
                }
                properties.setCachedObjectForKey(value, aKey);
            } else {
                value = defaultValue;
                properties.setCachedObjectForKey(null, aKey);
            }
        } else {
            throw new IllegalArgumentException("Failed to parse a class name from the value '" + cachedValue + "'.");
        }
        return value;
    }

    public static long longForKey(String aKey) {
        return NSProperties.longForKeyWithDefault(aKey, 0L);
    }

    public static long longForKeyWithDefault(String aKey, long defaultValue) {
        long value;
        NSProperties properties = NSProperties.sharedInstance();
        Object cachedValue = properties.cachedObjectForKey(aKey);
        if (cachedValue == _undefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Long) {
            value = (Long)cachedValue;
        } else {
            Long objValue = NSValueUtilities.LongValueWithDefault(cachedValue, null);
            properties.setCachedObjectForKey(objValue, aKey);
            value = objValue == null ? defaultValue : objValue;
        }
        return value;
    }

    public static void setPropertiesFromArgv(String[] argv) {
        try {
            Class.forName("com.webobjects.foundation.NSBundle");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (argv != null) {
            NSProperties.insertCommandLineArguments(argv);
        }
    }

    public static String stringForKey(String aKey) {
        return NSProperties.sharedInstance().propertyForKeyWithDefault(aKey, null);
    }

    public static String stringForKeyWithDefault(String aKey, String defaultValue) {
        return NSProperties.sharedInstance().propertyForKeyWithDefault(aKey, defaultValue);
    }

    public static NSDictionary valuesFromArgv(String[] argv) {
        int argCount = argv.length;
        NSMutableDictionary values = new NSMutableDictionary(argCount);
        int i = 0;
        while (i < argCount) {
            String argumentValue;
            String argumentName;
            int indexOfEqualSign;
            String argument = argv[i];
            int argumentLength = argument.length();
            boolean argIsQuoted = argument.startsWith(_dqs) && argument.endsWith(_dqs) || argument.startsWith(_sqs) && argument.endsWith(_sqs);
            boolean hasBeenParsed = false;
            if ((argIsQuoted ? argument.indexOf(_def) == 1 : argument.startsWith(_def)) && (indexOfEqualSign = argument.indexOf(_eqs)) != -1 && (argIsQuoted ? indexOfEqualSign < argumentLength - 2 && indexOfEqualSign > 3 : indexOfEqualSign < argumentLength && indexOfEqualSign > 2)) {
                if (argIsQuoted) {
                    argumentName = argument.substring(3, indexOfEqualSign);
                    argumentValue = argument.substring(indexOfEqualSign + 1, argumentLength - 1);
                } else {
                    boolean valIsQuoted = indexOfEqualSign < argumentLength - 2 && (argument.charAt(indexOfEqualSign + 1) == '\"' && argument.endsWith(_dqs) || argument.charAt(indexOfEqualSign + 1) == '\'' && argument.endsWith(_sqs));
                    argumentName = argument.substring(2, indexOfEqualSign);
                    argumentValue = valIsQuoted ? argument.substring(indexOfEqualSign + 2, argumentLength - 1) : argument.substring(indexOfEqualSign + 1, argumentLength);
                }
                values.setObjectForKey((Object)argumentValue, (Object)argumentName);
                hasBeenParsed = true;
            }
            if (!hasBeenParsed && argument.startsWith(_hyphen) && argument.length() > 1) {
                argumentName = argument.substring(1);
                if (i + 1 < argCount) {
                    argumentValue = argv[i + 1];
                    ++i;
                    if (argumentValue.equalsIgnoreCase(_yes) || argumentValue.equalsIgnoreCase(_true)) {
                        argumentValue = _true;
                    } else if (argumentValue.equalsIgnoreCase(_no) || argumentValue.equalsIgnoreCase(_false)) {
                        argumentValue = _false;
                    }
                    values.setObjectForKey((Object)argumentValue, (Object)argumentName);
                }
            }
            ++i;
        }
        return values;
    }

    private static void insertCommandLineArguments(String[] argv) {
        NSDictionary values = NSProperties.valuesFromArgv(argv);
        NSArray keys = values.allKeys();
        int count = keys.count();
        int i = 0;
        while (i < count) {
            Object key = keys.objectAtIndex(i);
            NSProperties._setProperty((String)key, (String)values.objectForKey(key));
            ++i;
        }
    }

    public static void _setMainBundleName(String name) {
        _mainBundleName = name;
    }

    public static String _mainBundleName() {
        return _mainBundleName;
    }

    public static boolean _shouldRequireSymlinkedGlobalAndIncludeProperties() {
        return Boolean.valueOf(System.getProperty("NSRequireSymlinkedGlobalAndIncludeProperties", _false));
    }

    public static class NestedProperties
    extends Properties {
        public static final String IncludePropsSoFarKey = ".includePropsSoFar";
        public static final String IncludePropsKey = ".includeProps";
        private Stack<File> _files = new Stack();

        public NestedProperties() {
        }

        public NestedProperties(Properties defaults) {
            super(defaults);
        }

        public synchronized Object put(Object key, Object value) {
            if (IncludePropsKey.equals(key)) {
                String propsPath;
                String propsFileName = (String)value;
                File propsFile = new File(propsFileName);
                if (!propsFile.isAbsolute()) {
                    File cwd = null;
                    cwd = this._files.size() > 0 ? this._files.peek() : new File(System.getProperty("user.home"));
                    propsFile = new File(cwd, propsFileName);
                }
                try {
                    propsPath = propsFile.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to canonicalize the property file '" + propsFile + "'.", e);
                }
                String existingIncludeProps = this.getProperty(IncludePropsSoFarKey);
                if (existingIncludeProps == null) {
                    existingIncludeProps = "";
                }
                if (existingIncludeProps.indexOf(propsPath) > -1) {
                    NSLog.err.appendln((Object)("NSProperties.NestedProperties.load(): Possible recursive includeProps detected. '" + propsPath + "' was included in more than one of the following files: " + existingIncludeProps));
                    NSLog.err.appendln((Object)"NSProperties.NestedProperties.load() cannot proceed - QUITTING!");
                    System.exit(1);
                }
                if (existingIncludeProps.length() > 0) {
                    existingIncludeProps = String.valueOf(existingIncludeProps) + ", ";
                }
                existingIncludeProps = String.valueOf(existingIncludeProps) + propsPath;
                super.put(IncludePropsSoFarKey, existingIncludeProps);
                try {
                    this.load(propsFile, NSProperties._shouldRequireSymlinkedGlobalAndIncludeProperties());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load the property file '" + value + "'.", e);
                }
                return null;
            }
            return super.put(key, value);
        }

        public synchronized void load(File propsFile, boolean requireSymlink) throws IOException {
            NSLog.out.appendln((Object)("NSProperties.NestedProperties.load(): " + propsFile));
            File canonicalPropsFile = requireSymlink ? _NSFileUtilities.resolveLink(propsFile.getPath(), propsFile.getName()) : propsFile.getCanonicalFile();
            this._files.push(canonicalPropsFile.getParentFile());
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(canonicalPropsFile));
                try {
                    this.load(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                this._files.pop();
            }
        }
    }
}

