/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.util;

import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.ajax.example2.helper.NSTimestampHelper;
import er.ajax.example2.util.Day;
import er.ajax.example2.util.DurationNamer;
import er.extensions.eof.ERXQ;
import er.extensions.qualifiers.ERXAndQualifier;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import er.extensions.qualifiers.ERXOrQualifier;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtils {
    public static final NSTimestampFormatter MONTH_NAME_AND_YEAR_FORMATTER = new NSTimestampFormatter("%B %Y");
    public static final NSTimestampFormatter MONTH_NAME_FORMATTER = new NSTimestampFormatter("%B");
    public static final NSTimestampFormatter SHORT_MONTH_NAME_FORMATTER = new NSTimestampFormatter("%b");
    public static final NSTimestampFormatter SHORT_MONTH_NAME_AND_YEAR_FORMATTER = new NSTimestampFormatter("%b %y");
    public static final NSTimestampFormatter SHORT_MONTH_NAME_AND_DAY_OF_WEEK_AND_YEAR_FORMATTER = new NSTimestampFormatter("%a, %b %d %y");
    public static final NSTimestampFormatter SHORT_MONTH_NAME_AND_DAY_OF_WEEK_FORMATTER = new NSTimestampFormatter("%a, %b %d");
    public static final NSTimestampFormatter SHORT_TIME_FORMATTER = new NSTimestampFormatter("%I:%M%p");
    public static final NSTimestampFormatter URL_FRIENDLY_FORMATTER = new NSTimestampFormatter("%Y%m%dT%H%M%S");
    public static final String[] DAYS_OF_WEEK = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public static EOQualifier dateWithinKeypathRangeQualifier(String startDateKey, String endDateKey, NSTimestamp date, boolean exclusive) {
        NSMutableArray startQualifiers = new NSMutableArray();
        if (exclusive) {
            startQualifiers.addObject((Object)new ERXKeyValueQualifier(startDateKey, EOQualifier.QualifierOperatorLessThan, (Object)date));
        } else {
            startQualifiers.addObject((Object)new ERXKeyValueQualifier(startDateKey, EOQualifier.QualifierOperatorEqual, null));
            startQualifiers.addObject((Object)new ERXKeyValueQualifier(startDateKey, EOQualifier.QualifierOperatorLessThanOrEqualTo, (Object)date));
        }
        ERXOrQualifier startQualifier = new ERXOrQualifier((NSArray)startQualifiers);
        NSMutableArray endQualifiers = new NSMutableArray();
        if (exclusive) {
            endQualifiers.addObject((Object)new ERXKeyValueQualifier(endDateKey, EOQualifier.QualifierOperatorGreaterThan, (Object)date));
        } else {
            endQualifiers.addObject((Object)new ERXKeyValueQualifier(endDateKey, EOQualifier.QualifierOperatorEqual, null));
            endQualifiers.addObject((Object)new ERXKeyValueQualifier(endDateKey, EOQualifier.QualifierOperatorGreaterThanOrEqualTo, (Object)date));
        }
        ERXOrQualifier endQualifier = new ERXOrQualifier((NSArray)endQualifiers);
        ERXAndQualifier qualifier = new ERXAndQualifier(new NSArray((Object[])new EOQualifier[]{startQualifier, endQualifier}));
        return qualifier;
    }

    public static EOQualifier dateRangeOverlapsKeypathRangeQualifier(String startDateKey, String endDateKey, NSTimestamp startDate, NSTimestamp endDate, boolean exclusive) {
        if (endDate == null) {
            return DateUtils.dateWithinKeypathRangeQualifier(startDateKey, endDateKey, startDate, exclusive);
        }
        if (startDate == null) {
            return DateUtils.dateWithinKeypathRangeQualifier(startDateKey, endDateKey, endDate, exclusive);
        }
        if (endDate.before((Timestamp)startDate)) {
            throw new IllegalArgumentException("End date must be after start date (start date = " + startDate + ", end date = " + endDate + ")");
        }
        ERXKeyValueQualifier startKeyBeforeStartDate = ERXQ.lessThan((String)startDateKey, (Object)startDate);
        ERXKeyValueQualifier startKeyBeforeEndDate = ERXQ.lessThan((String)startDateKey, (Object)endDate);
        ERXKeyValueQualifier startKeyOnStartDate = ERXQ.equals((String)startDateKey, (Object)startDate);
        ERXKeyValueQualifier startKeyOnEndDate = ERXQ.equals((String)startDateKey, (Object)endDate);
        ERXKeyValueQualifier startKeyAfterStartDate = ERXQ.greaterThan((String)startDateKey, (Object)startDate);
        ERXKeyValueQualifier startKeyAfterEndDate = ERXQ.greaterThan((String)startDateKey, (Object)endDate);
        ERXKeyValueQualifier endKeyBeforeStartDate = ERXQ.lessThan((String)endDateKey, (Object)startDate);
        ERXKeyValueQualifier endKeyBeforeEndDate = ERXQ.lessThan((String)endDateKey, (Object)endDate);
        ERXKeyValueQualifier endKeyOnStartDate = ERXQ.equals((String)endDateKey, (Object)startDate);
        ERXKeyValueQualifier endKeyOnEndDate = ERXQ.equals((String)endDateKey, (Object)endDate);
        ERXKeyValueQualifier endKeyAfterStartDate = ERXQ.greaterThan((String)endDateKey, (Object)startDate);
        ERXKeyValueQualifier endKeyAfterEndDate = ERXQ.greaterThan((String)endDateKey, (Object)endDate);
        ERXAndQualifier aroundStart = ERXQ.and((EOQualifier[])new EOQualifier[]{startKeyAfterStartDate, startKeyBeforeEndDate});
        ERXAndQualifier endsAtStart = ERXQ.and((EOQualifier[])new EOQualifier[]{startKeyAfterStartDate, startKeyOnEndDate});
        ERXAndQualifier surrounding = ERXQ.and((EOQualifier[])new EOQualifier[]{startKeyBeforeStartDate, endKeyAfterEndDate});
        ERXAndQualifier directlyOverlapping = ERXQ.and((EOQualifier[])new EOQualifier[]{startKeyOnStartDate, endKeyOnEndDate});
        ERXAndQualifier inBetween = ERXQ.and((EOQualifier[])new EOQualifier[]{startKeyBeforeStartDate, endKeyAfterStartDate, endKeyAfterStartDate, endKeyAfterEndDate});
        ERXAndQualifier aroundEnd = ERXQ.and((EOQualifier[])new EOQualifier[]{endKeyAfterStartDate, endKeyBeforeEndDate});
        ERXAndQualifier startsAtEnd = ERXQ.and((EOQualifier[])new EOQualifier[]{endKeyOnStartDate, endKeyBeforeEndDate});
        ERXOrQualifier qualifier = exclusive ? ERXQ.or((EOQualifier[])new EOQualifier[]{aroundStart, surrounding, directlyOverlapping, inBetween, aroundEnd}) : ERXQ.or((EOQualifier[])new EOQualifier[]{aroundStart, startKeyOnStartDate, endKeyOnStartDate, endsAtStart, surrounding, directlyOverlapping, inBetween, aroundEnd, endKeyOnEndDate, startsAtEnd, startKeyOnEndDate});
        return qualifier;
    }

    public static EOQualifier keypathWithinDateRangeQualifier(String _startDateKey, NSTimestamp _startDate, NSTimestamp _endDate) {
        if (_startDate != null) {
            if (_endDate != null) {
                ERXKeyValueQualifier qualifier1 = new ERXKeyValueQualifier(_startDateKey, EOQualifier.QualifierOperatorGreaterThanOrEqualTo, (Object)_startDate);
                ERXKeyValueQualifier qualifier2 = new ERXKeyValueQualifier(_startDateKey, EOQualifier.QualifierOperatorLessThanOrEqualTo, (Object)_endDate);
                return new ERXAndQualifier(new NSArray((Object[])new EOQualifier[]{qualifier1, qualifier2}));
            }
            return new ERXKeyValueQualifier(_startDateKey, EOQualifier.QualifierOperatorGreaterThanOrEqualTo, (Object)_startDate);
        }
        if (_endDate != null) {
            return new ERXKeyValueQualifier(_startDateKey, EOQualifier.QualifierOperatorLessThanOrEqualTo, (Object)_endDate);
        }
        return null;
    }

    public static NSTimestamp timestamp(int _year, int _month, int _day, int _hour, int _minute, int _second, int _millisecond) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, _year);
        cal.set(2, _month - 1);
        cal.set(5, _day);
        cal.set(11, _hour);
        cal.set(12, _minute);
        cal.set(13, _second);
        cal.set(14, _millisecond);
        NSTimestamp timestamp = new NSTimestamp(cal.getTime().getTime());
        return timestamp;
    }

    public static NSArray years(int _offset, int _count) {
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        return DateUtils.years(year, _offset, _count);
    }

    public static NSArray<Integer> years(int _year, int _offset, int _count) {
        NSMutableArray years = new NSMutableArray();
        for (int i = 0; i < _count; ++i) {
            years.addObject((Object)new Integer(_year + _offset + i));
        }
        return years;
    }

    public static int getDurationInDays(Day _startDay, Day _endDay, boolean _inWeekDaysOnly) {
        int days = 0;
        Calendar start = _startDay.startCalendar();
        Calendar end = _endDay.startCalendar();
        while (!start.after(end)) {
            boolean weekend;
            int dayOfWeek = start.get(7);
            boolean bl = weekend = dayOfWeek == 1 || dayOfWeek == 7;
            if (!_inWeekDaysOnly || !weekend) {
                ++days;
            }
            start.add(5, 1);
        }
        return days;
    }

    public static String getDurationAsString(NSTimestamp _startTime, NSTimestamp _endTime) {
        StringBuffer buff = new StringBuffer();
        long seconds = DateUtils.getDurationInSeconds(_startTime, _endTime);
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        buff.append(hours);
        buff.append(":");
        buff.append(minutes);
        buff.append(":");
        buff.append(seconds % 60L);
        return buff.toString();
    }

    public static long getDurationInDays(NSTimestamp _startTime, NSTimestamp _endTime) {
        Calendar start = DateUtils.getCalendarFromTimestamp((Date)_startTime);
        Calendar end = DateUtils.getCalendarFromTimestamp((Date)_endTime);
        long millis = end.getTimeInMillis() - start.getTimeInMillis();
        return millis / 1000L / 60L / 60L / 24L;
    }

    public static long getDurationInHours(NSTimestamp _startTime, NSTimestamp _endTime) {
        Calendar start = DateUtils.getCalendarFromTimestamp((Date)_startTime);
        Calendar end = DateUtils.getCalendarFromTimestamp((Date)_endTime);
        long millis = end.getTimeInMillis() - start.getTimeInMillis();
        return millis / 1000L / 60L / 60L;
    }

    public static long getDurationInMinutes(NSTimestamp _startTime, NSTimestamp _endTime) {
        Calendar start = DateUtils.getCalendarFromTimestamp((Date)_startTime);
        Calendar end = DateUtils.getCalendarFromTimestamp((Date)_endTime);
        long seconds = end.getTimeInMillis() - start.getTimeInMillis();
        return seconds / 1000L / 60L;
    }

    public static long getDurationInSeconds(NSTimestamp _startTime, NSTimestamp _endTime) {
        Calendar start = DateUtils.getCalendarFromTimestamp((Date)_startTime);
        Calendar end = DateUtils.getCalendarFromTimestamp((Date)_endTime);
        long seconds = end.getTimeInMillis() - start.getTimeInMillis();
        return seconds / 1000L;
    }

    public static Calendar getCalendarFromTimestamp(Date timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        return cal;
    }

    public static NSTimestamp daysFrom(int numberOfDays, Date timestamp) {
        Calendar cal = DateUtils.getCalendarFromTimestamp(timestamp);
        cal.add(5, numberOfDays);
        return new NSTimestamp(cal.getTime());
    }

    public static boolean isOnTheSameDay(NSTimestamp aTime, NSTimestamp anotherTime) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime((Date)aTime);
        cal2.setTime((Date)anotherTime);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static int difference(NSTimestamp start, NSTimestamp end, int calendarField) {
        Calendar startCal;
        Calendar endCal;
        if (start.after((Timestamp)end)) {
            endCal = DateUtils.getCalendarFromTimestamp((Date)start);
            startCal = DateUtils.getCalendarFromTimestamp((Date)end);
        } else {
            startCal = DateUtils.getCalendarFromTimestamp((Date)start);
            endCal = DateUtils.getCalendarFromTimestamp((Date)end);
        }
        long startMillis = startCal.getTimeInMillis();
        long endMillis = endCal.getTimeInMillis();
        double diffMillis = endMillis - startMillis;
        double skipRateDouble = 10.0;
        if (calendarField == 0) {
            skipRateDouble = diffMillis / 3.1536E10;
        } else if (calendarField == 1) {
            skipRateDouble = diffMillis / 3.1536E10;
        } else if (calendarField == 2) {
            skipRateDouble = diffMillis / 2.592E9;
        } else if (calendarField == 3) {
            skipRateDouble = diffMillis / 6.048E8;
        } else if (calendarField == 4) {
            skipRateDouble = diffMillis / 6.048E8;
        } else if (calendarField == 5) {
            skipRateDouble = diffMillis / 8.64E7;
        } else if (calendarField == 5) {
            skipRateDouble = diffMillis / 8.64E7;
        } else if (calendarField == 6) {
            skipRateDouble = diffMillis / 8.64E7;
        } else if (calendarField == 7) {
            skipRateDouble = diffMillis / 8.64E7;
        } else if (calendarField == 8) {
            skipRateDouble = diffMillis / 8.64E7;
        } else if (calendarField == 9) {
            skipRateDouble = diffMillis / 4.32E7;
        } else if (calendarField == 10) {
            skipRateDouble = diffMillis / 3600000.0;
        } else if (calendarField == 11) {
            skipRateDouble = diffMillis / 3600000.0;
        } else if (calendarField == 12) {
            skipRateDouble = diffMillis / 60000.0;
        } else if (calendarField == 13) {
            skipRateDouble = diffMillis / 1000.0;
        } else if (calendarField == 14) {
            skipRateDouble = diffMillis;
        } else {
            throw new IllegalArgumentException("Unknown calendar field: " + calendarField + ".");
        }
        boolean done = false;
        int skipRate = (int)Math.max(skipRateDouble, 1.0);
        int difference = 0;
        while (true) {
            if (startCal.before(endCal) || startCal.equals(endCal)) {
                startCal.add(calendarField, skipRate);
                difference += skipRate;
                continue;
            }
            if (skipRate > 1) {
                difference -= skipRate;
                startCal.add(calendarField, -skipRate);
                skipRate = (int)((double)skipRate - Math.ceil((double)skipRate / 2.0));
                skipRate = Math.max(skipRate, 1);
            } else {
                done = true;
            }
            if (done) break;
        }
        return difference;
    }

    public static String timestampString(NSTimestamp timestamp, boolean includeTime) {
        String timestampString = includeTime ? (timestamp != null ? new NSTimestampHelper().format(timestamp) : "") : (timestamp != null ? new NSTimestampHelper().mdy(timestamp) : "");
        return timestampString;
    }

    public static String timeFrom(NSTimestamp time, NSTimestamp baseTime) {
        return DurationNamer.timeFrom(time, baseTime);
    }

    public static String timeFromNow(NSTimestamp time) {
        return DurationNamer.timeFromNow(time);
    }

    public static NSArray<Day> daysBetween(NSTimestamp start, NSTimestamp end) {
        if (start == null && end == null) {
            throw new IllegalArgumentException("Both start and end dates cannot be null");
        }
        if (start == null) {
            return new NSArray((Object)new Day(end));
        }
        if (end == null) {
            return new NSArray((Object)new Day(start));
        }
        if (DateUtils.isOnTheSameDay(start, end)) {
            return new NSArray((Object)new Day(start));
        }
        if (end.before((Timestamp)start)) {
            NSTimestamp temp = start;
            start = end;
            end = temp;
        }
        NSMutableArray dates = new NSMutableArray();
        Day loopDay = new Day(start);
        Day startDay = new Day(start);
        Day endDay = new Day(end);
        while (loopDay.before(endDay)) {
            dates.addObject((Object)loopDay);
            loopDay = loopDay.next();
        }
        dates.addObject((Object)endDay);
        return dates;
    }

    public static String durationStringForURL(NSTimestamp start, NSTimestamp end) {
        int minutes = DateUtils.difference(start, end, 12);
        int hours = minutes / 60;
        String results = "";
        results = results + String.format("%02d", hours);
        results = results + String.format("%02d", minutes %= 60);
        return results;
    }

    public static void main(String[] args) {
        NSTimestamp start = new NSTimestamp();
        NSTimestamp end = new NSTimestamp().timestampByAddingGregorianUnits(0, 0, 0, 0, 15, 0);
        System.out.println("start: " + start);
        System.out.println("end: " + end);
        System.out.println("duration: " + DateUtils.durationStringForURL(start, end));
    }

    public static NSTimestamp nearestQuarterHour(NSTimestamp time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)time);
        int minute = cal.get(12);
        int base = minute / 15;
        minute = minute % 15 > 7 ? 15 : 0;
        cal.set(12, base * 15 + minute);
        return new NSTimestamp(cal.getTime());
    }

    public static NSTimestamp set(NSTimestamp timestamp, int calendarField, int value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)timestamp);
        cal.set(calendarField, value);
        return new NSTimestamp(cal.getTime());
    }

    public static NSTimestamp add(NSTimestamp timestamp, int calendarField, int value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)timestamp);
        cal.add(calendarField, value);
        return new NSTimestamp(cal.getTime());
    }

    static {
        MONTH_NAME_AND_YEAR_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        MONTH_NAME_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        SHORT_MONTH_NAME_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        SHORT_MONTH_NAME_AND_YEAR_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        SHORT_MONTH_NAME_AND_DAY_OF_WEEK_AND_YEAR_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        SHORT_MONTH_NAME_AND_DAY_OF_WEEK_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        SHORT_TIME_FORMATTER.setDefaultFormatTimeZone(NSTimeZone.getGMT());
    }
}

