/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.example2.util;

import com.webobjects.foundation.NSTimestamp;
import er.ajax.example2.helper.StringHelper;
import er.ajax.example2.util.DateUtils;
import java.sql.Timestamp;

public class DurationNamer {
    public static String timeFrom(NSTimestamp time, NSTimestamp baseTime) {
        StringBuffer results = new StringBuffer();
        StringHelper helper = new StringHelper();
        int years = DateUtils.difference(time, baseTime, 1) - 1;
        if (years > 1) {
            String year_label = helper.pluralize("year", years);
            results.append(years + " " + year_label);
        } else {
            int months = DateUtils.difference(time, baseTime, 2) - 1;
            if (months > 11) {
                results.append("about 1 year ago");
            } else if (months > 1) {
                String month_label = helper.pluralize("month", months);
                results.append(months + " " + month_label);
            } else {
                int days = DateUtils.difference(time, baseTime, 6) - 1;
                if (days > 25) {
                    results.append("about 1 month");
                } else if (days > 7) {
                    int weeks = days / 7;
                    String weeks_label = helper.pluralize("week", weeks);
                    results.append(weeks + " " + weeks_label);
                } else if (days > 1) {
                    if (days <= 2) {
                        int hours = DateUtils.difference(time, baseTime, 11) - 1;
                        if (hours < 30) {
                            results.append("about 1 day");
                        } else {
                            String days_label = helper.pluralize("day", days);
                            results.append(days + " " + days_label);
                        }
                    } else {
                        String days_label = helper.pluralize("day", days);
                        results.append(days + " " + days_label);
                    }
                } else {
                    int hours = DateUtils.difference(time, baseTime, 11) - 1;
                    if (hours >= 20) {
                        results.append("about 1 day");
                    } else if (hours > 1) {
                        String hours_label = helper.pluralize("hour", hours);
                        results.append(hours + " " + hours_label);
                    } else {
                        int minutes = DateUtils.difference(time, baseTime, 12) - 1;
                        if (minutes >= 45) {
                            results.append("about an hour");
                        } else if (minutes > 20 && minutes < 45) {
                            results.append("about half an hour");
                        } else if (minutes > 1) {
                            String minutes_label = helper.pluralize("minute", minutes);
                            results.append(minutes + " " + minutes_label);
                        } else {
                            return "this very minute";
                        }
                    }
                }
            }
        }
        if (baseTime.after((Timestamp)time)) {
            results.append(" ago");
        } else if (baseTime.before((Timestamp)time)) {
            results.append(" from now");
        } else {
            results.append("now");
        }
        return results.toString();
    }

    public static String timeFromNow(NSTimestamp time) {
        return DurationNamer.timeFrom(time, new NSTimestamp());
    }
}

