/*
 * Decompiled with CFR 0.152.
 */
package er.h2.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;

public class ERH2PlugIn
extends JDBCPlugIn {
    static final boolean USE_NAMED_CONSTRAINTS = true;
    private static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    private static final String DRIVER_NAME = "H2";
    private volatile boolean testedJdbcInfo;

    protected static String quoteTableName(String name) {
        String result = null;
        if (name != null) {
            int i = name.lastIndexOf(46);
            result = i < 0 ? new StringBuilder(34).append(name).append('\"').toString() : name.substring(0, i) + "\".\"" + name.substring(i + 1, name.length()) + '\"';
        }
        return result;
    }

    static String singleQuotedString(Object value) {
        return value == null ? null : ERH2PlugIn.singleQuotedString(value.toString());
    }

    static String singleQuotedString(String string) {
        if (string == null) {
            return null;
        }
        return "'" + string + "'";
    }

    private static Format dateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private static Format timestampFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    }

    public ERH2PlugIn(JDBCAdaptor adaptor) {
        super(adaptor);
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new H2SynchronizationFactory((EOAdaptor)this.adaptor());
    }

    public String databaseProductName() {
        return DRIVER_NAME;
    }

    public String defaultDriverName() {
        return DRIVER_CLASS_NAME;
    }

    public Class defaultExpressionClass() {
        return H2Expression.class;
    }

    public NSDictionary jdbcInfo() {
        NSDictionary jdbcInfo;
        if (!this.testedJdbcInfo) {
            this.testedJdbcInfo = true;
            String property = System.getProperty("h2.updateJDBCInfo");
            if (NSPropertyListSerialization.booleanForString((String)property)) {
                NSLog.out.appendln((Object)("Updating H2JDBCInfo.plist enabled:" + property));
                try {
                    String jdbcInfoContent = NSPropertyListSerialization.stringFromPropertyList((Object)super.jdbcInfo());
                    File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                    File jdbcInfoFile = new File(tmpDir, "H2JDBCInfo.plist");
                    NSLog.out.appendln((Object)("Writing H2JDBCInfo.plist to " + tmpDir.getAbsolutePath()));
                    FileOutputStream fos = new FileOutputStream(jdbcInfoFile);
                    fos.write(jdbcInfoContent.getBytes());
                    fos.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException("problem writing H2JDBCInfo.plist", e);
                }
            }
        }
        if (this.shouldUseBundledJdbcInfo()) {
            InputStream jdbcInfoStream;
            if (NSLog.debugLoggingAllowedForLevel((int)3)) {
                NSLog.debug.appendln((Object)"Loading jdbcInfo from H2JDBCInfo.plist as opposed to using the JDBCPlugIn default implementation.");
            }
            if ((jdbcInfoStream = NSBundle.bundleForClass(((Object)((Object)this)).getClass()).inputStreamForResourcePath("H2JDBCInfo.plist")) == null) {
                throw new IllegalStateException("Unable to find 'H2JDBCInfo.plist' in this plugin jar.");
            }
            try {
                jdbcInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)new NSData(jdbcInfoStream, 2048), (String)"US-ASCII");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load 'H2JDBCInfo.plist' from this plugin jar: " + e, e);
            }
        } else {
            jdbcInfo = super.jdbcInfo();
        }
        return jdbcInfo;
    }

    public String name() {
        return DRIVER_NAME;
    }

    protected boolean shouldUseBundledJdbcInfo() {
        boolean shouldUseBundledJdbcInfo = true;
        String url = this.connectionURL();
        if (url != null && url.toLowerCase().matches(".*(\\?|\\?.*&)useBundledJdbcInfo=(false|no)(\\&|$)".toLowerCase())) {
            shouldUseBundledJdbcInfo = false;
        }
        return shouldUseBundledJdbcInfo;
    }

    public static class H2SynchronizationFactory
    extends EOSynchronizationFactory {
        public H2SynchronizationFactory(EOAdaptor adaptor) {
            super(adaptor);
        }

        public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String tableName) {
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " DROP PRIMARY KEY"));
        }

        public String columnTypeStringForAttribute(EOAttribute attribute) {
            if (attribute.precision() != 0) {
                String precision = String.valueOf(attribute.precision());
                String scale = String.valueOf(attribute.scale());
                return _NSStringUtilities.concat((String)attribute.externalType(), (String)"(", (String)precision, (String)",", (String)scale, (String)")");
            }
            if (attribute.width() != 0) {
                String width = String.valueOf(attribute.width());
                return _NSStringUtilities.concat((String)attribute.externalType(), (String)"(", (String)width, (String)")");
            }
            return attribute.externalType();
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            String pkTable = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            return new NSArray((Object)this._expressionForString("DROP TABLE " + this.formatTableName(pkTable)));
        }

        public NSArray dropTableStatementsForEntityGroup(NSArray entityGroup) {
            String tableName = ((EOEntity)entityGroup.objectAtIndex(0)).externalName();
            return new NSArray((Object)this._expressionForString("DROP TABLE " + this.formatTableName(tableName)));
        }

        public String formatColumnName(String columnName) {
            return columnName;
        }

        public String formatTableName(String tableName) {
            return tableName;
        }

        public String formatUpperString(String string) {
            return string.toUpperCase();
        }

        boolean isPrimaryKeyAttributes(EOEntity entity, NSArray attributes) {
            boolean result;
            NSArray keys = entity.primaryKeyAttributeNames();
            boolean bl = result = attributes.count() == keys.count();
            if (result) {
                for (int i = 0; i < keys.count() && (result = keys.indexOfObject((Object)((EOAttribute)attributes.objectAtIndex(i)).name()) != -1); ++i) {
                }
            }
            return result;
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship relationship) {
            if (relationship != null && !relationship.isToMany() && this.isPrimaryKeyAttributes(relationship.destinationEntity(), relationship.destinationAttributes())) {
                StringBuffer sql = new StringBuffer();
                String tableName = this.formatTableName(relationship.entity().externalName());
                sql.append("ALTER TABLE ");
                sql.append(tableName);
                sql.append(" ADD");
                StringBuffer constraint = new StringBuffer(" CONSTRAINT \"FOREIGN_KEY_");
                constraint.append(this.formatUpperString(tableName));
                StringBuffer fkSql = new StringBuffer(" FOREIGN KEY (");
                NSArray attributes = relationship.sourceAttributes();
                for (int i = 0; i < attributes.count(); ++i) {
                    constraint.append("_");
                    if (i != 0) {
                        fkSql.append(", ");
                    }
                    String columnName = this.formatColumnName(((EOAttribute)attributes.objectAtIndex(i)).columnName());
                    fkSql.append(columnName);
                    constraint.append(this.formatUpperString(columnName));
                }
                fkSql.append(") REFERENCES ");
                constraint.append("_");
                String referencedExternalName = this.formatTableName(relationship.destinationEntity().externalName());
                fkSql.append(referencedExternalName);
                constraint.append(this.formatUpperString(referencedExternalName));
                fkSql.append(" (");
                attributes = relationship.destinationAttributes();
                for (int i = 0; i < attributes.count(); ++i) {
                    constraint.append("_");
                    if (i != 0) {
                        fkSql.append(", ");
                    }
                    String referencedColumnName = this.formatColumnName(((EOAttribute)attributes.objectAtIndex(i)).columnName());
                    fkSql.append(referencedColumnName);
                    constraint.append(this.formatUpperString(referencedColumnName));
                }
                constraint.append('\"');
                fkSql.append(")");
                sql.append(constraint);
                sql.append(fkSql);
                return new NSArray((Object)this._expressionForString(sql.toString()));
            }
            return NSArray.EmptyArray;
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            String pkTable = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            String charField = this.formatColumnName("name") + " CHAR(40)";
            String pkField = this.formatColumnName("pk") + " INT";
            return new NSArray((Object)this._expressionForString("CREATE TABLE " + this.formatTableName(pkTable) + " (" + charField + ", " + pkField + ")"));
        }

        public NSArray statementsToConvertColumnType(String columnName, String tableName, EOSchemaSynchronization.ColumnTypes oldType, EOSchemaSynchronization.ColumnTypes newType, NSDictionary options) {
            EOAttribute attr = new EOAttribute();
            attr.setName(columnName);
            attr.setColumnName(columnName);
            attr.setExternalType(newType.name());
            attr.setScale(newType.scale());
            attr.setPrecision(newType.precision());
            attr.setWidth(newType.width());
            String columnTypeString = this.columnTypeStringForAttribute(attr);
            NSArray statements = new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " ALTER COLUMN " + this.formatColumnName(columnName) + " " + columnTypeString));
            return statements;
        }

        public NSArray statementsToDeleteColumnNamed(String columnName, String tableName, NSDictionary options) {
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " DROP COLUMN " + this.formatTableName(columnName)));
        }

        public NSArray statementsToInsertColumnForAttribute(EOAttribute attribute, NSDictionary options) {
            String clause = this._columnCreationClauseForAttribute(attribute);
            System.out.println("ALTER TABLE " + this.formatTableName(attribute.entity().externalName()) + " ADD COLUMN " + clause);
            NSArray result = new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(attribute.entity().externalName()) + " ADD COLUMN " + clause));
            return result;
        }

        public NSArray statementsToModifyColumnNullRule(String columnName, String tableName, boolean allowsNull, NSDictionary options) {
            NSArray statements = allowsNull ? new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " ALTER COLUMN " + this.formatColumnName(columnName) + " SET NULL")) : new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " ALTER COLUM " + this.formatColumnName(columnName) + " SET NOT NULL"));
            return statements;
        }

        public NSArray statementsToRenameColumnNamed(String columnName, String tableName, String newName, NSDictionary nsdictionary) {
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " ALTER COLUMN " + this.formatColumnName(columnName) + " RENAME TO " + this.formatColumnName(newName)));
        }

        public NSArray statementsToRenameTableNamed(String tableName, String newName, NSDictionary options) {
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " RENAME TO " + this.formatTableName(newName)));
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }
    }

    public static class H2Expression
    extends JDBCExpression {
        public H2Expression(EOEntity entity) {
            super(entity);
        }

        public void addCreateClauseForAttribute(EOAttribute attribute) {
            Object defaultValue;
            StringBuffer sql = new StringBuffer();
            sql.append(attribute.columnName());
            sql.append(' ');
            sql.append(this.columnTypeStringForAttribute(attribute));
            NSDictionary userInfo = attribute.userInfo();
            if (userInfo != null && (defaultValue = userInfo.valueForKey("er.extensions.eoattribute.default")) != null) {
                sql.append(" DEFAULT ");
                sql.append(this.formatValueForAttribute(defaultValue, attribute));
            }
            sql.append(' ');
            sql.append(this.allowsNullClauseForConstraint(attribute.allowsNull()));
            this.appendItemToListString(sql.toString(), this._listString());
        }

        protected boolean enableBooleanQuoting() {
            return false;
        }

        private String formatBigDecimal(BigDecimal value, EOAttribute eoattribute) {
            return value.toPlainString();
        }

        public String formatValueForAttribute(Object value, EOAttribute eoattribute) {
            String result;
            if (value instanceof NSData) {
                result = this.sqlStringForData((NSData)value);
            } else if (value instanceof NSTimestamp && this.isTimestampAttribute(eoattribute)) {
                result = ERH2PlugIn.singleQuotedString(ERH2PlugIn.timestampFormatter().format(value));
            } else if (value instanceof NSTimestamp && this.isDateAttribute(eoattribute)) {
                result = ERH2PlugIn.singleQuotedString(ERH2PlugIn.dateFormatter().format(value));
            } else if (value instanceof String) {
                result = this.formatStringValue((String)value);
            } else if (value instanceof Number) {
                if (value instanceof BigDecimal) {
                    result = this.formatBigDecimal((BigDecimal)value, eoattribute);
                } else {
                    Object convertedValue = eoattribute.adaptorValueByConvertingAttributeValue(value);
                    if (convertedValue instanceof Number) {
                        Number convertedNumberValue = (Number)convertedValue;
                        String valueType = eoattribute.valueType();
                        result = valueType == null || "i".equals(valueType) ? String.valueOf(convertedNumberValue.intValue()) : ("l".equals(valueType) ? String.valueOf(convertedNumberValue.longValue()) : ("f".equals(valueType) ? String.valueOf(convertedNumberValue.floatValue()) : ("d".equals(valueType) ? String.valueOf(convertedNumberValue.doubleValue()) : ("s".equals(valueType) ? String.valueOf(convertedNumberValue.shortValue()) : convertedNumberValue.toString()))));
                    } else {
                        result = convertedValue.toString();
                    }
                }
            } else if (value instanceof Boolean) {
                result = this.enableBooleanQuoting() ? ERH2PlugIn.singleQuotedString(value) : value.toString();
            } else if (value instanceof Timestamp) {
                result = ERH2PlugIn.singleQuotedString(value);
            } else if (value == null || value == NSKeyValueCoding.NullValue) {
                result = "NULL";
            } else {
                try {
                    Object adaptorValue = eoattribute.adaptorValueByConvertingAttributeValue(value);
                    if (adaptorValue instanceof NSData || adaptorValue instanceof NSTimestamp || adaptorValue instanceof String || adaptorValue instanceof Number || adaptorValue instanceof Boolean) {
                        result = this.formatValueForAttribute(adaptorValue, eoattribute);
                    } else {
                        StringBuilder buff = new StringBuilder(((Object)((Object)this)).getClass().getName()).append(": Can't convert: ").append(value).append(':').append(value.getClass().getName()).append(" -> ").append(adaptorValue).append(':').append(adaptorValue.getClass().getName());
                        NSLog.err.appendln((Object)buff.toString());
                        result = value.toString();
                    }
                }
                catch (Exception ex) {
                    StringBuilder buff = new StringBuilder(((Object)((Object)this)).getClass().getName()).append(": Exception while converting ").append(value.getClass().getName());
                    NSLog.err.appendln((Object)buff.toString());
                    NSLog.err.appendln((Throwable)ex);
                    result = value.toString();
                }
            }
            return result;
        }

        private boolean isDateAttribute(EOAttribute eoattribute) {
            return eoattribute != null && "D".equals(eoattribute.valueType());
        }

        private boolean isTimestampAttribute(EOAttribute eoattribute) {
            return eoattribute != null && "T".equals(eoattribute.valueType());
        }
    }
}

