/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.javamail.ERJavaMail;
import er.javamail.ERMailAttachment;
import er.javamail.ERMailSender;
import er.javamail.ERMailUtils;
import er.javamail.ERMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERMailDelivery {
    private static final Logger log = Logger.getLogger(ERMailDelivery.class);
    private Session _session;
    protected MimeMessage _mimeMessage;
    protected NSMutableArray<ERMailAttachment> _attachments;
    protected NSMutableArray<ERMailAttachment> _inlineAttachments;
    private ERMessage.Delegate _delegate;
    private NSDictionary<String, Object> _userInfo;
    private String _contextString;
    public static final String DefaultCharset = System.getProperty("er.javamail.defaultEncoding");
    public String _charset = DefaultCharset;

    public ERMailDelivery(Session session) {
        this.setSession(session);
        this.setMimeMessage(new MimeMessage(this.session()));
    }

    public ERMailDelivery() {
        this(ERJavaMail.sharedInstance().defaultSession());
    }

    public void setDelegate(ERMessage.Delegate delegate) {
        this._delegate = delegate;
    }

    public void setUserInfo(NSDictionary<String, Object> userInfo) {
        this._userInfo = userInfo;
    }

    public NSDictionary<String, Object> userInfo() {
        return this._userInfo;
    }

    public void setContextString(String contextString) {
        this._contextString = contextString;
    }

    public String contextString() {
        return this._contextString;
    }

    public String charset() {
        return this._charset;
    }

    public void setCharset(String charset) {
        this._charset = charset;
    }

    protected Session session() {
        return this._session;
    }

    protected void setSession(Session aSession) {
        this._session = aSession;
    }

    public void newMail() {
        this._attachments().removeAllObjects();
        this._inlineAttachments().removeAllObjects();
        this.setMimeMessage(new MimeMessage(this.session()));
    }

    protected MimeMessage mimeMessage() {
        return this._mimeMessage;
    }

    protected void setMimeMessage(MimeMessage message) {
        this._mimeMessage = message;
    }

    public void addAttachment(ERMailAttachment attachment) {
        this._attachments().addObject((Object)attachment);
    }

    public void addInlineAttachment(ERMailAttachment attachment) {
        this._inlineAttachments().addObject((Object)attachment);
    }

    protected NSMutableArray<ERMailAttachment> _inlineAttachments() {
        if (this._inlineAttachments == null) {
            this._inlineAttachments = new NSMutableArray();
        }
        return this._inlineAttachments;
    }

    public NSArray<ERMailAttachment> inlineAttachments() {
        return this._inlineAttachments();
    }

    protected NSMutableArray<ERMailAttachment> _attachments() {
        if (this._attachments == null) {
            this._attachments = new NSMutableArray();
        }
        return this._attachments;
    }

    public NSArray<ERMailAttachment> attachments() {
        return this._attachments();
    }

    public void removeAttachment(ERMailAttachment attachment) {
        this._attachments().removeObject((Object)attachment);
        this._inlineAttachments().removeObject((Object)attachment);
    }

    protected InternetAddress internetAddressWithEmailAndPersonal(String email, String personal) throws AddressException {
        InternetAddress address = null;
        if (personal != null) {
            address = new InternetAddress();
            address.setAddress(email);
            try {
                address.setPersonal(personal, this.charset());
            }
            catch (UnsupportedEncodingException ex) {
                try {
                    address.setPersonal(personal);
                }
                catch (Exception e) {}
            }
        } else {
            address = new InternetAddress(email);
        }
        return address;
    }

    public void setFromAddress(String fromAddress) throws MessagingException, AddressException {
        this.setFromAddress(fromAddress, null);
    }

    public void setFromAddress(String fromAddress, String personalName) throws MessagingException, AddressException {
        InternetAddress address = this.internetAddressWithEmailAndPersonal(fromAddress, personalName);
        this.mimeMessage().setFrom((Address)address);
    }

    public void setToAddress(String toAddress) throws MessagingException, AddressException {
        this.setToAddress(toAddress, null);
    }

    public void setToAddress(String toAddress, String personalName) throws MessagingException, AddressException {
        InternetAddress address = this.internetAddressWithEmailAndPersonal(toAddress, personalName);
        this.setInternetAddresses((NSArray<InternetAddress>)new NSArray((Object)address), Message.RecipientType.TO);
    }

    public void setToAddresses(NSArray<String> toAddresses) throws MessagingException, AddressException {
        this.setAddresses(toAddresses, Message.RecipientType.TO, true);
    }

    public void setToAddresses(NSDictionary<String, String> toAddresses) throws MessagingException, AddressException {
        this.setAddresses(toAddresses, Message.RecipientType.TO, true);
    }

    public void setReplyToAddress(String toAddress) throws MessagingException, AddressException {
        this.setReplyToAddress(toAddress, null);
    }

    public void setReplyToAddress(String toAddress, String personalName) throws MessagingException, AddressException {
        InternetAddress[] addresses = new InternetAddress[]{this.internetAddressWithEmailAndPersonal(toAddress, personalName)};
        this.mimeMessage().setReplyTo((Address[])addresses);
    }

    public void setCCAddresses(NSArray<String> ccAddresses) throws MessagingException, AddressException {
        this.setAddresses(ccAddresses, Message.RecipientType.CC, true);
    }

    public void setCCAddresses(NSDictionary<String, String> ccAddresses) throws MessagingException, AddressException {
        this.setAddresses(ccAddresses, Message.RecipientType.CC, true);
    }

    public void setBCCAddresses(NSArray<String> bccAddresses) throws MessagingException, AddressException {
        this.setAddresses(bccAddresses, Message.RecipientType.BCC, true);
    }

    public void setBCCAddresses(NSDictionary<String, String> bccAddresses) throws MessagingException, AddressException {
        this.setAddresses(bccAddresses, Message.RecipientType.BCC, true);
    }

    public void setSubject(String subject) throws MessagingException {
        this.mimeMessage().setSubject(ERMailUtils.encodeString(subject, this.charset()));
    }

    public void setXMailerHeader(String xMailer) throws MessagingException {
        this.mimeMessage().setHeader("X-Mailer", xMailer);
    }

    public String xMailerHeader() throws MessagingException {
        String[] headers = this.mimeMessage().getHeader("X-Mailer");
        return headers != null && headers.length > 0 ? headers[0] : null;
    }

    public void setAdditionalHeader(String headerKey, String value) throws MessagingException {
        this.mimeMessage().setHeader(headerKey, value);
    }

    protected ERMessage buildMessage() {
        ERMessage message = new ERMessage();
        message.setDelegate(this._delegate);
        message.setUserInfo(this._userInfo);
        message.setContextString(this._contextString);
        MimeMessage mimeMessage = this.mimeMessage();
        try {
            Address[] toRecipients;
            Address[] bccRecipients = mimeMessage.getRecipients(MimeMessage.RecipientType.BCC);
            if (bccRecipients != null && bccRecipients.length > 0 && ((toRecipients = mimeMessage.getRecipients(MimeMessage.RecipientType.TO)) == null || toRecipients.length == 0)) {
                mimeMessage.addRecipient(MimeMessage.RecipientType.TO, (Address)this.internetAddressWithEmailAndPersonal("Undisclosed recipients:;", null));
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException("Failed to set 'undisclosed recipients' recipient for your bulk mail.", e);
        }
        message.setMimeMessage(mimeMessage);
        return message;
    }

    public void sendMail() {
        try {
            this.sendMail(false);
        }
        catch (NSForwardException e) {
            log.warn((Object)"Sending mail in a non-blocking manner and a forward exception was thrown.", (Throwable)e);
        }
    }

    public void sendMail(boolean shouldBlock) {
        try {
            if (ERJavaMail.sharedInstance().centralize()) {
                if (ERJavaMail.sharedInstance().adminEmail() == null) {
                    throw new IllegalArgumentException("When setting 'er.javamail.centralize=true' (which means you just test sending mails), you must also give a valid 'er.javamail.adminEmail=foo@bar.com' to which the mails are sent.");
                }
                InternetAddress[] addresses = new InternetAddress[]{new InternetAddress(ERJavaMail.sharedInstance().adminEmail())};
                this.mimeMessage().setRecipients(Message.RecipientType.TO, (Address[])addresses);
                this.mimeMessage().setRecipients(Message.RecipientType.CC, (Address[])new InternetAddress[0]);
                this.mimeMessage().setRecipients(Message.RecipientType.BCC, (Address[])new InternetAddress[0]);
            }
            if (this.mimeMessage().getAllRecipients().length == 0) {
                return;
            }
            this.finishMessagePreparation();
            ERMailSender sender = ERMailSender.sharedMailSender();
            ERMessage message = this.buildMessage();
            if (shouldBlock) {
                sender.sendMessageNow(message);
            } else {
                boolean mailAccepted = false;
                while (!mailAccepted) {
                    try {
                        sender.sendMessageDeffered(message);
                        mailAccepted = true;
                    }
                    catch (ERMailSender.SizeOverflowException e) {
                        try {
                            Thread.sleep(ERJavaMail.sharedInstance().milliSecondsWaitIfSenderOverflowed());
                        }
                        catch (InterruptedException ie) {
                            log.warn((Object)"Caught InterruptedException.", (Throwable)ie);
                        }
                    }
                }
            }
        }
        catch (MessagingException e) {
            log.warn((Object)"MessagingException exception caught, re-throwing exception.", (Throwable)e);
            throw new NSForwardException((Throwable)e);
        }
        finally {
            this.setMimeMessage(null);
        }
    }

    protected void finishMessagePreparation() throws MessagingException {
        DataHandler messageDataHandler = this.prepareMail();
        if (this.attachments().count() > 0) {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart mainBodyPart = new MimeBodyPart();
            mainBodyPart.setDataHandler(messageDataHandler);
            multipart.addBodyPart((BodyPart)mainBodyPart);
            for (ERMailAttachment attachment : this.attachments()) {
                BodyPart bp = attachment.getBodyPart();
                bp.setDisposition("attachment");
                multipart.addBodyPart(bp);
            }
            this.mimeMessage().setContent((Multipart)multipart);
        } else {
            this.mimeMessage().setDataHandler(messageDataHandler);
        }
        if (this.xMailerHeader() == null && ERJavaMail.sharedInstance().defaultXMailerHeader() != null) {
            this.setXMailerHeader(ERJavaMail.sharedInstance().defaultXMailerHeader());
        }
        this.mimeMessage().setSentDate(new Date());
        this.mimeMessage().saveChanges();
    }

    public void setInternetAddresses(NSArray<InternetAddress> addresses, Message.RecipientType type) throws MessagingException {
        if (type == null || addresses == null || addresses.count() == 0) {
            return;
        }
        InternetAddress[] internetAddresses = new InternetAddress[addresses.count()];
        for (int i = 0; i < addresses.count(); ++i) {
            internetAddresses[i] = (InternetAddress)addresses.objectAtIndex(i);
        }
        this.mimeMessage().setRecipients(type, (Address[])internetAddresses);
    }

    private void setAddresses(NSArray<String> addressesArray, Message.RecipientType type, boolean filterAddresses) throws MessagingException, AddressException {
        if (filterAddresses) {
            addressesArray = ERJavaMail.sharedInstance().filterEmailAddresses(addressesArray);
        }
        if (addressesArray.count() == 0) {
            return;
        }
        InternetAddress[] addresses = ERMailUtils.convertNSArrayToInternetAddresses(addressesArray);
        this.mimeMessage().setRecipients(type, (Address[])addresses);
    }

    private void setAddresses(NSDictionary<String, String> addressesDictionary, Message.RecipientType type, boolean filterAddresses) throws MessagingException, AddressException {
        NSArray<String> mailAdresses = addressesDictionary.allKeys();
        if (filterAddresses) {
            mailAdresses = ERJavaMail.sharedInstance().filterEmailAddresses(mailAdresses);
        }
        if (mailAdresses.count() == 0) {
            return;
        }
        NSMutableDictionary newDictionary = new NSMutableDictionary();
        for (String key : mailAdresses) {
            newDictionary.takeValueForKey(addressesDictionary.objectForKey((Object)key), key);
        }
        InternetAddress[] addresses = ERMailUtils.convertNSDictionaryToInternetAddresses((NSDictionary<String, String>)newDictionary.immutableClone(), this.charset());
        this.mimeMessage().setRecipients(type, (Address[])addresses);
    }

    protected abstract DataHandler prepareMail() throws MessagingException;
}

