/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.formatters.ERXUnitAwareDecimalFormat;
import er.javamail.ERJavaMail;
import er.javamail.ERMailUtils;
import er.javamail.ERMessage;
import er.javamail.ERQueue;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERMailSender
implements Runnable {
    public static final String InvalidEmailNotification = "InvalidEmailNotification";
    static Logger log = Logger.getLogger(ERMailSender.class);
    private static ERMailSender _sharedMailSender;
    private Stats _stats = new Stats();
    private ERQueue<ERMessage> _messages = new ERQueue(ERJavaMail.sharedInstance().senderQueueSize());
    private int _milliSecondsWaitRunLoop = 5000;
    private Thread _senderThread;

    private ERMailSender() {
        if (WOApplication.application() == null || WOApplication.application().isDebuggingEnabled()) {
            this._milliSecondsWaitRunLoop = 2000;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ERMailSender initialized (JVM heap size: " + this._stats.formattedUsedMemory() + ")"));
        }
    }

    public static synchronized ERMailSender sharedMailSender() {
        if (_sharedMailSender == null) {
            _sharedMailSender = new ERMailSender();
        }
        return _sharedMailSender;
    }

    public Stats stats() {
        return this._stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageDeffered(ERMessage message) throws SizeOverflowException {
        try {
            String allRecipientsString = null;
            if (log.isDebugEnabled()) {
                try {
                    allRecipientsString = message.allRecipientsAsString();
                }
                catch (MessagingException ex) {
                    allRecipientsString = "(not available)";
                }
            }
            this._messages.push(message);
            this._stats.updateMemoryUsage();
            if (log.isDebugEnabled()) {
                log.debug((Object)("(" + this._stats.formattedUsedMemory() + ") Added the message in the queue: " + allRecipientsString));
            }
        }
        catch (ERQueue.SizeOverflowException e) {
            throw new SizeOverflowException(e);
        }
        ERQueue<ERMessage> eRQueue = this._messages;
        synchronized (eRQueue) {
            if (this._senderThread == null) {
                this._senderThread = new Thread((Runnable)this, "ERMailSender");
                this._senderThread.setPriority(1);
                this._senderThread.start();
            } else {
                this._messages.notifyAll();
            }
        }
    }

    public void sendMessageNow(ERMessage message) {
        Transport transport = null;
        try {
            transport = this._connectedTransportForSession(ERJavaMail.sharedInstance().sessionForContext(message.contextString()), ERJavaMail.sharedInstance().smtpProtocolForContext(message.contextString()), false);
            this._sendMessageNow(message, transport);
        }
        catch (MessagingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caught exception when sending mail in a non-blocking manner.", (Throwable)e);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    log.error((Object)"Caught exception when closing transport.", (Throwable)e);
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _sendMessageNow(ERMessage message, Transport transport) throws MessagingException {
        boolean debug = log.isDebugEnabled();
        MimeMessage aMessage = message.mimeMessage();
        Throwable exception = null;
        if (message.shouldSendMessage()) {
            try {
                if (debug) {
                    log.debug((Object)("Sending a message ... " + aMessage));
                    Enumeration e = aMessage.getAllHeaderLines();
                    while (e.hasMoreElements()) {
                        String header = (String)e.nextElement();
                        log.debug((Object)header);
                    }
                }
                transport.sendMessage((Message)aMessage, aMessage.getAllRecipients());
                message._deliverySucceeded();
                if (debug) {
                    log.debug((Object)"Done.");
                }
                this._stats.updateMemoryUsage();
                if (!debug) return;
                String allRecipientsString = null;
                try {
                    allRecipientsString = message.allRecipientsAsString();
                }
                catch (MessagingException ex) {
                    allRecipientsString = "(not available)";
                }
                log.debug((Object)("(" + this._stats.formattedUsedMemory() + ") Message sent: " + allRecipientsString));
                return;
            }
            catch (SendFailedException e) {
                if (debug) {
                    log.debug((Object)("Failed to send message: \n" + message.allRecipientsAsString() + e.getMessage()));
                }
                this._stats.incrementErrorCount();
                NSArray<String> invalidEmails = ERMailUtils.convertInternetAddressesToNSArray(e.getInvalidAddresses());
                this.notifyInvalidEmails(invalidEmails);
                message._invalidRecipients(invalidEmails);
                exception = e;
            }
            catch (MessagingException e) {
                exception = e;
            }
            catch (Throwable t) {
                log.error((Object)("An unexpected error occured while sending message: " + message + " mime message: " + aMessage + " sending to: " + aMessage.getAllRecipients() + " transport: " + transport), t);
                message._deliveryFailed(t);
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
            }
            finally {
                this._stats.incrementMailCount();
                if (exception == null) return;
                message._deliveryFailed(exception);
                throw exception;
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)("Message has instructed me not to send it, not sending message: " + message));
    }

    protected Transport _connectedTransportForSession(Session session, String smtpProtocol, boolean _throwExceptionIfConnectionFails) throws MessagingException {
        Transport transport = null;
        try {
            transport = session.getTransport(smtpProtocol);
            if (!transport.isConnected()) {
                String userName = session.getProperty("mail." + smtpProtocol + ".user");
                String password = session.getProperty("mail." + smtpProtocol + ".password");
                if (userName != null && password != null) {
                    transport.connect(session.getProperty("mail." + smtpProtocol + ".host"), userName, password);
                } else {
                    transport.connect();
                }
            }
        }
        catch (MessagingException e) {
            log.error((Object)("Unable to connect to SMTP Transport. MessagingException: " + e.getMessage()), (Throwable)e);
            if (_throwExceptionIfConnectionFails) {
                throw e;
            }
            log.error((Object)("Unable to connect to SMTP Transport. MessagingException: " + e.getMessage()), (Throwable)e);
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            block27: while (true) {
                var1_1 = this._messages;
                synchronized (var1_1) {
                    while (this._messages.empty()) {
                        this._messages.wait(this._milliSecondsWaitRunLoop);
                    }
                }
                if (this._messages.empty()) continue;
                transports = new HashMap<String, Transport>();
                block29: while (true) {
                    try {
                        while (true) {
                            if (this._messages.empty()) continue block27;
                            message = this._messages.pop();
                            contextString = message.contextString();
                            smtpProtocol = ERJavaMail.sharedInstance().smtpProtocolForContext(contextString);
                            if (contextString == null) {
                                contextString = "___DEFAULT___";
                            }
                            if ((transport = (Transport)transports.get(contextString)) == null) {
                                session = ERJavaMail.sharedInstance().newSessionForMessage(message);
                                transport = this._connectedTransportForSession(session, smtpProtocol, true);
                                transports.put(contextString, transport);
                            }
                            try {
                                if (!transport.isConnected()) {
                                    transport.connect();
                                }
                            }
                            catch (MessagingException e) {
                                ERMailSender.log.error((Object)"Unable to connect transport.", (Throwable)e);
                                throw new RuntimeException("Unable to connect transport.");
                            }
                            try {
                                this._sendMessageNow(message, transport);
                                continue block29;
                            }
                            catch (SendFailedException ex) {
                                ERMailSender.log.error((Object)("Can't send message: " + message + ": " + (Object)ex), (Throwable)ex);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (AuthenticationFailedException e) {
                        ERMailSender.log.error((Object)("Unable to connect to SMTP Transport. AuthenticationFailedException: " + e.getMessage() + " waiting 20 seconds"), (Throwable)e);
                        Thread.sleep(20000L);
                    }
                    catch (MessagingException e) {
                        if (e.getNextException() instanceof ConnectException) {
                            ERMailSender.log.error((Object)"Can't connect to mail server, waiting");
                            Thread.sleep(10000L);
                        }
                        if (e.getNextException() instanceof UnknownHostException) {
                            ERMailSender.log.error((Object)"Can't find to mail server, exiting");
                            return;
                        }
                        ERMailSender.log.error((Object)("General mail error: " + (Object)e), (Throwable)e);
                    }
                }
                finally {
                    i$ = transports.values().iterator();
                    while (true) {
                        if (i$.hasNext()) ** break;
                        continue block27;
                        transport = (Transport)i$.next();
                        try {
                            if (transport == null) continue;
                            transport.close();
                        }
                        catch (MessagingException e) {
                            ERMailSender.log.warn((Object)"Unable to close transport.  Perhaps it has already been closed?", (Throwable)e);
                        }
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            ERMailSender.log.warn((Object)"ERMailSender thread has been interrupted.");
            this._senderThread = null;
            return;
        }
    }

    public ERQueue<ERMessage> messages() {
        return this._messages;
    }

    protected void notifyInvalidEmails(NSArray<String> invalidEmails) {
        NSNotification notification = new NSNotification(InvalidEmailNotification, invalidEmails);
        NSNotificationCenter.defaultCenter().postNotification(notification);
    }

    public class Stats {
        private NSTimestamp lastResetTime = new NSTimestamp();
        private int errorCount = 0;
        private int mailCount = 0;
        private double _peakMemoryUsage = 0.0;
        private Runtime _runtime;
        private ERXUnitAwareDecimalFormat _decimalFormatter = new ERXUnitAwareDecimalFormat("byte");

        public Stats() {
            this._decimalFormatter.setMaximumFractionDigits(2);
            this._runtime = Runtime.getRuntime();
            this.updateMemoryUsage();
        }

        public synchronized void reset() {
            String savedStatsString = this.toString();
            this.errorCount = 0;
            this.mailCount = 0;
            this._peakMemoryUsage = 0.0;
            this.updateMemoryUsage();
            this.lastResetTime = new NSTimestamp();
            if (log.isDebugEnabled()) {
                log.debug((Object)(savedStatsString + " has been reset to initial value."));
            }
        }

        public synchronized int errorCount() {
            return this.errorCount;
        }

        public synchronized int mailCount() {
            return this.mailCount;
        }

        public synchronized int currentQueueSize() {
            return ERMailSender.this._messages.size();
        }

        private void incrementErrorCount() {
            ++this.errorCount;
        }

        private void incrementMailCount() {
            ++this.mailCount;
        }

        public NSTimestamp lastResetTime() {
            return this.lastResetTime;
        }

        private void updateMemoryUsage() {
            long currentMemoryUsed = this.usedMemory();
            if ((double)currentMemoryUsed > this._peakMemoryUsage) {
                this._peakMemoryUsage = currentMemoryUsed;
            }
        }

        public long usedMemory() {
            long totalMemory = this._runtime.totalMemory();
            long freeMemory = this._runtime.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            return usedMemory;
        }

        public String formattedUsedMemory() {
            return this._decimalFormatter.format(this.usedMemory());
        }

        public double peakMemoryUsage() {
            return this._peakMemoryUsage;
        }

        public String formattedPeakMemoryUsage() {
            return this._decimalFormatter.format(this._peakMemoryUsage);
        }

        public String toString() {
            return "<" + this.getClass().getName() + " lastResetTime: " + this.lastResetTime() + ", mailCount: " + this.mailCount() + ", errorCount: " + this.errorCount() + ", currentQueueSize: " + this.currentQueueSize() + ", peakMemoryUsage: " + this.formattedPeakMemoryUsage() + ">";
        }
    }

    public static class SizeOverflowException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SizeOverflowException(Exception e) {
            super(e);
        }
    }
}

