/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.javamail.ERMailUtils;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERMessage {
    private Delegate _delegate;
    private MimeMessage _message;
    private NSDictionary<String, Object> _userInfo;
    private String _contextString;

    public void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    public void setUserInfo(NSDictionary<String, Object> userInfo) {
        this._userInfo = userInfo;
    }

    public NSDictionary<String, Object> userInfo() {
        return this._userInfo;
    }

    public void setContextString(String contextString) {
        this._contextString = contextString;
    }

    public String contextString() {
        return this._contextString;
    }

    public void setMimeMessage(MimeMessage m) {
        this._message = m;
    }

    public MimeMessage mimeMessage() {
        return this._message;
    }

    public boolean shouldSendMessage() {
        Address[] to = null;
        try {
            to = this._message.getRecipients(Message.RecipientType.TO);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return to != null && to.length > 0;
    }

    public Address[] recipients(Message.RecipientType recipientType) throws MessagingException {
        return this._message == null ? null : this._message.getRecipients(recipientType);
    }

    public String recipientsAsString(Message.RecipientType recipientType) throws MessagingException, AddressException {
        return this.recipientsAsString(recipientType, -1);
    }

    public String recipientsAsString(Message.RecipientType recipientType, int maxAddresses) throws MessagingException, AddressException {
        Address[] allAddresses = this.recipients(recipientType);
        Address[] limitteredAddresses = null;
        if (allAddresses == null || allAddresses.length == 0) {
            return null;
        }
        if (maxAddresses > 0) {
            limitteredAddresses = new Address[maxAddresses];
            System.arraycopy(allAddresses, 0, limitteredAddresses, 0, Math.min(allAddresses.length, maxAddresses));
        } else {
            limitteredAddresses = allAddresses;
        }
        StringBuffer result = new StringBuffer();
        result.append(ERMailUtils.convertInternetAddressesToNSArray(limitteredAddresses).componentsJoinedByString(", "));
        if (0 < maxAddresses && maxAddresses < allAddresses.length) {
            result.append(", and ");
            result.append(allAddresses.length - maxAddresses);
            result.append(" other recipients");
        }
        return result.toString();
    }

    public String allRecipientsAsString() throws MessagingException {
        return this.allRecipientsAsString(true, -1);
    }

    public String allRecipientsAsString(boolean includeBcc) throws MessagingException {
        return this.allRecipientsAsString(includeBcc, -1);
    }

    public String allRecipientsAsString(boolean includeBcc, int maxAddresses) throws MessagingException {
        StringBuffer recipients = new StringBuffer();
        String addresses = this.recipientsAsString(Message.RecipientType.TO, maxAddresses);
        if (addresses != null && addresses.length() > 0) {
            recipients.append("To: ").append(addresses);
        }
        if ((addresses = this.recipientsAsString(Message.RecipientType.CC, maxAddresses)) != null && addresses.length() > 0) {
            recipients.append("CC: ").append(addresses);
        }
        if (includeBcc && (addresses = this.recipientsAsString(Message.RecipientType.BCC, maxAddresses)) != null && addresses.length() > 0) {
            recipients.append("BCC: ").append(addresses);
        }
        return recipients.toString();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<").append(this.getClass().getName()).append(" ");
        if (this._message == null) {
            sbuf.append("No mime message is set.");
        } else {
            try {
                sbuf.append(this.allRecipientsAsString());
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        sbuf.append(">");
        return sbuf.toString();
    }

    public void _deliverySucceeded() {
        if (this._delegate != null) {
            this._delegate.deliverySucceeded(this);
        }
    }

    public void _invalidRecipients(NSArray<String> invalidRecipientAddresses) {
        if (this._delegate != null) {
            this._delegate.invalidRecipients(this, invalidRecipientAddresses);
        }
    }

    public void _deliveryFailed(Throwable failure) {
        if (this._delegate != null) {
            this._delegate.deliveryFailed(this, failure);
        }
    }

    public void setDeleteFlag() throws MessagingException {
        this.mimeMessage().setFlag(Flags.Flag.DELETED, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Delegate {
        public void deliverySucceeded(ERMessage var1);

        public void invalidRecipients(ERMessage var1, NSArray<String> var2);

        public void deliveryFailed(ERMessage var1, Throwable var2);
    }
}

