/*
 * Decompiled with CFR 0.152.
 */
package er.workerchannel;

import er.extensions.logging.ERXLogger;
import er.workerchannel.ERWorkUnit;
import er.workerchannel.ERWorkerChannel;

class ERWorkerThread
extends Thread {
    public static final ERXLogger log = ERXLogger.getERXLogger(ERWorkerThread.class);
    private final ERWorkerChannel _channel;
    private volatile boolean _wasShutdownRequested = false;

    public ERWorkerThread(String name, ERWorkerChannel channel) {
        super(name);
        this._channel = channel;
    }

    public void shutdown() {
        this._wasShutdownRequested = true;
        this.interrupt();
    }

    public boolean wasShutdownRequested() {
        return this._wasShutdownRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info((Object)(this.toString() + " started."));
        try {
            while (!this._wasShutdownRequested) {
                ERWorkUnit workUnit = this._channel.dispatchWorkUnit();
                log.info((Object)(this.toString() + " dispatched a work unit: " + workUnit));
                workUnit.setWasDispatched(true);
                workUnit.execute();
            }
        }
        finally {
            log.info((Object)(this.toString() + " shutdown."));
        }
    }

    public String toString() {
        return "<" + Thread.currentThread().getName() + ">";
    }
}

