/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.handlers;

import er.chronic.Options;
import er.chronic.handlers.HandlerPattern;
import er.chronic.handlers.HandlerTypePattern;
import er.chronic.handlers.IHandler;
import er.chronic.handlers.ORGRHandler;
import er.chronic.handlers.ORSRHandler;
import er.chronic.handlers.PSRHandler;
import er.chronic.handlers.RGRHandler;
import er.chronic.handlers.RHandler;
import er.chronic.handlers.RdnRmnSdTTzSyHandler;
import er.chronic.handlers.RmnOdHandler;
import er.chronic.handlers.RmnOdOnHandler;
import er.chronic.handlers.RmnSdHandler;
import er.chronic.handlers.RmnSdOnHandler;
import er.chronic.handlers.RmnSdSyHandler;
import er.chronic.handlers.RmnSyHandler;
import er.chronic.handlers.SRPAHandler;
import er.chronic.handlers.SRPHandler;
import er.chronic.handlers.SdRmnSyHandler;
import er.chronic.handlers.SdSmSyHandler;
import er.chronic.handlers.SmSdHandler;
import er.chronic.handlers.SmSdSyHandler;
import er.chronic.handlers.SmSyHandler;
import er.chronic.handlers.SyHandler;
import er.chronic.handlers.SySmSdHandler;
import er.chronic.handlers.TagPattern;
import er.chronic.repeaters.EnumRepeaterDayPortion;
import er.chronic.repeaters.IntegerRepeaterDayPortion;
import er.chronic.repeaters.Repeater;
import er.chronic.repeaters.RepeaterDayName;
import er.chronic.repeaters.RepeaterDayPortion;
import er.chronic.repeaters.RepeaterMonthName;
import er.chronic.repeaters.RepeaterTime;
import er.chronic.tags.Grabber;
import er.chronic.tags.Ordinal;
import er.chronic.tags.OrdinalDay;
import er.chronic.tags.Pointer;
import er.chronic.tags.Scalar;
import er.chronic.tags.ScalarDay;
import er.chronic.tags.ScalarMonth;
import er.chronic.tags.ScalarYear;
import er.chronic.tags.Separator;
import er.chronic.tags.SeparatorAt;
import er.chronic.tags.SeparatorComma;
import er.chronic.tags.SeparatorIn;
import er.chronic.tags.SeparatorOn;
import er.chronic.tags.SeparatorSlashOrDash;
import er.chronic.tags.TimeZone;
import er.chronic.utils.EndianPrecedence;
import er.chronic.utils.Range;
import er.chronic.utils.Span;
import er.chronic.utils.Tick;
import er.chronic.utils.Time;
import er.chronic.utils.Token;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler {
    private static Map<HandlerType, List<Handler>> _definitions;
    private HandlerPattern[] _patterns;
    private IHandler _handler;
    private boolean _compatible;

    public Handler(IHandler handler, HandlerPattern ... patterns) {
        this(handler, true, patterns);
    }

    public Handler(IHandler handler, boolean compatible, HandlerPattern ... patterns) {
        this._handler = handler;
        this._compatible = compatible;
        this._patterns = patterns;
    }

    public boolean isCompatible(Options options) {
        return !options.isCompatibilityMode() || this._compatible;
    }

    public IHandler getHandler() {
        return this._handler;
    }

    public boolean match(List<Token> tokens, Map<HandlerType, List<Handler>> definitions) {
        return this.matchCount(tokens, definitions) != null;
    }

    public Range matchCount(List<Token> tokens, Map<HandlerType, List<Handler>> definitions) {
        Range range = this._matchCount(tokens, definitions);
        return range != null && range.getEnd() == (long)tokens.size() ? range : null;
    }

    public Range _matchCount(List<Token> tokens, Map<HandlerType, List<Handler>> definitions) {
        int tokenStartIndex = 0;
        int tokenIndex = 0;
        for (HandlerPattern pattern : this._patterns) {
            boolean optional = pattern.isOptional();
            if (pattern instanceof TagPattern) {
                boolean match;
                boolean bl = match = tokenIndex < tokens.size() && tokens.get(tokenIndex).getTags(((TagPattern)pattern).getTagClass()).size() > 0;
                if (!match && !optional) {
                    return null;
                }
                if (!match) continue;
                ++tokenIndex;
                continue;
            }
            if (pattern instanceof HandlerTypePattern) {
                if (optional && tokenIndex == tokens.size()) {
                    return new Range(0L, tokens.size());
                }
                List<Handler> subHandlers = definitions.get((Object)((HandlerTypePattern)pattern).getType());
                for (Handler subHandler : subHandlers) {
                    Range range = subHandler._matchCount(tokens.subList(tokenIndex, tokens.size()), definitions);
                    if (range == null) continue;
                    if (tokenIndex == 0) {
                        tokenStartIndex = (int)range.getEnd();
                    }
                    tokenIndex = (int)((long)tokenIndex + range.getEnd());
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown pattern: " + pattern);
        }
        return new Range(tokenStartIndex, tokenIndex);
    }

    public String toString() {
        return "[Handler: " + this._handler + "]";
    }

    public static synchronized Map<HandlerType, List<Handler>> definitions(Options options) {
        Map<HandlerType, List<Handler>> definitions = _definitions;
        List<EndianPrecedence> defaultEndianPrecedences = Arrays.asList(EndianPrecedence.Middle, EndianPrecedence.Little);
        if (definitions == null || options.getEndianPrecedence() != null && !((Object)options.getEndianPrecedence()).equals(defaultEndianPrecedences)) {
            List<EndianPrecedence> endianPrecendence = options.getEndianPrecedence();
            if (endianPrecendence == null) {
                endianPrecendence = defaultEndianPrecedences;
            }
            if (endianPrecendence.size() != 2) {
                throw new IllegalArgumentException("More than two elements specified for endian precedence array: " + endianPrecendence + ".");
            }
            HashMap<EndianPrecedence, Handler> endianHandlers = new HashMap<EndianPrecedence, Handler>();
            endianHandlers.put(EndianPrecedence.Little, new Handler((IHandler)new SdSmSyHandler(), new TagPattern(ScalarDay.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarYear.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            endianHandlers.put(EndianPrecedence.Middle, new Handler((IHandler)new SmSdSyHandler(), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarYear.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            definitions = new HashMap<HandlerType, List<Handler>>();
            LinkedList<Handler> timeHandlers = new LinkedList<Handler>();
            timeHandlers.add(new Handler(null, new TagPattern(RepeaterTime.class), new TagPattern(Grabber.class, true), new TagPattern(RepeaterDayPortion.class, true)));
            definitions.put(HandlerType.TIME, timeHandlers);
            LinkedList<Handler> dateHandlers = new LinkedList<Handler>();
            dateHandlers.add(new Handler((IHandler)new RdnRmnSdTTzSyHandler(), new TagPattern(RepeaterDayName.class), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarDay.class), new TagPattern(RepeaterTime.class), new TagPattern(SeparatorSlashOrDash.class, true), new TagPattern(TimeZone.class), new TagPattern(ScalarYear.class)));
            dateHandlers.add(new Handler((IHandler)new SyHandler(), new TagPattern(ScalarYear.class)));
            dateHandlers.add(new Handler((IHandler)new RmnSdSyHandler(), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorComma.class, true), new TagPattern(ScalarYear.class)));
            dateHandlers.add(new Handler((IHandler)new RmnSdSyHandler(), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorComma.class, true), new TagPattern(ScalarYear.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new RmnSdHandler(), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            for (EndianPrecedence precedence : endianPrecendence) {
                dateHandlers.add((Handler)endianHandlers.get((Object)precedence));
            }
            dateHandlers.add(new Handler((IHandler)new RmnSdOnHandler(), new TagPattern(RepeaterTime.class), new TagPattern(RepeaterDayPortion.class, true), new TagPattern(SeparatorOn.class, true), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarDay.class)));
            dateHandlers.add(new Handler((IHandler)new RmnOdHandler(), new TagPattern(RepeaterMonthName.class), new TagPattern(OrdinalDay.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new RmnOdOnHandler(), new TagPattern(RepeaterTime.class), new TagPattern(RepeaterDayPortion.class, true), new TagPattern(SeparatorOn.class, true), new TagPattern(RepeaterMonthName.class), new TagPattern(OrdinalDay.class)));
            dateHandlers.add(new Handler((IHandler)new RmnSyHandler(), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarYear.class)));
            dateHandlers.add(new Handler((IHandler)new SdRmnSyHandler(), new TagPattern(ScalarDay.class), new TagPattern(RepeaterMonthName.class), new TagPattern(ScalarYear.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new SmSdSyHandler(), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarYear.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new SdSmSyHandler(), new TagPattern(ScalarDay.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarYear.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new SySmSdHandler(), new TagPattern(ScalarYear.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new SmSdHandler(), false, new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarDay.class), new TagPattern(SeparatorAt.class, true), new HandlerTypePattern(HandlerType.TIME, true)));
            dateHandlers.add(new Handler((IHandler)new SmSdHandler(), false, new HandlerTypePattern(HandlerType.TIME, true), new TagPattern(SeparatorOn.class, true), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarDay.class)));
            dateHandlers.add(new Handler((IHandler)new SmSyHandler(), new TagPattern(ScalarMonth.class), new TagPattern(SeparatorSlashOrDash.class), new TagPattern(ScalarYear.class)));
            definitions.put(HandlerType.DATE, dateHandlers);
            LinkedList<Handler> anchorHandlers = new LinkedList<Handler>();
            anchorHandlers.add(new Handler((IHandler)new RHandler(), new TagPattern(Grabber.class, true), new TagPattern(Repeater.class), new TagPattern(SeparatorAt.class, true), new TagPattern(Repeater.class, true), new TagPattern(Repeater.class, true)));
            anchorHandlers.add(new Handler((IHandler)new RHandler(), new TagPattern(Grabber.class, true), new TagPattern(Repeater.class), new TagPattern(Repeater.class), new TagPattern(SeparatorAt.class, true), new TagPattern(Grabber.class, true), new TagPattern(Repeater.class, true), new TagPattern(Repeater.class, true)));
            anchorHandlers.add(new Handler((IHandler)new RGRHandler(), new TagPattern(Repeater.class), new TagPattern(Grabber.class), new TagPattern(Repeater.class)));
            definitions.put(HandlerType.ANCHOR, anchorHandlers);
            LinkedList<Handler> arrowHandlers = new LinkedList<Handler>();
            arrowHandlers.add(new Handler((IHandler)new SRPHandler(), new TagPattern(Scalar.class), new TagPattern(Repeater.class), new TagPattern(Pointer.class)));
            arrowHandlers.add(new Handler((IHandler)new PSRHandler(), new TagPattern(Pointer.class), new TagPattern(Scalar.class), new TagPattern(Repeater.class)));
            arrowHandlers.add(new Handler((IHandler)new SRPAHandler(), new TagPattern(Scalar.class), new TagPattern(Repeater.class), new TagPattern(Pointer.class), new HandlerTypePattern(HandlerType.ANCHOR)));
            definitions.put(HandlerType.ARROW, arrowHandlers);
            LinkedList<Handler> narrowHandlers = new LinkedList<Handler>();
            narrowHandlers.add(new Handler((IHandler)new ORSRHandler(), new TagPattern(Ordinal.class), new TagPattern(Repeater.class), new TagPattern(SeparatorIn.class), new TagPattern(Repeater.class)));
            narrowHandlers.add(new Handler((IHandler)new ORGRHandler(), new TagPattern(Ordinal.class), new TagPattern(Repeater.class), new TagPattern(Grabber.class), new TagPattern(Repeater.class)));
            definitions.put(HandlerType.NARROW, narrowHandlers);
            if (_definitions == null) {
                _definitions = definitions;
            }
        }
        return definitions;
    }

    public static Span tokensToSpan(List<Token> tokens, Options options) {
        if (options.isDebug()) {
            System.out.println("Chronic.tokensToSpan: " + tokens);
        }
        Range range = null;
        Map<HandlerType, List<Handler>> definitions = Handler.definitions(options);
        for (Handler handler : definitions.get((Object)HandlerType.DATE)) {
            if (!handler.isCompatible(options) || (range = handler.matchCount(tokens, definitions)) == null) continue;
            if (options.isDebug()) {
                System.out.println("Chronic.tokensToSpan: date " + handler);
            }
            LinkedList<Token> goodTokens = new LinkedList<Token>();
            for (Token token : range.subList(tokens)) {
                if (token.getTag(Separator.class) != null) continue;
                goodTokens.add(token);
            }
            return handler.getHandler().handle(goodTokens, options);
        }
        for (Handler handler : definitions.get((Object)HandlerType.ANCHOR)) {
            if (!handler.isCompatible(options) || (range = handler.matchCount(tokens, definitions)) == null) continue;
            if (options.isDebug()) {
                System.out.println("Chronic.tokensToSpan: anchor " + handler);
            }
            LinkedList<Token> goodTokens = new LinkedList<Token>();
            for (Token token : range.subList(tokens)) {
                if (token.getTag(Separator.class) != null) continue;
                goodTokens.add(token);
            }
            return handler.getHandler().handle(goodTokens, options);
        }
        for (Handler handler : definitions.get((Object)HandlerType.ARROW)) {
            if (!handler.isCompatible(options) || (range = handler.matchCount(tokens, definitions)) == null) continue;
            if (options.isDebug()) {
                System.out.println("Chronic.tokensToSpan: arrow " + handler);
            }
            LinkedList<Token> goodTokens = new LinkedList<Token>();
            for (Token token : range.subList(tokens)) {
                if (token.getTag(SeparatorAt.class) != null || token.getTag(SeparatorSlashOrDash.class) != null || token.getTag(SeparatorComma.class) != null) continue;
                goodTokens.add(token);
            }
            return handler.getHandler().handle(goodTokens, options);
        }
        for (Handler handler : definitions.get((Object)HandlerType.NARROW)) {
            if (!handler.isCompatible(options) || (range = handler.matchCount(tokens, definitions)) == null) continue;
            if (options.isDebug()) {
                System.out.println("Chronic.tokensToSpan: narrow " + handler);
            }
            return handler.getHandler().handle(range.subList(tokens), options);
        }
        if (options.isDebug()) {
            System.out.println("Chronic.tokensToSpan: none");
        }
        return null;
    }

    public static List<Repeater<?>> getRepeaters(List<Token> tokens) {
        LinkedList repeaters = new LinkedList();
        for (Token token : tokens) {
            Repeater tag = token.getTag(Repeater.class);
            if (tag == null) continue;
            repeaters.add(tag);
        }
        Collections.sort(repeaters);
        Collections.reverse(repeaters);
        return repeaters;
    }

    public static Span getAnchor(List<Token> tokens, Options options) {
        Span outerSpan;
        Grabber grabber = options.getContext() == Pointer.PointerType.PAST ? new Grabber(Grabber.Relative.LAST) : new Grabber(Grabber.Relative.THIS);
        Pointer.PointerType pointer = Pointer.PointerType.FUTURE;
        List<Repeater<?>> repeaters = Handler.getRepeaters(tokens);
        for (int i = 0; i < repeaters.size(); ++i) {
            tokens.remove(tokens.size() - 1);
        }
        if (!tokens.isEmpty() && tokens.get(0).getTag(Grabber.class) != null) {
            grabber = tokens.get(0).getTag(Grabber.class);
            tokens.remove(tokens.size() - 1);
        }
        Repeater<?> head = repeaters.remove(0);
        head.setStart((Calendar)options.getNow().clone());
        Grabber.Relative grabberType = (Grabber.Relative)((Object)grabber.getType());
        if (grabberType == Grabber.Relative.LAST) {
            outerSpan = head.nextSpan(Pointer.PointerType.PAST);
        } else if (grabberType == Grabber.Relative.THIS) {
            outerSpan = repeaters.size() > 0 ? head.thisSpan(Pointer.PointerType.NONE) : head.thisSpan(options.getContext());
        } else if (grabberType == Grabber.Relative.NEXT) {
            outerSpan = head.nextSpan(Pointer.PointerType.FUTURE);
        } else {
            throw new IllegalArgumentException("Invalid grabber type " + (Object)((Object)grabberType) + ".");
        }
        if (options.isDebug()) {
            System.out.println("Chronic.getAnchor: grabber = " + grabber + "; repeaters = " + repeaters + "; outerSpan = " + outerSpan);
        }
        Span anchor = Handler.findWithin(repeaters, outerSpan, pointer, options);
        return anchor;
    }

    public static Span parseTime(List<Token> tokens, int timeTokenOffset, int year, int month, int day, Options options) {
        Span span;
        try {
            List<Token> timeTokens = tokens.subList(timeTokenOffset, tokens.size());
            Calendar dayStart = Time.construct(year, month, day);
            span = Handler.dayOrTime(dayStart, timeTokens, options);
        }
        catch (IllegalArgumentException e) {
            if (options.isDebug()) {
                e.printStackTrace(System.out);
            }
            span = null;
        }
        return span;
    }

    public static Span dayOrTime(Calendar dayStart, List<Token> timeTokens, Options options) {
        Span outerSpan = new Span(dayStart, Time.cloneAndAdd(dayStart, 5, 1.0f));
        if (!timeTokens.isEmpty()) {
            if (options.getContext() == Pointer.PointerType.PAST) {
                options.setNow(outerSpan.getEndCalendar());
            } else {
                options.setNow(outerSpan.getBeginCalendar());
            }
            Span time = Handler.getAnchor(Handler.dealiasAndDisambiguateTimes(timeTokens, options), options);
            return time;
        }
        return outerSpan;
    }

    public static Span findWithin(List<Repeater<?>> tags, Span span, Pointer.PointerType pointer, Options options) {
        if (options.isDebug()) {
            System.out.println("Chronic.findWithin: " + tags + " in " + span);
        }
        if (tags.isEmpty()) {
            return span;
        }
        Repeater<?> head = tags.get(0);
        LinkedList rest = tags.size() > 1 ? tags.subList(1, tags.size()) : new LinkedList();
        head.setStart(pointer == Pointer.PointerType.FUTURE ? span.getBeginCalendar() : span.getEndCalendar());
        Span h = head.thisSpan(Pointer.PointerType.NONE);
        if (span.contains(h.getBegin()) || span.contains(h.getEnd())) {
            return Handler.findWithin(rest, h, pointer, options);
        }
        return null;
    }

    public static List<Token> dealiasAndDisambiguateTimes(List<Token> tokens, Options options) {
        int dayPortionIndex = -1;
        int tokenSize = tokens.size();
        for (int i = 0; dayPortionIndex == -1 && i < tokenSize; ++i) {
            Token t = tokens.get(i);
            if (t.getTag(RepeaterDayPortion.class) == null) continue;
            dayPortionIndex = i;
        }
        int timeIndex = -1;
        for (int i = 0; timeIndex == -1 && i < tokenSize; ++i) {
            Token t = tokens.get(i);
            if (t.getTag(RepeaterTime.class) == null) continue;
            timeIndex = i;
        }
        if (dayPortionIndex != -1 && timeIndex != -1) {
            Token t1 = tokens.get(dayPortionIndex);
            RepeaterDayPortion t1Tag = t1.getTag(RepeaterDayPortion.class);
            Object t1TagType = t1Tag.getType();
            if (RepeaterDayPortion.DayPortion.MORNING.equals(t1TagType)) {
                if (options.isDebug()) {
                    System.out.println("Chronic.dealiasAndDisambiguateTimes: morning->am");
                }
                t1.untag(RepeaterDayPortion.class);
                t1.tag(new EnumRepeaterDayPortion(RepeaterDayPortion.DayPortion.AM));
            } else if (RepeaterDayPortion.DayPortion.AFTERNOON.equals(t1TagType) || RepeaterDayPortion.DayPortion.EVENING.equals(t1TagType) || RepeaterDayPortion.DayPortion.NIGHT.equals(t1TagType)) {
                if (options.isDebug()) {
                    System.out.println("Chronic.dealiasAndDisambiguateTimes: " + t1TagType + "->pm");
                }
                t1.untag(RepeaterDayPortion.class);
                t1.tag(new EnumRepeaterDayPortion(RepeaterDayPortion.DayPortion.PM));
            }
        }
        if (options.getAmbiguousTimeRange() != 0) {
            LinkedList<Token> ttokens = new LinkedList<Token>();
            for (int i = 0; i < tokenSize; ++i) {
                Token t0 = tokens.get(i);
                ttokens.add(t0);
                Token t1 = null;
                if (i < tokenSize - 1) {
                    t1 = tokens.get(i + 1);
                }
                if (t0.getTag(RepeaterTime.class) == null || !((Tick)t0.getTag(RepeaterTime.class).getType()).isAmbiguous() || t1 != null && t1.getTag(RepeaterDayPortion.class) != null) continue;
                Token distoken = new Token("disambiguator");
                distoken.tag(new IntegerRepeaterDayPortion((int)options.getAmbiguousTimeRange()));
                ttokens.add(distoken);
            }
            tokens = ttokens;
        }
        if (options.isDebug()) {
            System.out.println("Chronic.dealiasAndDisambiguateTimes: " + tokens);
        }
        return tokens;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandlerType {
        TIME,
        DATE,
        ANCHOR,
        ARROW,
        NARROW;

    }
}

