/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.handlers;

import er.chronic.Chronic;
import er.chronic.Options;
import er.chronic.handlers.IHandler;
import er.chronic.repeaters.Repeater;
import er.chronic.tags.Pointer;
import er.chronic.tags.Scalar;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import er.chronic.utils.Token;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRPHandler
implements IHandler {
    public Span handle(List<Token> tokens, Span span, Options options) {
        float distance = ((Number)tokens.get(0).getTag(Scalar.class).getType()).floatValue();
        Repeater repeater = tokens.get(1).getTag(Repeater.class);
        Pointer.PointerType pointer = (Pointer.PointerType)((Object)tokens.get(2).getTag(Pointer.class).getType());
        Span offsetSpan = repeater.getOffset(span, distance, pointer);
        if (!options.isGuess()) {
            Calendar beginCalendar = offsetSpan.getBeginCalendar();
            int calendarField = 13;
            int spanLength = 1;
            switch (repeater.getWidth()) {
                case 60: {
                    calendarField = 12;
                    break;
                }
                case 3600: {
                    calendarField = 10;
                    break;
                }
                case 86400: {
                    calendarField = 5;
                    break;
                }
                case 172800: {
                    calendarField = 5;
                    spanLength = 2;
                    break;
                }
                case 604800: {
                    calendarField = 5;
                    int dayOfWeek = beginCalendar.get(7);
                    beginCalendar.add(7, -1 * (dayOfWeek - beginCalendar.getFirstDayOfWeek()));
                    spanLength = 7;
                    break;
                }
                case 1209600: {
                    calendarField = 5;
                    int dayOfWeek = beginCalendar.get(7);
                    beginCalendar.add(7, -1 * (dayOfWeek - beginCalendar.getFirstDayOfWeek()));
                    spanLength = 14;
                    break;
                }
                case 2592000: {
                    calendarField = 2;
                    break;
                }
                case 31536000: {
                    calendarField = 1;
                }
            }
            beginCalendar = DateUtils.truncate((Calendar)beginCalendar, (int)calendarField);
            offsetSpan = new Span(beginCalendar, Time.cloneAndAdd(beginCalendar, calendarField, spanLength));
        }
        return offsetSpan;
    }

    @Override
    public Span handle(List<Token> tokens, Options options) {
        Repeater repeater = tokens.get(1).getTag(Repeater.class);
        Span span = Chronic.parse("this second", new Options(options.getNow(), false));
        return this.handle(tokens, span, options);
    }
}

