/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.handlers;

import er.chronic.Options;
import er.chronic.handlers.Handler;
import er.chronic.handlers.IHandler;
import er.chronic.tags.ScalarYear;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import er.chronic.utils.Token;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyHandler
implements IHandler {
    @Override
    public Span handle(List<Token> tokens, Options options) {
        Span span;
        int year = ((Number)tokens.get(0).getTag(ScalarYear.class).getType()).intValue();
        try {
            Calendar dayStart = Time.construct(year, 1, 1);
            List<Token> timeTokens = tokens.subList(1, tokens.size());
            span = Handler.dayOrTime(dayStart, timeTokens, options);
            if (!options.isGuess()) {
                Calendar beginCalendar = span.getBeginCalendar();
                span = new Span(beginCalendar, Time.cloneAndAdd(beginCalendar, 1, 1.0f));
            }
        }
        catch (IllegalArgumentException e) {
            if (options.isDebug()) {
                e.printStackTrace(System.out);
            }
            span = null;
        }
        return span;
    }
}

