/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterDayName;
import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterFortnight
extends RepeaterUnit {
    public static final int FORTNIGHT_SECONDS = 1209600;
    private Calendar _currentFortnightStart;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentFortnightStart == null) {
            if (pointer == Pointer.PointerType.FUTURE) {
                RepeaterDayName sundayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SUNDAY);
                sundayRepeater.setStart(this.getNow());
                Span nextSundaySpan = sundayRepeater.nextSpan(Pointer.PointerType.FUTURE);
                this._currentFortnightStart = nextSundaySpan.getBeginCalendar();
                return new Span(this._currentFortnightStart, 13, 1209600.0f);
            } else {
                if (pointer != Pointer.PointerType.PAST) throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
                RepeaterDayName sundayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SUNDAY);
                sundayRepeater.setStart(Time.cloneAndAdd(this.getNow(), 13, 86400.0f));
                sundayRepeater.nextSpan(Pointer.PointerType.PAST);
                sundayRepeater.nextSpan(Pointer.PointerType.PAST);
                Span lastSundaySpan = sundayRepeater.nextSpan(Pointer.PointerType.PAST);
                this._currentFortnightStart = lastSundaySpan.getBeginCalendar();
            }
            return new Span(this._currentFortnightStart, 13, 1209600.0f);
        } else {
            int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
            this._currentFortnightStart.add(13, direction * 1209600);
        }
        return new Span(this._currentFortnightStart, 13, 1209600.0f);
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Span span;
        if (pointer == null) {
            pointer = Pointer.PointerType.FUTURE;
        }
        if (pointer == Pointer.PointerType.FUTURE) {
            Calendar thisFortnightStart = Time.cloneAndAdd(Time.ymdh(this.getNow()), 13, 3600.0f);
            RepeaterDayName sundayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SUNDAY);
            sundayRepeater.setStart(this.getNow());
            sundayRepeater.thisSpan(Pointer.PointerType.FUTURE);
            Span thisSundaySpan = sundayRepeater.thisSpan(Pointer.PointerType.FUTURE);
            Calendar thisFortnightEnd = thisSundaySpan.getBeginCalendar();
            span = new Span(thisFortnightStart, thisFortnightEnd);
        } else if (pointer == Pointer.PointerType.PAST) {
            Calendar thisFortnightEnd = Time.ymdh(this.getNow());
            RepeaterDayName sundayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SUNDAY);
            sundayRepeater.setStart(this.getNow());
            Span lastSundaySpan = sundayRepeater.nextSpan(Pointer.PointerType.PAST);
            Calendar thisFortnightStart = lastSundaySpan.getBeginCalendar();
            span = new Span(thisFortnightStart, thisFortnightEnd);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return span;
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        Span offsetSpan = span.add((float)direction * amount * 1209600.0f);
        return offsetSpan;
    }

    public int getWidth() {
        return 1209600;
    }

    public String toString() {
        return super.toString() + "-fortnight";
    }
}

