/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterMonth
extends RepeaterUnit {
    public static final int MONTH_SECONDS = 2592000;
    private Calendar _currentMonthStart;

    protected Span _nextSpan(Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        this._currentMonthStart = this._currentMonthStart == null ? Time.cloneAndAdd(Time.ym(this.getNow()), 2, direction) : Time.cloneAndAdd(this._currentMonthStart, 2, direction);
        return new Span(this._currentMonthStart, 2, 1.0f);
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        return new Span(Time.cloneAndAdd(span.getBeginCalendar(), 2, amount * (float)direction), Time.cloneAndAdd(span.getEndCalendar(), 2, amount * (float)direction));
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Calendar monthEnd;
        Calendar monthStart;
        if (pointer == Pointer.PointerType.FUTURE) {
            monthStart = Time.cloneAndAdd(Time.ymd(this.getNow()), 5, 1.0f);
            monthEnd = Time.cloneAndAdd(Time.ym(this.getNow()), 2, 1.0f);
        } else if (pointer == Pointer.PointerType.PAST) {
            monthStart = Time.ym(this.getNow());
            monthEnd = Time.ymd(this.getNow());
        } else if (pointer == Pointer.PointerType.NONE) {
            monthStart = Time.ym(this.getNow());
            monthEnd = Time.cloneAndAdd(Time.ym(this.getNow()), 2, 1.0f);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return new Span(monthStart, monthEnd);
    }

    public int getWidth() {
        return 2592000;
    }

    public String toString() {
        return super.toString() + "-month";
    }
}

