/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterYear
extends RepeaterUnit {
    public static final int YEAR_SECONDS = 31536000;
    private Calendar _currentYearStart;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentYearStart == null) {
            if (pointer == Pointer.PointerType.FUTURE) {
                this._currentYearStart = Time.cloneAndAdd(Time.y(this.getNow()), 1, 1.0f);
                return new Span(this._currentYearStart, 1, 1.0f);
            } else {
                if (pointer != Pointer.PointerType.PAST) throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
                this._currentYearStart = Time.cloneAndAdd(Time.y(this.getNow()), 1, -1.0f);
            }
            return new Span(this._currentYearStart, 1, 1.0f);
        } else {
            int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
            this._currentYearStart.add(1, direction);
        }
        return new Span(this._currentYearStart, 1, 1.0f);
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Calendar yearEnd;
        Calendar yearStart;
        if (pointer == Pointer.PointerType.FUTURE) {
            yearStart = Time.cloneAndAdd(Time.ymd(this.getNow()), 5, 1.0f);
            yearEnd = Time.cloneAndAdd(Time.yJan1(this.getNow()), 1, 1.0f);
        } else if (pointer == Pointer.PointerType.PAST) {
            yearStart = Time.yJan1(this.getNow());
            yearEnd = Time.ymd(this.getNow());
        } else if (pointer == Pointer.PointerType.NONE) {
            yearStart = Time.yJan1(this.getNow());
            yearEnd = Time.cloneAndAdd(Time.yJan1(this.getNow()), 1, 1.0f);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return new Span(yearStart, yearEnd);
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        Calendar newBegin = Time.cloneAndAdd(span.getBeginCalendar(), 1, amount * (float)direction);
        Calendar newEnd = Time.cloneAndAdd(span.getEndCalendar(), 1, amount * (float)direction);
        return new Span(newBegin, newEnd);
    }

    public int getWidth() {
        return 31536000;
    }

    public String toString() {
        return super.toString() + "-year";
    }
}

