/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.ant.taskdefs;

import java.util.ArrayList;
import java.util.List;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.OfflineWeaver;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Weave
extends Task {
    private Path classpath = null;
    private String glueName = null;
    private ArrayList filesets = new ArrayList();
    private String destdir = ".";

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        this.classpath.append(path);
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public String[] getClasspath() {
        if (this.classpath != null) {
            return this.classpath.list();
        }
        return new String[0];
    }

    public void setGlue(String className) {
        this.glueName = className;
    }

    public String getGlue() {
        return this.glueName;
    }

    public void setDestdir(String dir) {
        this.destdir = dir;
    }

    public void setDebug(String value) {
        Gluon.stackTrace = value.equals("yes") || value.equals("true") || value.equals("on");
    }

    public String getDestdir() {
        return this.destdir;
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public List getFileSets() {
        return this.filesets;
    }

    public void execute() throws BuildException {
        Exception ex = null;
        try {
            this.execute0();
            return;
        }
        catch (NotFoundException e) {
            ex = e;
        }
        catch (WeaveException e) {
            ex = e;
        }
        catch (RuntimeException e) {
            ex = e;
        }
        if (Gluon.stackTrace) {
            ex.printStackTrace();
        }
        throw new BuildException(ex.toString(), (Throwable)ex);
    }

    protected void execute0() throws BuildException, WeaveException, NotFoundException {
        if (this.glueName == null) {
            throw new BuildException("a glue name is not specified");
        }
        OfflineWeaver weaver = new OfflineWeaver(this.glueName, this.getClasspath());
        if (this.destdir != null) {
            weaver.setDirectory(this.destdir);
        }
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            weaver.transformFiles(ds.getBasedir(), files);
        }
    }
}

