/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.bytecode.AttributeInfo;
import javassist.gluonj.embedded.bytecode.BadBytecode;
import javassist.gluonj.embedded.bytecode.ConstPool;
import javassist.gluonj.embedded.bytecode.Descriptor;
import javassist.gluonj.embedded.bytecode.DuplicateMemberException;
import javassist.gluonj.embedded.bytecode.FieldInfo;
import javassist.gluonj.embedded.bytecode.InnerClassesAttribute;
import javassist.gluonj.embedded.bytecode.MethodInfo;
import javassist.gluonj.embedded.bytecode.SourceFileAttribute;

public final class ClassFile {
    int major;
    int minor;
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    ArrayList fields;
    ArrayList methods;
    LinkedList attributes;
    String thisclassname;
    String[] cachedInterfaces;
    String cachedSuperclass;
    public static final int JAVA_3 = 47;
    public static final int JAVA_5 = 49;
    public static final int JAVA_6 = 50;
    public static int MAJOR_VERSION = 47;

    static {
        try {
            Class.forName("java.lang.StringBuilder");
            MAJOR_VERSION = 49;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ClassFile(DataInputStream in) throws IOException {
        this.read(in);
    }

    public ClassFile(boolean isInterface, String classname, String superclass) {
        this.major = MAJOR_VERSION;
        this.minor = 0;
        this.constPool = new ConstPool(classname);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = isInterface ? 1536 : 32;
        this.initSuperclass(superclass);
        this.interfaces = null;
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        this.thisclassname = classname;
        this.attributes = new LinkedList();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    private void initSuperclass(String superclass) {
        if (superclass != null) {
            this.superClass = this.constPool.addClassInfo(superclass);
            this.cachedSuperclass = superclass;
        } else {
            this.superClass = this.constPool.addClassInfo("java.lang.Object");
            this.cachedSuperclass = "java.lang.Object";
        }
    }

    private static String getSourcefileName(String qname) {
        int index = qname.lastIndexOf(46);
        if (index >= 0) {
            qname = qname.substring(index + 1);
        }
        return String.valueOf(qname) + ".java";
    }

    public void compact() {
        ConstPool cp = this.compact0();
        ArrayList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            minfo.compact(cp);
            ++i;
        }
        list = this.fields;
        n = list.size();
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            finfo.compact(cp);
            ++i;
        }
        this.attributes = AttributeInfo.copyAll(this.attributes, cp);
        this.constPool = cp;
    }

    private ConstPool compact0() {
        ConstPool cp = new ConstPool(this.thisclassname);
        this.thisClass = cp.getThisClassInfo();
        String sc = this.getSuperclass();
        if (sc != null) {
            this.superClass = cp.addClassInfo(this.getSuperclass());
        }
        if (this.interfaces != null) {
            int n = this.interfaces.length;
            int i = 0;
            while (i < n) {
                this.interfaces[i] = cp.addClassInfo(this.constPool.getClassInfo(this.interfaces[i]));
                ++i;
            }
        }
        return cp;
    }

    public void prune() {
        AttributeInfo signature;
        AttributeInfo visibleAnnotations;
        ConstPool cp = this.compact0();
        LinkedList<AttributeInfo> newAttributes = new LinkedList<AttributeInfo>();
        AttributeInfo invisibleAnnotations = this.getAttribute("RuntimeInvisibleAnnotations");
        if (invisibleAnnotations != null) {
            invisibleAnnotations = invisibleAnnotations.copy(cp, null);
            newAttributes.add(invisibleAnnotations);
        }
        if ((visibleAnnotations = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            visibleAnnotations = visibleAnnotations.copy(cp, null);
            newAttributes.add(visibleAnnotations);
        }
        if ((signature = this.getAttribute("Signature")) != null) {
            signature = signature.copy(cp, null);
            newAttributes.add(signature);
        }
        ArrayList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            minfo.prune(cp);
            ++i;
        }
        list = this.fields;
        n = list.size();
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            finfo.prune(cp);
            ++i;
        }
        this.attributes = newAttributes;
        cp.prune();
        this.constPool = cp;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int acc) {
        if ((acc & 0x200) == 0) {
            acc |= 0x20;
        }
        this.accessFlags = acc;
    }

    public int getInnerAccessFlags() {
        InnerClassesAttribute ica = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (ica == null) {
            return -1;
        }
        String name = this.getName();
        int n = ica.tableLength();
        int i = 0;
        while (i < n) {
            if (name.equals(ica.innerClass(i))) {
                return ica.accessFlags(i);
            }
            ++i;
        }
        return -1;
    }

    public String getName() {
        return this.thisclassname;
    }

    public void setName(String name) {
        this.renameClass(this.thisclassname, name);
    }

    public String getSuperclass() {
        if (this.cachedSuperclass == null) {
            this.cachedSuperclass = this.constPool.getClassInfo(this.superClass);
        }
        return this.cachedSuperclass;
    }

    public int getSuperclassId() {
        return this.superClass;
    }

    public void setSuperclass(String superclass) throws CannotCompileException {
        if (superclass == null) {
            superclass = "java.lang.Object";
        }
        try {
            this.superClass = this.constPool.addClassInfo(superclass);
            ArrayList list = this.methods;
            int n = list.size();
            int i = 0;
            while (i < n) {
                MethodInfo minfo = (MethodInfo)list.get(i);
                minfo.setSuperclass(superclass);
                ++i;
            }
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
        this.cachedSuperclass = superclass;
    }

    public final void renameClass(String oldname, String newname) {
        String desc;
        if (oldname.equals(newname)) {
            return;
        }
        if (oldname.equals(this.thisclassname)) {
            this.thisclassname = newname;
        }
        oldname = Descriptor.toJvmName(oldname);
        newname = Descriptor.toJvmName(newname);
        this.constPool.renameClass(oldname, newname);
        ArrayList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            ++i;
        }
        list = this.fields;
        n = list.size();
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            ++i;
        }
    }

    public final void renameClass(Map classnames) {
        String desc;
        String jvmNewThisName = (String)classnames.get(Descriptor.toJvmName(this.thisclassname));
        if (jvmNewThisName != null) {
            this.thisclassname = Descriptor.toJavaName(jvmNewThisName);
        }
        this.constPool.renameClass(classnames);
        ArrayList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, classnames));
            ++i;
        }
        list = this.fields;
        n = list.size();
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, classnames));
            ++i;
        }
    }

    public String[] getInterfaces() {
        if (this.cachedInterfaces != null) {
            return this.cachedInterfaces;
        }
        String[] rtn = null;
        if (this.interfaces == null) {
            rtn = new String[]{};
        } else {
            int n = this.interfaces.length;
            String[] list = new String[n];
            int i = 0;
            while (i < n) {
                list[i] = this.constPool.getClassInfo(this.interfaces[i]);
                ++i;
            }
            rtn = list;
        }
        this.cachedInterfaces = rtn;
        return rtn;
    }

    public void setInterfaces(String[] nameList) {
        this.cachedInterfaces = null;
        if (nameList != null) {
            int n = nameList.length;
            this.interfaces = new int[n];
            int i = 0;
            while (i < n) {
                this.interfaces[i] = this.constPool.addClassInfo(nameList[i]);
                ++i;
            }
        }
    }

    public void addInterface(String name) {
        this.cachedInterfaces = null;
        int info = this.constPool.addClassInfo(name);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = info;
        } else {
            int n = this.interfaces.length;
            int[] newarray = new int[n + 1];
            System.arraycopy(this.interfaces, 0, newarray, 0, n);
            newarray[n] = info;
            this.interfaces = newarray;
        }
    }

    public List getFields() {
        return this.fields;
    }

    public void addField(FieldInfo finfo) throws DuplicateMemberException {
        this.testExistingField(finfo.getName(), finfo.getDescriptor());
        this.fields.add(finfo);
    }

    private void addField0(FieldInfo finfo) {
        this.fields.add(finfo);
    }

    private void testExistingField(String name, String descriptor) throws DuplicateMemberException {
        ListIterator it = this.fields.listIterator(0);
        while (it.hasNext()) {
            FieldInfo minfo = (FieldInfo)it.next();
            if (!minfo.getName().equals(name)) continue;
            throw new DuplicateMemberException("duplicate field: " + name);
        }
    }

    public List getMethods() {
        return this.methods;
    }

    public MethodInfo getMethod(String name) {
        ArrayList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            if (minfo.getName().equals(name)) {
                return minfo;
            }
            ++i;
        }
        return null;
    }

    public MethodInfo getStaticInitializer() {
        return this.getMethod("<clinit>");
    }

    public void addMethod(MethodInfo minfo) throws DuplicateMemberException {
        this.testExistingMethod(minfo);
        this.methods.add(minfo);
    }

    private void addMethod0(MethodInfo minfo) {
        this.methods.add(minfo);
    }

    private void testExistingMethod(MethodInfo newMinfo) throws DuplicateMemberException {
        String name = newMinfo.getName();
        String descriptor = newMinfo.getDescriptor();
        ListIterator it = this.methods.listIterator(0);
        while (it.hasNext()) {
            if (!ClassFile.isDuplicated(newMinfo, name, descriptor, (MethodInfo)it.next(), it)) continue;
            throw new DuplicateMemberException("duplicate method: " + name + " in " + this.getName());
        }
    }

    private static boolean isDuplicated(MethodInfo newMethod, String newName, String newDesc, MethodInfo minfo, ListIterator it) {
        if (!minfo.getName().equals(newName)) {
            return false;
        }
        String desc = minfo.getDescriptor();
        if (!Descriptor.eqParamTypes(desc, newDesc)) {
            return false;
        }
        if (desc.equals(newDesc)) {
            if (ClassFile.notBridgeMethod(minfo)) {
                return true;
            }
            it.remove();
            return false;
        }
        return ClassFile.notBridgeMethod(minfo) && ClassFile.notBridgeMethod(newMethod);
    }

    private static boolean notBridgeMethod(MethodInfo minfo) {
        return (minfo.getAccessFlags() & 0x40) == 0;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String name) {
        LinkedList list = this.attributes;
        int n = list.size();
        int i = 0;
        while (i < n) {
            AttributeInfo ai = (AttributeInfo)list.get(i);
            if (ai.getName().equals(name)) {
                return ai;
            }
            ++i;
        }
        return null;
    }

    public void addAttribute(AttributeInfo info) {
        AttributeInfo.remove(this.attributes, info.getName());
        this.attributes.add(info);
    }

    public String getSourceFile() {
        SourceFileAttribute sf = (SourceFileAttribute)this.getAttribute("SourceFile");
        if (sf == null) {
            return null;
        }
        return sf.getFileName();
    }

    private void read(DataInputStream in) throws IOException {
        int i;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("bad magic number: " + Integer.toHexString(magic));
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        this.constPool = new ConstPool(in);
        this.accessFlags = in.readUnsignedShort();
        this.thisClass = in.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = in.readUnsignedShort();
        int n = in.readUnsignedShort();
        if (n == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n];
            i = 0;
            while (i < n) {
                this.interfaces[i] = in.readUnsignedShort();
                ++i;
            }
        }
        ConstPool cp = this.constPool;
        n = in.readUnsignedShort();
        this.fields = new ArrayList();
        i = 0;
        while (i < n) {
            this.addField0(new FieldInfo(cp, in));
            ++i;
        }
        n = in.readUnsignedShort();
        this.methods = new ArrayList();
        i = 0;
        while (i < n) {
            this.addMethod0(new MethodInfo(cp, in));
            ++i;
        }
        this.attributes = new LinkedList();
        n = in.readUnsignedShort();
        i = 0;
        while (i < n) {
            this.addAttribute(AttributeInfo.read(cp, in));
            ++i;
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(this.minor);
        out.writeShort(this.major);
        this.constPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.thisClass);
        out.writeShort(this.superClass);
        int n = this.interfaces == null ? 0 : this.interfaces.length;
        out.writeShort(n);
        int i = 0;
        while (i < n) {
            out.writeShort(this.interfaces[i]);
            ++i;
        }
        ArrayList list = this.fields;
        n = list.size();
        out.writeShort(n);
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            finfo.write(out);
            ++i;
        }
        list = this.methods;
        n = list.size();
        out.writeShort(n);
        i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            minfo.write(out);
            ++i;
        }
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, out);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public void setMajorVersion(int major) {
        this.major = major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int minor) {
        this.minor = minor;
    }

    public void setVersionToJava5() {
        this.major = 49;
        this.minor = 0;
    }
}

