/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.loader.tomcat;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import javassist.gluonj.Glue;
import javassist.gluonj.Overwrite;
import javassist.gluonj.Refine;
import javassist.gluonj.WeaveException;
import javassist.gluonj.Within;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.LoaderClassPath;
import javassist.gluonj.loader.ClassLoaderException;
import javassist.gluonj.weave.Weaver;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.loader.WebappLoader;

@Glue
public class WeaverGlue {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Refine
    static class WebappClassLoaderEx
    extends WebappClassLoader {
        private static final String PROPRESOURCENAME = "/gluonj.properties";
        private static final String PROPGLUENAME = "gluename";
        private String _contextPath = WebappLoaderEx.CONTEXT_PATH_CACHE.get();
        private String _glueName;
        private Weaver _weaver;

        public WebappClassLoaderEx() {
            super(null);
            this.logInfo("[ ContextPath ] " + this._contextPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws LifecycleException {
            super.start();
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            synchronized (classLoader) {
                try {
                    this.init(this._contextPath);
                }
                catch (WeaveException e) {
                    throw new LifecycleException(e.getMessage(), (Throwable)e);
                }
            }
        }

        public void stop() throws LifecycleException {
            super.stop();
            this._weaver = null;
            this._glueName = null;
            this._contextPath = null;
        }

        protected void init(String contextPath) throws WeaveException {
            if (contextPath == null) {
                throw new ClassLoaderException("Context path is null.");
            }
            this.logInfo("ContextPath: " + contextPath);
            this.parseSettings();
            if (this._glueName != null) {
                ClassPool pool = new ClassPool(true);
                pool.insertClassPath(new LoaderClassPath((ClassLoader)((Object)this)));
                pool.appendClassPath(new LoaderClassPath(this.getParent()));
                this._weaver = new Weaver(this._glueName, pool, (ClassLoader)((Object)this));
            }
        }

        protected void parseSettings() {
            URL url = this.getResource(PROPRESOURCENAME);
            if (url == null) {
                return;
            }
            this.logInfo("GluonJ properties loading...");
            try {
                PropertyResourceBundle bundle = new PropertyResourceBundle(this.getResourceAsStream(PROPRESOURCENAME));
                String glueName = bundle.getString(PROPGLUENAME);
                this._glueName = glueName == null || glueName.length() == 0 ? null : glueName;
                this.logInfo("GluonJ properties loading success, gluename=" + this._glueName);
            }
            catch (MissingResourceException e) {
                this.logError("GluonJ properties loading failed. (MissingResource)");
            }
            catch (IOException e) {
                this.logError("GluonJ properties loading failed. (IOException)");
            }
        }

        protected Class<?> defineWovenClass(String name, byte[] binaryContent) {
            if (this.isNonTransformable(name)) {
                return null;
            }
            if (this._weaver != null) {
                try {
                    byte[] bs = this._weaver.transform(name, binaryContent);
                    if (bs != null) {
                        return super.defineClass(name, bs, 0, bs.length);
                    }
                    this.logWarn("not transform. name=" + name);
                }
                catch (WeaveException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        protected boolean isNonTransformable(String name) {
            return name.startsWith("javassit.");
        }

        protected void logInfo(String message) {
            this.logMessage(message, "info");
        }

        protected void logWarn(String message) {
            this.logMessage(message, "warn");
        }

        protected void logError(String message) {
            this.logMessage(message, "error");
        }

        protected void logMessage(String message, String methodName) {
            try {
                Field field = ((Object)((Object)this)).getClass().getDeclaredField("log");
                Object obj = field.get(field.getType());
                Class<?> lclazz = field.getType();
                Method method = lclazz.getMethod(methodName, Class.forName("java.lang.Object"));
                method.invoke(obj, message);
            }
            catch (SecurityException e) {
                System.err.println(e);
            }
            catch (NoSuchFieldException e) {
                System.err.println(e);
            }
            catch (NoSuchMethodException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            catch (InvocationTargetException e) {
                System.err.println(e);
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
            }
        }

        @Overwrite(value="defineClass")
        @Within(value="org.apache.catalina.loader.*")
        protected Class<?> new_defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
            Class<?> cc = this.defineWovenClass(name, b);
            if (cc == null) {
                return super.defineClass(name, b, off, len, cs);
            }
            return cc;
        }
    }

    @Refine
    static class WebappLoaderEx
    extends WebappLoader {
        protected static ThreadLocal<String> CONTEXT_PATH_CACHE = new ThreadLocal();

        public void start() throws LifecycleException {
            CONTEXT_PATH_CACHE.set(this.getContextPath());
            super.start();
            CONTEXT_PATH_CACHE.remove();
        }

        protected String getContextPath() {
            if (!(this.getContainer() instanceof Context)) {
                throw new RuntimeException("Could not get Context Path.");
            }
            Context context = (Context)this.getContainer();
            return context.getPath();
        }
    }
}

