/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.util.ArrayList;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.weave.RefineWeaver;

public class NamePattern {
    private String pattern;
    private boolean singleMatch;
    private String[] classNames;
    private char[] options;

    public NamePattern(String pattern) throws WeaveException {
        ArrayList<String> opt;
        ArrayList<String> names;
        block6: {
            char c;
            this.pattern = pattern;
            this.singleMatch = true;
            Lex lex = new Lex();
            names = new ArrayList<String>();
            opt = new ArrayList<String>();
            do {
                if (lex.nextToken(pattern) != '*') {
                    throw new WeaveException("bad pattern: " + pattern);
                }
                names.add(this.toRegex(lex.get(pattern)));
                c = lex.nextToken(pattern);
                if (c == '+') {
                    c = lex.nextToken(pattern);
                    opt.add("+");
                    this.singleMatch = false;
                } else {
                    opt.add(" ");
                }
                if (c == '\u0000') break block6;
            } while (c == '|');
            throw new WeaveException("bad pattern: " + pattern + ", " + c);
        }
        this.classNames = names.toArray(new String[names.size()]);
        int n = opt.size();
        this.options = new char[n];
        for (int i = 0; i < n; ++i) {
            this.options[i] = ((String)opt.get(i)).charAt(0);
        }
        if (n > 1) {
            this.singleMatch = false;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isSingleMatch() {
        return this.singleMatch;
    }

    public boolean match(String name, ClassPool cp) {
        int n = this.classNames.length;
        for (int i = 0; i < n; ++i) {
            if (!name.matches(this.classNames[i])) continue;
            return !RefineWeaver.hasGluonJTag(name);
        }
        return false;
    }

    public boolean matchMember(String name, ClassPool cp) {
        return this.match(name, cp);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.classNames.length; ++i) {
            if (i > 0) {
                sbuf.append('|');
            }
            sbuf.append(this.classNames[i]);
            if (this.options[i] == ' ') continue;
            sbuf.append(this.options[i]);
        }
        return sbuf.toString();
    }

    private String toRegex(String pat) {
        StringBuffer sbuf = new StringBuffer();
        int n = pat.length();
        for (int i = 0; i < n; ++i) {
            char c = pat.charAt(i);
            if (c == '.') {
                sbuf.append("\\.");
                continue;
            }
            if (c == '$') {
                sbuf.append("\\$");
                continue;
            }
            if (c == '*') {
                sbuf.append(".*");
                this.singleMatch = false;
                continue;
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    static class Lex {
        int start = 0;
        int end = 0;

        Lex() {
        }

        String get(String str) {
            if (this.start >= this.end) {
                return null;
            }
            return str.substring(this.start, this.end);
        }

        char nextToken(String str) {
            char c;
            int pos = this.end;
            int len = str.length();
            do {
                if (pos < len) continue;
                return '\u0000';
            } while ((c = str.charAt(pos++)) == ' ' || c == '\t');
            this.start = pos - 1;
            if (c == '+' || c == '|') {
                this.end = pos;
                return c;
            }
            while (pos < len && (c = str.charAt(pos)) != ' ' && c != '\t' && c != '+' && c != '|') {
                ++pos;
            }
            this.end = pos;
            return '*';
        }
    }
}

