/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import org.jabsorb.JSONRPCBridge;
import org.jabsorb.JSONRPCBridgeState;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger((Class)ReferenceSerializer.class);
    private static Class[] _serializableClasses = new Class[0];
    private static Class[] _JSONClasses = new Class[0];
    private JSONRPCBridge bridge;

    public ReferenceSerializer(JSONRPCBridge bridge) {
        this.bridge = bridge;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return !(clazz.isArray() || clazz.isPrimitive() || clazz.isInterface() || !this.bridge.isReference(clazz) && !this.bridge.isCallableReference(clazz) || jsonClazz != null && jsonClazz != JSONObject.class);
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        Class<?> clazz = o.getClass();
        Integer identity = new Integer(System.identityHashCode(o));
        if (this.bridge.isReference(clazz)) {
            if (log.isDebugEnabled()) {
                log.debug("marshalling reference to object " + identity + " of class " + clazz.getName());
            }
            JSONRPCBridgeState jSONRPCBridgeState = this.bridge.getBridgeState();
            synchronized (jSONRPCBridgeState) {
                this.bridge.getReferenceMap().put(identity, o);
            }
            JSONObject jso = new JSONObject();
            try {
                jso.put("JSONRPCType", "Reference");
                jso.put("javaClass", clazz.getName());
                jso.put("objectID", identity);
            }
            catch (JSONException e) {
                throw new MarshallException(e.getMessage());
            }
            return jso;
        }
        if (this.bridge.isCallableReference(clazz)) {
            if (log.isDebugEnabled()) {
                log.debug("marshalling callable reference to object " + identity + " of class " + clazz.getName());
            }
            this.bridge.registerObject(identity, o);
            JSONObject jso = new JSONObject();
            try {
                jso.put("JSONRPCType", "CallableReference");
                jso.put("javaClass", clazz.getName());
                jso.put("objectID", identity);
            }
            catch (JSONException e) {
                throw new MarshallException(e.getMessage());
            }
            return jso;
        }
        return null;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        state.setSerialized(o, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int object_id;
        String json_type;
        JSONObject jso = (JSONObject)o;
        Object ref = null;
        try {
            json_type = jso.getString("JSONRPCType");
            object_id = jso.getInt("objectID");
        }
        catch (JSONException e) {
            throw new UnmarshallException(e.getMessage(), e);
        }
        if (json_type != null && json_type.equals("Reference")) {
            JSONRPCBridgeState jSONRPCBridgeState = this.bridge.getBridgeState();
            synchronized (jSONRPCBridgeState) {
                ref = this.bridge.getReferenceMap().get(new Integer(object_id));
            }
        }
        state.setSerialized(o, ref);
        return ref;
    }
}

