/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class ResourceUtils {
    private static final String FILE_URL_PREFIX = "file:";
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    private static final String URL_PROTOCOL_VFS = "vfs";
    private static final String URL_PROTOCOL_JAR = "jar";
    private static final String URL_PROTOCOL_ZIP = "zip";
    private static final String URL_PROTOCOL_WSJAR = "wsjar";
    private static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    private static final String JAR_URL_SEPARATOR = "!/";

    public static File getFile(URL resourceUrl) {
        return ResourceUtils.getFile(resourceUrl, "URL");
    }

    public static File getFile(URL resourceUrl, String description) {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL must not be null");
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol) && ResourceUtils.getFile(url).exists();
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }

    public static URL extractJarFileURL(URL jarUrl) {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                try {
                    return new URL(FILE_URL_PREFIX + jarFile);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return jarUrl;
    }

    public static String extractJarEntryPath(URL jarUrl) {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            return urlFile.substring(separatorIndex + JAR_URL_SEPARATOR.length());
        }
        return null;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(ResourceUtils.replace(location, " ", "%20"));
    }

    private static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }
}

