/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.ManifestTask;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.JApplication;
import org.objectstyle.woproject.ant.JApplicationWorker;

class JApplicationJavaWorker
implements JApplicationWorker {
    protected JApplication task;
    protected File baseDir;
    protected File scratchDir;
    protected Collection unpackedJarDirs;
    protected File manifestFile;

    JApplicationJavaWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JApplication jApplication) throws BuildException {
        this.task = jApplication;
        this.baseDir = jApplication.getDestDir();
        this.unpackedJarDirs = new ArrayList();
        try {
            this.executeInternal();
        }
        finally {
            if (!this.recursiveDelete(this.scratchDir)) {
                throw new BuildException("Failed to clean up temp directory: " + this.scratchDir);
            }
        }
    }

    protected void executeInternal() throws BuildException {
        this.createDirectories();
        this.createManifest();
        this.unpackJars();
        this.createFatJar();
    }

    void createManifest() throws BuildException {
        this.manifestFile = new File(this.scratchDir, "MANIFEST.MF");
        Manifest.Attribute attribute = new Manifest.Attribute();
        attribute.setName("Main-Class");
        attribute.setValue(this.task.getMainClass());
        ManifestTask manifestTask = (ManifestTask)this.task.createSubtask(ManifestTask.class);
        manifestTask.setFile(this.manifestFile);
        try {
            manifestTask.addConfiguredAttribute(attribute);
        }
        catch (ManifestException manifestException) {
            throw new BuildException("Manifest error", (Throwable)manifestException);
        }
        manifestTask.execute();
    }

    void createFatJar() throws BuildException {
        File file = new File(this.baseDir, this.task.getName() + ".jar");
        file.delete();
        Jar jar = (Jar)this.task.createSubtask(Jar.class);
        jar.setDestFile(file);
        jar.setManifest(this.manifestFile);
        for (File file2 : this.unpackedJarDirs) {
            FileSet fileSet = new FileSet();
            fileSet.setDir(file2);
            jar.addFileset(fileSet);
        }
        jar.execute();
    }

    void unpackJars() throws BuildException {
        int n = 0;
        for (FileSet fileSet : this.task.getLibs()) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.task.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            Expand expand = (Expand)this.task.createSubtask(Expand.class);
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(this.scratchDir, n++ + "");
                file.mkdirs();
                this.unpackedJarDirs.add(file);
                expand.setDest(file);
                expand.setSrc(new File(directoryScanner.getBasedir(), stringArray[i]));
                expand.execute();
            }
        }
    }

    void createDirectories() throws BuildException {
        if (!this.baseDir.isDirectory() && !this.baseDir.mkdirs()) {
            throw new BuildException("Can't create directory " + this.baseDir.getAbsolutePath());
        }
        File file = new File(System.getProperty("java.io.tmpdir"));
        String string = "japplication-" + System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            File file2 = new File(file, string + i);
            if (file2.exists() || !file2.mkdirs()) continue;
            this.scratchDir = file2;
            break;
        }
        if (!this.scratchDir.isDirectory()) {
            throw new BuildException("Can't create scratch directory");
        }
    }

    boolean recursiveDelete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return file.delete();
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.recursiveDelete(new File(file, stringArray[i]))) continue;
            return false;
        }
        return file.delete();
    }
}

