/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.JApplication;
import org.objectstyle.woproject.ant.JApplicationWorker;
import org.objectstyle.woproject.ant.TokenFilter;

class JApplicationMacWorker
implements JApplicationWorker {
    private static final String STUB = "/System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub";
    protected JApplication task;
    protected File contentsDir;
    protected File resourcesDir;
    protected File javaDir;
    protected File macOSDir;
    protected File stub;

    JApplicationMacWorker() {
    }

    public void execute(JApplication jApplication) throws BuildException {
        this.task = jApplication;
        File file = new File(jApplication.getDestDir(), jApplication.getName() + ".app");
        this.contentsDir = new File(file, "Contents");
        this.macOSDir = new File(this.contentsDir, "MacOS");
        this.resourcesDir = new File(this.contentsDir, "Resources");
        this.javaDir = new File(this.resourcesDir, "Java");
        this.stub = new File(STUB);
        if (!this.stub.isFile()) {
            throw new BuildException("Java stub file not found. Is this a Mac? /System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub");
        }
        this.createDirectories();
        this.copyStub();
        this.copyIcon();
        this.copyJars();
        this.createInfoPlist();
    }

    void createDirectories() throws BuildException {
        this.createDirectory(this.task.getDestDir());
        this.createDirectory(this.resourcesDir);
        this.createDirectory(this.javaDir);
        this.createDirectory(this.macOSDir);
    }

    void createDirectory(File file) throws BuildException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new BuildException("Can't create directory " + file.getAbsolutePath());
        }
    }

    void createInfoPlist() throws BuildException {
        File file = new File(this.contentsDir, "Info.plist");
        String string = this.task.getIcon() != null && this.task.getIcon().isFile() ? this.task.getIcon().getName() : "";
        String string2 = this.task.getJvmOptions() != null ? this.task.getJvmOptions() : "";
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.javaDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("          <string>$JAVAROOT/").append(stringArray[i]).append("</string>\n");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("@NAME@", this.task.getName());
        hashMap.put("@VERSION@", this.task.getVersion());
        hashMap.put("@LONG_NAME@", this.task.getLongName());
        hashMap.put("@MAIN_CLASS@", this.task.getMainClass());
        hashMap.put("@VERSION@", this.task.getVersion());
        hashMap.put("@ICON@", string);
        hashMap.put("@JVM@", this.task.getJvm());
        hashMap.put("@JVM_OPTIONS@", string2);
        hashMap.put("@JARS@", stringBuffer.toString());
        new TokenFilter(hashMap).copy("japplication/mac/Info.plist", file);
    }

    void copyStub() throws BuildException {
        Copy copy = (Copy)this.task.createSubtask(Copy.class);
        copy.setTodir(this.macOSDir);
        copy.setFile(this.stub);
        copy.execute();
        Chmod chmod = (Chmod)this.task.createSubtask(Chmod.class);
        chmod.setPerm("755");
        chmod.setFile(new File(this.macOSDir, "JavaApplicationStub"));
        chmod.execute();
    }

    void copyIcon() throws BuildException {
        if (this.task.getIcon() != null && this.task.getIcon().isFile()) {
            Copy copy = (Copy)this.task.createSubtask(Copy.class);
            copy.setTodir(this.resourcesDir);
            copy.setFile(this.task.getIcon());
            copy.execute();
        }
    }

    void copyJars() {
        if (!this.task.getLibs().isEmpty()) {
            Copy copy = (Copy)this.task.createSubtask(Copy.class);
            copy.setTodir(this.javaDir);
            copy.setFlatten(true);
            for (FileSet fileSet : this.task.getLibs()) {
                copy.addFileset(fileSet);
            }
            copy.execute();
        }
    }
}

