/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.objectstyle.woproject.ant.FileUtil;
import org.objectstyle.woproject.ant.JApplicationJavaWorker;
import org.objectstyle.woproject.ant.TokenFilter;

class JApplicationWindowsWorker
extends JApplicationJavaWorker {
    static final String EMBEDDED_NSIS_PATH = "japplication/windows/nsis-2.20";
    protected String nsisExe;
    protected File nsiScript;

    JApplicationWindowsWorker() {
    }

    protected void executeInternal() throws BuildException {
        super.executeInternal();
        this.createNsisScript();
        this.initNsis();
        this.execNsis();
    }

    void execNsis() throws BuildException {
        ExecTask execTask = (ExecTask)this.task.createSubtask(ExecTask.class);
        execTask.setDir(this.baseDir);
        execTask.setExecutable(this.nsisExe);
        execTask.setFailonerror(true);
        execTask.createArg().setLine(this.nsiScript.getAbsolutePath());
        execTask.execute();
    }

    void initNsis() throws BuildException {
        this.task.log("Extracting embedded NSIS", 4);
        File file = new File(this.scratchDir, "nsis");
        this.extractResource("makensis.exe", file);
        this.extractResource("Stubs/bzip2", file);
        this.extractResource("Stubs/bzip2_solid", file);
        this.extractResource("Stubs/lzma", file);
        this.extractResource("Stubs/lzma_solid", file);
        this.extractResource("Stubs/uninst", file);
        this.extractResource("Stubs/zlib", file);
        this.extractResource("Stubs/zlib_solid", file);
        this.nsisExe = new File(file, "makensis.exe").getAbsolutePath();
    }

    void createNsisScript() throws BuildException {
        String string = this.task.getIcon() != null && this.task.getIcon().isFile() ? "Icon \"" + this.task.getIcon().getAbsolutePath() + "\"" : "";
        String string2 = this.task.getJvmOptions() != null ? this.task.getJvmOptions() : "";
        String string3 = new File(this.baseDir, this.task.getName() + ".exe").getAbsolutePath();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("@NAME@", this.task.getName());
        hashMap.put("@LONG_NAME@", this.task.getLongName());
        hashMap.put("@MAIN_CLASS@", this.task.getMainClass());
        hashMap.put("@ICON@", string);
        hashMap.put("@JVM_OPTIONS@", string2);
        hashMap.put("@OUT_FILE@", string3);
        this.nsiScript = new File(this.scratchDir, "app.nsi");
        new TokenFilter(hashMap).copy("japplication/windows/app.nsi", this.nsiScript);
    }

    void extractResource(String string, File file) {
        String string2 = "japplication/windows/nsis-2.20/" + string;
        String string3 = '/' != File.separatorChar ? string.replace('/', File.separatorChar) : string;
        FileUtil.copy(string2, new File(file, string3));
    }
}

