/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtherClasspathSet
extends FileSet {
    protected File aDirectory;
    protected boolean packagesOnly = false;
    protected boolean embed = false;
    protected boolean eclipse = false;

    public void setEclipse(boolean bl) {
        this.eclipse = bl;
    }

    public boolean isEclipse() {
        return this.eclipse;
    }

    private File[] findPackages(Project project, String string) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(new String[]{"**/*.jar", "**/*.zip"});
        directoryScanner.setBasedir(this.getDir(project) + File.separator + string);
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(this.getDir(project), stringArray[i]);
        }
        return fileArray;
    }

    public void collectClassPaths(Project project, HashSet<File> hashSet) throws BuildException {
        Object object;
        int n;
        DirectoryScanner directoryScanner = this.getDirectoryScanner(project);
        String[] stringArray = directoryScanner.getIncludedDirectories();
        String[] stringArray2 = directoryScanner.getIncludedFiles();
        for (n = 0; n < stringArray.length; ++n) {
            if (this.isPackagesOnly()) {
                object = this.findPackages(project, stringArray[n]);
                if (object == null || ((File[])object).length == 0) {
                    this.log("No Jars in project:" + project + ", ignoring.", 3);
                    continue;
                }
                if (this.getEmbed()) {
                    this.log("embed and isPackagesOnly are mutually exclusive");
                    continue;
                }
                int n2 = ((Object)object).length;
                for (int i = 0; i < n2; ++i) {
                    hashSet.add((File)object[i]);
                }
                continue;
            }
            object = new File(this.getDir(project), stringArray[n]);
            if (!((File)object).exists()) continue;
            if (this.getEmbed()) {
                hashSet.add(new File("APPROOT", stringArray[n]));
                continue;
            }
            hashSet.add((File)object);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (!stringArray2[n].endsWith(".zip") && !stringArray2[n].endsWith(".jar")) {
                this.log("No Jars in " + stringArray2[n] + ", ignoring.", 3);
                continue;
            }
            object = new File(this.getDir(project), stringArray2[n]);
            if (!((File)object).exists()) continue;
            hashSet.add((File)object);
        }
    }

    public boolean isPackagesOnly() {
        return this.packagesOnly;
    }

    public void setDir(File file) throws BuildException {
        this.aDirectory = file;
        super.setDir(this.aDirectory);
    }

    public void setRoot(File file) throws BuildException {
        this.aDirectory = file;
        super.setDir(this.aDirectory);
    }

    public void setPackagesOnly(boolean bl) {
        this.packagesOnly = bl;
    }

    public void setEmbed(boolean bl) {
        this.embed = bl;
    }

    public boolean getEmbed() {
        return this.embed;
    }
}

