/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woenvironment.pb.PBProject;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.SubtaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBIndex
extends Task {
    protected String name;
    protected File projectFile;
    protected boolean framework;
    protected Vector<FileSet> src = new Vector();
    protected Vector<FileSet> wocomponents = new Vector();
    protected Vector<FileSet> resources = new Vector();
    protected Vector<FileSet> wsresources = new Vector();
    protected Vector<FrameworkSet> frameworkSets = new Vector();
    protected SubtaskFactory subtaskFactory = new SubtaskFactory(this);

    public void addWocomponents(FileSet fileSet) {
        this.wocomponents.addElement(fileSet);
    }

    public void addSrc(FileSet fileSet) {
        this.src.addElement(fileSet);
    }

    public void addResources(FileSet fileSet) {
        this.resources.addElement(fileSet);
    }

    public void addWsresources(FileSet fileSet) {
        this.wsresources.addElement(fileSet);
    }

    public void addFrameworks(FrameworkSet frameworkSet) {
        this.frameworkSets.addElement(frameworkSet);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File file) {
        this.projectFile = file;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public void setFramework(boolean bl) {
        this.framework = bl;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        PBProject pBProject = null;
        try {
            pBProject = this.projectFile != null ? new PBProject(this.projectFile.getPath(), this.framework) : new PBProject(this.framework);
            pBProject.setProjectName(this.name);
            pBProject.setClasses(this.extractJavaFiles(this.src));
            pBProject.setWoComponents(this.extractWOComponents(this.wocomponents));
            pBProject.setWoAppResources(this.extractResources(this.resources, "**/*.eomodeld/index.eomodeld"));
            pBProject.setWebServerResources(this.extractResources(this.wsresources, null));
            this.extractFrameworks(pBProject);
            pBProject.saveChanges();
        }
        catch (Exception exception) {
            this.log("Error saving project file", 0);
            throw new BuildException("Error saving project file", (Throwable)exception);
        }
        finally {
            pBProject = null;
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("Required 'name' attribute is missing.");
        }
    }

    protected List<String> extractWOComponents(Vector<FileSet> vector) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileSet fileSet : vector) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedDirectories();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(".wo")) continue;
                arrayList.add(this.fixPath(stringArray[i]));
            }
        }
        return arrayList;
    }

    protected List<String> extractJavaFiles(Vector<FileSet> vector) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileSet fileSet : vector) {
            fileSet.createExclude().setName("*.subproj/**");
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(".java")) continue;
                arrayList.add(this.fixPath(stringArray[i]));
            }
        }
        return arrayList;
    }

    protected List<String> extractResources(Vector<FileSet> vector, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (vector.size() > 0) {
            for (FileSet fileSet : vector) {
                if (string != null) {
                    fileSet.createExclude().setName(string);
                }
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                directoryScanner.scan();
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(this.fixPath(stringArray[i]));
                }
                String[] stringArray2 = directoryScanner.getIncludedDirectories();
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(this.fixPath(stringArray2[i]));
                }
            }
        }
        return arrayList;
    }

    protected void extractFrameworks(PBProject pBProject) {
        List list = pBProject.getFrameworks();
        for (FrameworkSet frameworkSet : this.frameworkSets) {
            File file = frameworkSet.getDir(frameworkSet.getProject());
            String[] stringArray = frameworkSet.getDirectoryScanner(frameworkSet.getProject()).getIncludedDirectories();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (list.contains(file2.getName())) continue;
                list.add(file2.getName());
            }
        }
    }

    protected String fixPath(String string) {
        return File.separatorChar == '\\' ? string.replace('\\', '/') : string;
    }
}

