/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woenvironment.pb.PBXProject;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.SubtaskFactory;
import org.objectstyle.woproject.ant.WOFileSet;

public class PBXIndex
extends Task {
    protected File projectFile;
    protected Vector resources = new Vector();
    protected Vector wsresources = new Vector();
    protected Vector frameworkSets = new Vector();
    protected Vector sources = new Vector();
    protected SubtaskFactory subtaskFactory = new SubtaskFactory(this);

    public void addSources(WOFileSet wOFileSet) {
        this.sources.addElement(wOFileSet);
    }

    public void addResources(WOFileSet wOFileSet) {
        this.resources.addElement(wOFileSet);
    }

    public void addWsResources(WOFileSet wOFileSet) {
        this.wsresources.addElement(wOFileSet);
    }

    public void addFrameworks(FrameworkSet frameworkSet) {
        this.frameworkSets.addElement(frameworkSet);
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File file) {
        this.projectFile = file;
    }

    public void execute() throws BuildException {
        File file;
        this.validateAttributes();
        PBXProject pBXProject = new PBXProject();
        this.addToProject(pBXProject);
        if (this.getProjectFile().exists()) {
            if (!this.getProjectFile().isDirectory()) {
                throw new BuildException("Specified PBX project package is not a directory.");
            }
        } else {
            this.getProjectFile().mkdir();
        }
        if (!(file = new File(this.getProjectFile(), "project.pbxproj")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new BuildException("Failed to create project.pbxproj PBX project package file: " + iOException);
            }
        }
        try {
            pBXProject.save(file);
        }
        catch (Exception exception) {
            throw new BuildException("Failed to save project.pbxproj Xcode project package file: " + exception);
        }
    }

    protected void addToProject(PBXProject pBXProject) {
        int n;
        String[] stringArray;
        String[] stringArray2;
        DirectoryScanner directoryScanner;
        File file;
        for (FileSet fileSet : this.sources) {
            if (!fileSet.testIfCondition()) continue;
            file = fileSet.getDir(this.getProject());
            directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            directoryScanner.scan();
            stringArray2 = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray2.length; ++i) {
                pBXProject.addSourceReference(new File(file, this.fixPath(stringArray2[i])).getAbsolutePath());
            }
            stringArray = directoryScanner.getIncludedDirectories();
            for (n = 0; n < stringArray.length; ++n) {
                pBXProject.addSourceReference(new File(file, this.fixPath(stringArray[n])).getAbsolutePath());
            }
        }
        for (FileSet fileSet : this.resources) {
            if (!fileSet.testIfCondition()) continue;
            file = fileSet.getDir(this.getProject());
            directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            directoryScanner.scan();
            stringArray2 = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray2.length; ++i) {
                pBXProject.addResourceFileReference(new File(file, this.fixPath(stringArray2[i])).getAbsolutePath());
            }
            stringArray = directoryScanner.getIncludedDirectories();
            for (n = 0; n < stringArray.length; ++n) {
                pBXProject.addResourceFolderReference(new File(file, this.fixPath(stringArray[n])).getAbsolutePath());
            }
        }
        for (FileSet fileSet : this.wsresources) {
            if (!fileSet.testIfCondition()) continue;
            file = fileSet.getDir(this.getProject());
            directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            directoryScanner.scan();
            stringArray2 = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray2.length; ++i) {
                pBXProject.addWSResourceFileReference(new File(file, this.fixPath(stringArray2[i])).getAbsolutePath());
            }
            stringArray = directoryScanner.getIncludedDirectories();
            for (n = 0; n < stringArray.length; ++n) {
                pBXProject.addWSResourceFolderReference(new File(file, this.fixPath(stringArray[n])).getAbsolutePath());
            }
        }
        for (FileSet fileSet : this.frameworkSets) {
            file = fileSet.getDir(this.getProject());
            directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            directoryScanner.scan();
            stringArray2 = directoryScanner.getIncludedDirectories();
            for (int i = 0; i < stringArray2.length; ++i) {
                pBXProject.addFrameworkReference(new File(file, this.fixPath(stringArray2[i])).getAbsolutePath());
            }
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.projectFile == null) {
            throw new BuildException("Required 'projectFile' attribute is missing.");
        }
    }

    protected String fixPath(String string) {
        return File.separatorChar == '\\' ? string.replace('\\', '/') : string;
    }
}

