/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.objectstyle.woproject.ant.FileUtil;

class TokenFilter {
    private Map tokens;
    private String lineEnd = System.getProperty("line.separator");

    TokenFilter(Map map) {
        this.tokens = new HashMap(map.size() * 2);
        for (Map.Entry entry : map.entrySet()) {
            this.tokens.put(Pattern.compile(entry.getKey().toString()), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copy(String string, File file) throws BuildException {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("Resource not found: " + string);
            }
            FileUtil.ensureParentDirExists(file);
            FileWriter fileWriter = new FileWriter(file);
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.writeLine(fileWriter, string2);
                }
            }
            finally {
                try {
                    ((Writer)fileWriter).close();
                }
                catch (IOException iOException) {}
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error copying resource " + string, (Throwable)iOException);
        }
    }

    void writeLine(Writer writer, String string) throws IOException {
        if (string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (Map.Entry entry : this.tokens.entrySet()) {
                Pattern pattern = (Pattern)entry.getKey();
                String string2 = entry.getValue().toString();
                Matcher matcher = pattern.matcher(stringBuffer);
                int n = 0;
                while (matcher.find(n)) {
                    stringBuffer.replace(matcher.start(), matcher.end(), string2);
                    n = matcher.start() + string2.length();
                }
            }
            writer.write(stringBuffer.toString());
        } else {
            writer.write(string);
        }
        writer.write(this.lineEnd);
    }
}

