/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.objectstyle.woproject.ant.WOTask;

public class WOMapper
extends Mapper {
    private final String LPROJ_SUFFIX = ".lproj";
    private final String SUBPROJ_SUFFIX = ".subproj";
    private final String NON_LOCALIZED = "Nonlocalized.lproj";
    WOTask wotask;
    String[] pattern;

    public WOMapper(Project project, Task task) {
        super(project);
        if (task != null && task instanceof WOTask) {
            this.wotask = (WOTask)task;
        }
    }

    public FileNameMapper getImplementation() throws BuildException {
        return new WOFileNameMapper();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WOFileNameMapper
    extends IdentityMapper {
        WOFileNameMapper() {
        }

        public String[] mapFileName(String string) {
            if ("Nonlocalized.lproj".equals(string)) {
                return null;
            }
            String string2 = this.subprojFilter(string);
            String string3 = this.localizationFilter(string2);
            String string4 = this.wocompFilter(string3);
            String string5 = this.resourcesFilter(string4);
            String string6 = this.webserverResourcesFilter(string5);
            String string7 = this.miscFilter(string6);
            String string8 = this.applyFlattenfiles(string7);
            String string9 = this.eomodelFilter(string8);
            return new String[]{string9};
        }

        private final String resourcesFilter(String string) {
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null && string2.equals("Resources")) {
                return this.flatten(file);
            }
            String string3 = "Resources" + File.separator;
            int n = string.indexOf(string3);
            if (n >= 0) {
                return string.substring(n + string3.length());
            }
            return string;
        }

        private final String webserverResourcesFilter(String string) {
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null && string2.equals("WebServerResources")) {
                return this.flatten(new File(string));
            }
            String string3 = "WebServerResources" + File.separator;
            int n = string.indexOf(string3);
            if (n >= 0) {
                return string.substring(n + string3.length());
            }
            return string;
        }

        private final String miscFilter(String string) {
            File file = new File(string);
            if (string.endsWith(".strings")) {
                return this.flatten(file);
            }
            if (string.endsWith(".plist") && string.indexOf(".eomodeld") <= 0) {
                return this.flatten(file);
            }
            return string;
        }

        private final String wocompFilter(String string) {
            File file = new File(string);
            if (string.endsWith(".wo") || string.endsWith(".api")) {
                return this.flatten(file);
            }
            String string2 = file.getParent();
            if (string2 != null && string2.endsWith(".wo")) {
                return this.flattenWithParent(file);
            }
            return string;
        }

        private final String eomodelFilter(String string) {
            File file = new File(string);
            if (string.endsWith(".eomodeld") && !string.endsWith("index.eomodeld")) {
                return this.flatten(file);
            }
            String string2 = file.getParent();
            if (string2 != null && string2.endsWith(".eomodeld")) {
                return this.flattenWithParent(file);
            }
            return string;
        }

        private String subprojFilter(String string) {
            String string2;
            File file = new File(string);
            File file2 = null;
            for (File file3 = file.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
                file2 = file3;
            }
            if (file2 != null && (string2 = file2.getName()).endsWith(".subproj")) {
                return string.substring(string2.length());
            }
            return string;
        }

        private String localizationFilter(String string) {
            String string2 = string;
            String string3 = "Nonlocalized.lproj" + File.separator;
            int n = string.indexOf(string3);
            if (n >= 0) {
                string2 = string.substring(n + string3.length());
            } else {
                string3 = ".lproj" + File.separator;
                n = string.indexOf(string3);
                if (n >= 0) {
                    string2 = string.replaceFirst(".*?(\\w+\\..lproj)", "$1");
                }
            }
            return string2;
        }

        private String flatten(File file) {
            String string;
            String string2 = null;
            File file2 = null;
            for (File file3 = file.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
                file2 = file3;
                if (file3.getName().endsWith(".lproj")) break;
            }
            if (file2 != null && (string = file2.getName()).endsWith(".lproj")) {
                string2 = string + File.separator + file.getName();
            }
            if (string2 == null) {
                string2 = file.getName();
            }
            return string2;
        }

        private String[] pattern() {
            if (WOMapper.this.wotask != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator<String> iterator = WOMapper.this.wotask.getFlattenfileNames();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    this.addPattern(string, arrayList);
                }
                WOMapper.this.pattern = arrayList.toArray(new String[arrayList.size()]);
            }
            return WOMapper.this.pattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPattern(String string, ArrayList<String> arrayList) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(new File(string)));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.length() > 0) {
                        arrayList.add(string2);
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                WOMapper.this.log("Error while reading file: " + iOException.getMessage());
            }
            finally {
                if (null != bufferedReader) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private String applyFlattenfiles(String string) {
            if (this.pattern() == null) {
                return string;
            }
            File file = new File(string);
            for (int i = 0; i < WOMapper.this.pattern.length; ++i) {
                if (!SelectorUtils.matchPath((String)WOMapper.this.pattern[i], (String)string)) continue;
                return this.flatten(file);
            }
            return string;
        }

        private String flattenWithParent(File file) {
            String string = file.getName();
            String string2 = this.flatten(file.getParentFile());
            return string2 + File.separator + string;
        }
    }
}

