/*
 * Decompiled with CFR 0.152.
 */
package jode.jvm;

import java.util.Iterator;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.ClassInfo;
import jode.bytecode.FieldInfo;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.MethodInfo;
import jode.bytecode.Opcodes;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.type.MethodType;
import jode.type.Type;

public class SyntheticAnalyzer
implements Opcodes {
    public static final int UNKNOWN = 0;
    public static final int GETCLASS = 1;
    public static final int ACCESSGETFIELD = 2;
    public static final int ACCESSPUTFIELD = 3;
    public static final int ACCESSMETHOD = 4;
    public static final int ACCESSGETSTATIC = 5;
    public static final int ACCESSPUTSTATIC = 6;
    public static final int ACCESSSTATICMETHOD = 7;
    public static final int ACCESSCONSTRUCTOR = 8;
    public static final int ACCESSDUPPUTFIELD = 9;
    public static final int ACCESSDUPPUTSTATIC = 10;
    private static final int[] getClassOpcodes = new int[]{25, 184, 176, 58, 187, 89, 25, 182, 183, 191};
    private static final Reference[] getClassRefs = new Reference[]{null, Reference.getReference("Ljava/lang/Class;", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"), null, null, null, null, null, Reference.getReference("Ljava/lang/Throwable;", "getMessage", "()Ljava/lang/String;"), Reference.getReference("Ljava/lang/NoClassDefFoundError;", "<init>", "(Ljava/lang/String;)V"), null};
    int kind = 0;
    Reference reference;
    MethodInfo method;
    int unifyParam = -1;
    private final int modifierMask;

    public int getKind() {
        return this.kind;
    }

    public Reference getReference() {
        return this.reference;
    }

    public int getUnifyParam() {
        return this.unifyParam;
    }

    boolean checkGetClass() {
        if (!this.method.isStatic() || !this.method.getType().equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
            return false;
        }
        BytecodeInfo bytecodeInfo = this.method.getBytecode();
        Handler[] handlerArray = bytecodeInfo.getExceptionHandlers();
        if (handlerArray.length != 1 || !"java.lang.ClassNotFoundException".equals(handlerArray[0].type)) {
            return false;
        }
        int n = -1;
        int n2 = 0;
        Iterator iterator = bytecodeInfo.getInstructions().iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (n2 == getClassOpcodes.length || instruction.getOpcode() != getClassOpcodes[n2]) {
                return false;
            }
            if (n2 == 0 && (instruction.getLocalSlot() != 0 || handlerArray[0].start != instruction)) {
                return false;
            }
            if (n2 == 2 && handlerArray[0].end != instruction) {
                return false;
            }
            if (n2 == 3) {
                if (handlerArray[0].catcher != instruction) {
                    return false;
                }
                n = instruction.getLocalSlot();
            }
            if (n2 == 4 && !instruction.getClazzType().equals("Ljava/lang/NoClassDefFoundError;")) {
                return false;
            }
            if (n2 == 6 && instruction.getLocalSlot() != n) {
                return false;
            }
            if (getClassRefs[n2] != null && !getClassRefs[n2].equals(instruction.getReference())) {
                return false;
            }
            ++n2;
        }
        this.kind = 1;
        return true;
    }

    public boolean checkStaticAccess() {
        ClassInfo classInfo = this.method.getClazzInfo();
        BytecodeInfo bytecodeInfo = this.method.getBytecode();
        Iterator iterator = bytecodeInfo.getInstructions().iterator();
        boolean bl = false;
        Instruction instruction = (Instruction)iterator.next();
        if (instruction.getOpcode() == 178) {
            Reference reference = instruction.getReference();
            ClassInfo classInfo2 = TypeSignature.getClassInfo(reference.getClazz());
            if (!classInfo2.superClassOf(classInfo)) {
                return false;
            }
            FieldInfo fieldInfo = classInfo2.findField(reference.getName(), reference.getType());
            if ((fieldInfo.getModifiers() & 9) != 8) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() < 172 || instruction.getOpcode() > 176) {
                return false;
            }
            this.reference = reference;
            this.kind = 5;
            return true;
        }
        int n = 0;
        int n2 = 0;
        while (instruction.getOpcode() >= 21 && instruction.getOpcode() <= 25 && instruction.getLocalSlot() == n2) {
            ++n;
            n2 += instruction.getOpcode() == 22 || instruction.getOpcode() == 24 ? 2 : 1;
            instruction = (Instruction)iterator.next();
        }
        if (instruction.getOpcode() == 86 + 3 * n2) {
            instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() != 179) {
                return false;
            }
            bl = true;
        }
        if (instruction.getOpcode() == 179) {
            if (n != 1) {
                return false;
            }
            Reference reference = instruction.getReference();
            ClassInfo classInfo3 = TypeSignature.getClassInfo(reference.getClazz());
            if (!classInfo3.superClassOf(classInfo)) {
                return false;
            }
            FieldInfo fieldInfo = classInfo3.findField(reference.getName(), reference.getType());
            if ((fieldInfo.getModifiers() & 9) != 8) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (bl) {
                if (instruction.getOpcode() < 172 || instruction.getOpcode() > 176) {
                    return false;
                }
                this.kind = 10;
            } else {
                if (instruction.getOpcode() != 177) {
                    return false;
                }
                this.kind = 6;
            }
            this.reference = reference;
            return true;
        }
        if (instruction.getOpcode() == 184) {
            Reference reference = instruction.getReference();
            ClassInfo classInfo4 = TypeSignature.getClassInfo(reference.getClazz());
            if (!classInfo4.superClassOf(classInfo)) {
                return false;
            }
            MethodInfo methodInfo = classInfo4.findMethod(reference.getName(), reference.getType());
            MethodType methodType = Type.tMethod(reference.getType());
            if ((methodInfo.getModifiers() & 9) != 8 || methodType.getParameterTypes().length != n) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (methodType.getReturnType() == Type.tVoid ? instruction.getOpcode() != 177 : instruction.getOpcode() < 172 || instruction.getOpcode() > 176) {
                return false;
            }
            this.reference = reference;
            this.kind = 7;
            return true;
        }
        return false;
    }

    public boolean checkAccess() {
        ClassInfo classInfo = this.method.getClazzInfo();
        BytecodeInfo bytecodeInfo = this.method.getBytecode();
        Handler[] handlerArray = bytecodeInfo.getExceptionHandlers();
        boolean bl = false;
        if (handlerArray != null && handlerArray.length != 0) {
            return false;
        }
        if (this.method.isStatic() && this.checkStaticAccess()) {
            return true;
        }
        Iterator iterator = bytecodeInfo.getInstructions().iterator();
        Instruction instruction = (Instruction)iterator.next();
        if (instruction.getOpcode() != 25 || instruction.getLocalSlot() != 0) {
            return false;
        }
        instruction = (Instruction)iterator.next();
        if (instruction.getOpcode() == 180) {
            Reference reference = instruction.getReference();
            ClassInfo classInfo2 = TypeSignature.getClassInfo(reference.getClazz());
            if (!classInfo2.superClassOf(classInfo)) {
                return false;
            }
            FieldInfo fieldInfo = classInfo2.findField(reference.getName(), reference.getType());
            if ((fieldInfo.getModifiers() & 9) != 0) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() < 172 || instruction.getOpcode() > 176) {
                return false;
            }
            this.reference = reference;
            this.kind = 2;
            return true;
        }
        int n = 0;
        int n2 = 1;
        while (instruction.getOpcode() >= 21 && instruction.getOpcode() <= 25 && instruction.getLocalSlot() == n2) {
            ++n;
            n2 += instruction.getOpcode() == 22 || instruction.getOpcode() == 24 ? 2 : 1;
            instruction = (Instruction)iterator.next();
        }
        if (instruction.getOpcode() == 84 + 3 * n2) {
            instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() != 181) {
                return false;
            }
            bl = true;
        }
        if (instruction.getOpcode() == 181) {
            if (n != 1) {
                return false;
            }
            Reference reference = instruction.getReference();
            ClassInfo classInfo3 = TypeSignature.getClassInfo(reference.getClazz());
            if (!classInfo3.superClassOf(classInfo)) {
                return false;
            }
            FieldInfo fieldInfo = classInfo3.findField(reference.getName(), reference.getType());
            if ((fieldInfo.getModifiers() & 9) != 0) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (bl) {
                if (instruction.getOpcode() < 172 || instruction.getOpcode() > 176) {
                    return false;
                }
                this.kind = 9;
            } else {
                if (instruction.getOpcode() != 177) {
                    return false;
                }
                this.kind = 3;
            }
            this.reference = reference;
            return true;
        }
        if (instruction.getOpcode() == 183) {
            Reference reference = instruction.getReference();
            ClassInfo classInfo4 = TypeSignature.getClassInfo(reference.getClazz());
            if (!classInfo4.superClassOf(classInfo)) {
                return false;
            }
            MethodInfo methodInfo = classInfo4.findMethod(reference.getName(), reference.getType());
            MethodType methodType = Type.tMethod(reference.getType());
            if ((methodInfo.getModifiers() & 9) != 0 || methodType.getParameterTypes().length != n) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (methodType.getReturnType() == Type.tVoid ? instruction.getOpcode() != 177 : instruction.getOpcode() < 172 || instruction.getOpcode() > 176) {
                return false;
            }
            this.reference = reference;
            this.kind = 4;
            return true;
        }
        return false;
    }

    public boolean checkConstructorAccess() {
        ClassInfo classInfo = this.method.getClazzInfo();
        BytecodeInfo bytecodeInfo = this.method.getBytecode();
        String[] stringArray = TypeSignature.getParameterTypes(this.method.getType());
        Handler[] handlerArray = bytecodeInfo.getExceptionHandlers();
        if (handlerArray != null && handlerArray.length != 0) {
            return false;
        }
        Iterator iterator = bytecodeInfo.getInstructions().iterator();
        Instruction instruction = (Instruction)iterator.next();
        int n = 0;
        int n2 = 0;
        while (instruction.getOpcode() >= 21 && instruction.getOpcode() <= 25) {
            if (instruction.getLocalSlot() > n2 && this.unifyParam == -1 && n > 0 && stringArray[n - 1].charAt(0) == 'L') {
                this.unifyParam = n++;
                ++n2;
            }
            if (instruction.getLocalSlot() != n2) {
                return false;
            }
            ++n;
            n2 += instruction.getOpcode() == 22 || instruction.getOpcode() == 24 ? 2 : 1;
            instruction = (Instruction)iterator.next();
        }
        if (n > 0 && instruction.getOpcode() == 183) {
            Reference reference;
            ClassInfo classInfo2;
            if (this.unifyParam == -1 && n <= stringArray.length && stringArray[n - 1].charAt(0) == 'L') {
                this.unifyParam = n++;
            }
            if ((classInfo2 = TypeSignature.getClassInfo((reference = instruction.getReference()).getClazz())) != classInfo) {
                return false;
            }
            MethodInfo methodInfo = classInfo2.findMethod(reference.getName(), reference.getType());
            MethodType methodType = Type.tMethod(reference.getType());
            if ((methodInfo.getModifiers() & 9) != 0 || !methodInfo.getName().equals("<init>") || this.unifyParam == -1 || methodType.getParameterTypes().length != n - 2) {
                return false;
            }
            instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() != 177) {
                return false;
            }
            this.reference = reference;
            this.kind = 8;
            return true;
        }
        return false;
    }

    public SyntheticAnalyzer(MethodInfo methodInfo, boolean bl) {
        this.modifierMask = 9;
        this.method = methodInfo;
        if (methodInfo.getBytecode() == null) {
            return;
        }
        if ((!bl || methodInfo.getName().equals("class$")) && this.checkGetClass()) {
            return;
        }
        if ((!bl || methodInfo.getName().startsWith("access$")) && this.checkAccess()) {
            return;
        }
        if (methodInfo.getName().equals("<init>") && this.checkConstructorAccess()) {
            return;
        }
    }
}

