/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.ZipOutputStream;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.bytecode.Reference;
import jode.obfuscator.ClassBundle;
import jode.obfuscator.ClassIdentifier;
import jode.obfuscator.CodeAnalyzer;
import jode.obfuscator.CodeTransformer;
import jode.obfuscator.Identifier;
import jode.obfuscator.IdentifierMatcher;
import jode.obfuscator.Main;
import jode.obfuscator.OptionHandler;
import jode.obfuscator.PackageIdentifier;
import jode.obfuscator.Renamer;
import jode.obfuscator.TranslationTable;
import jode.obfuscator.modules.MultiIdentifierMatcher;
import jode.obfuscator.modules.SimpleAnalyzer;
import jode.obfuscator.modules.WildCard;

public class ClassBundle
implements OptionHandler {
    private static final Map aliasesHash = new WeakHashMap();
    private static final Map clazzCache = new HashMap();
    private static final Map referenceCache = new HashMap();
    PackageIdentifier basePackage;
    Set toAnalyze = new HashSet();
    String classPath = System.getProperty("java.class.path").replace(File.pathSeparatorChar, ',');
    String destDir = ".";
    String tableFile;
    String toTableFile;
    IdentifierMatcher loading;
    IdentifierMatcher preserving;
    IdentifierMatcher reaching;
    CodeTransformer[] preTrafos;
    CodeAnalyzer analyzer;
    CodeTransformer[] postTrafos;
    Renamer renamer;

    public static void setStripOptions(Collection collection) {
    }

    public void setOption(String string, Collection collection) {
        if (string.equals("classpath")) {
            Iterator iterator = collection.iterator();
            StringBuffer stringBuffer = new StringBuffer((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(',').append((String)iterator.next());
            }
            ClassInfo.setClassPath(stringBuffer.toString());
            return;
        }
        if (string.equals("dest")) {
            if (collection.size() != 1) {
                throw new IllegalArgumentException("Only one destination path allowed");
            }
            this.destDir = (String)collection.iterator().next();
            return;
        }
        if (string.equals("table")) {
            if (collection.size() != 1) {
                throw new IllegalArgumentException("Only one destination path allowed");
            }
            this.tableFile = (String)collection.iterator().next();
            return;
        }
        if (string.equals("revtable")) {
            if (collection.size() != 1) {
                throw new IllegalArgumentException("Only one destination path allowed");
            }
            this.toTableFile = (String)collection.iterator().next();
            return;
        }
        if (string.equals("strip")) {
            Iterator iterator = collection.iterator();
            block1: while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = 0;
                while (n < Main.stripNames.length) {
                    if (string2.equals(Main.stripNames[n])) {
                        Main.stripping |= 1 << n;
                        continue block1;
                    }
                    ++n;
                }
                throw new IllegalArgumentException("Unknown strip option: `" + string2 + "'");
            }
            return;
        }
        if (string.equals("load")) {
            if (collection.size() == 1) {
                Object e = collection.iterator().next();
                this.loading = e instanceof String ? new WildCard((String)e) : (IdentifierMatcher)e;
            } else {
                IdentifierMatcher[] identifierMatcherArray = new IdentifierMatcher[collection.size()];
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    IdentifierMatcher identifierMatcher = identifierMatcherArray[n++] = e instanceof String ? new WildCard((String)e) : (IdentifierMatcher)e;
                }
                this.loading = new MultiIdentifierMatcher(MultiIdentifierMatcher.OR, identifierMatcherArray);
            }
            return;
        }
        if (string.equals("preserve")) {
            if (collection.size() == 1) {
                Object e = collection.iterator().next();
                this.preserving = e instanceof String ? new WildCard((String)e) : (IdentifierMatcher)e;
            } else {
                IdentifierMatcher[] identifierMatcherArray = new IdentifierMatcher[collection.size()];
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    IdentifierMatcher identifierMatcher = identifierMatcherArray[n++] = e instanceof String ? new WildCard((String)e) : (IdentifierMatcher)e;
                }
                this.preserving = new MultiIdentifierMatcher(MultiIdentifierMatcher.OR, identifierMatcherArray);
            }
            return;
        }
        if (string.equals("reach")) {
            if (collection.size() == 1) {
                Object e = collection.iterator().next();
                this.reaching = e instanceof String ? new WildCard((String)e) : (IdentifierMatcher)e;
            } else {
                IdentifierMatcher[] identifierMatcherArray = new IdentifierMatcher[collection.size()];
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    IdentifierMatcher identifierMatcher = identifierMatcherArray[n++] = e instanceof String ? new WildCard((String)e) : (IdentifierMatcher)e;
                }
                this.reaching = new MultiIdentifierMatcher(MultiIdentifierMatcher.OR, identifierMatcherArray);
            }
        }
        if (string.equals("pre")) {
            this.preTrafos = collection.toArray(new CodeTransformer[collection.size()]);
            return;
        }
        if (string.equals("analyzer")) {
            if (collection.size() != 1) {
                throw new IllegalArgumentException("Only one analyzer is allowed");
            }
            this.analyzer = (CodeAnalyzer)collection.iterator().next();
            return;
        }
        if (string.equals("post")) {
            this.postTrafos = collection.toArray(new CodeTransformer[collection.size()]);
            return;
        }
        if (string.equals("renamer")) {
            if (collection.size() != 1) {
                throw new IllegalArgumentException("Only one renamer allowed");
            }
            this.renamer = (Renamer)collection.iterator().next();
            return;
        }
        throw new IllegalArgumentException("Invalid option `" + string + "'.");
    }

    public Reference getReferenceAlias(Reference reference) {
        Reference reference2 = (Reference)aliasesHash.get(reference);
        if (reference2 == null) {
            Identifier identifier = this.getIdentifier(reference);
            String string = this.getTypeAlias(reference.getType());
            reference2 = identifier == null ? Reference.getReference(reference.getClazz(), reference.getName(), string) : Reference.getReference("L" + identifier.getParent().getFullAlias().replace('.', '/') + ';', identifier.getAlias(), string);
            aliasesHash.put(reference, reference2);
        }
        return reference2;
    }

    public String getClassAlias(String string) {
        ClassIdentifier classIdentifier = this.getClassIdentifier(string);
        if (classIdentifier == null) {
            return string;
        }
        return classIdentifier.getFullAlias();
    }

    public String getTypeAlias(String string) {
        String string2 = (String)aliasesHash.get(string);
        if (string2 == null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((n = string.indexOf(76, n2)) != -1) {
                stringBuffer.append(string.substring(n2, n + 1));
                n2 = string.indexOf(59, n);
                String string3 = this.getClassAlias(string.substring(n + 1, n2).replace('/', '.'));
                stringBuffer.append(string3.replace('.', '/'));
            }
            string2 = stringBuffer.append(string.substring(n2)).toString().intern();
            aliasesHash.put(string, string2);
        }
        return string2;
    }

    public void addClassIdentifier(Identifier identifier) {
    }

    public ClassIdentifier getClassIdentifier(String string) {
        if (clazzCache.containsKey(string)) {
            return (ClassIdentifier)clazzCache.get(string);
        }
        ClassIdentifier classIdentifier = (ClassIdentifier)this.basePackage.getIdentifier(string);
        clazzCache.put(string, classIdentifier);
        return classIdentifier;
    }

    public Identifier getIdentifier(Reference reference) {
        if (referenceCache.containsKey(reference)) {
            return (Identifier)referenceCache.get(reference);
        }
        String string = reference.getClazz();
        if (string.charAt(0) == '[') {
            return null;
        }
        ClassIdentifier classIdentifier = this.getClassIdentifier(string.substring(1, string.length() - 1).replace('/', '.'));
        Identifier identifier = classIdentifier == null ? null : classIdentifier.getIdentifier(reference.getName(), reference.getType());
        referenceCache.put(reference, identifier);
        return identifier;
    }

    public void reachableClass(String string) {
        ClassIdentifier classIdentifier = this.getClassIdentifier(string);
        if (classIdentifier != null) {
            classIdentifier.setReachable();
        }
    }

    public void reachableReference(Reference reference, boolean bl) {
        String string = reference.getClazz();
        if (string.charAt(0) == '[') {
            return;
        }
        ClassIdentifier classIdentifier = this.getClassIdentifier(string.substring(1, string.length() - 1).replace('/', '.'));
        if (classIdentifier != null) {
            classIdentifier.reachableReference(reference, bl);
        }
    }

    public void analyzeIdentifier(Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        this.toAnalyze.add(identifier);
    }

    public void analyze() {
        while (!this.toAnalyze.isEmpty()) {
            Identifier identifier = (Identifier)this.toAnalyze.iterator().next();
            this.toAnalyze.remove(identifier);
            identifier.analyze();
        }
    }

    public IdentifierMatcher getPreserveRule() {
        return this.preserving;
    }

    public CodeAnalyzer getCodeAnalyzer() {
        return this.analyzer;
    }

    public CodeTransformer[] getPreTransformers() {
        return this.preTrafos;
    }

    public CodeTransformer[] getPostTransformers() {
        return this.postTrafos;
    }

    public void buildTable(Renamer renamer) {
        this.basePackage.buildTable(renamer);
    }

    public void readTable() {
        try {
            TranslationTable translationTable = new TranslationTable();
            FileInputStream fileInputStream = new FileInputStream(this.tableFile);
            translationTable.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            this.basePackage.readTable(translationTable);
        }
        catch (IOException iOException) {
            GlobalOptions.err.println("Can't read rename table " + this.tableFile);
            iOException.printStackTrace(GlobalOptions.err);
        }
    }

    public void writeTable() {
        TranslationTable translationTable = new TranslationTable();
        this.basePackage.writeTable(translationTable);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.toTableFile);
            translationTable.store(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            GlobalOptions.err.println("Can't write rename table " + this.toTableFile);
            iOException.printStackTrace(GlobalOptions.err);
        }
    }

    public void doTransformations() {
        this.basePackage.doTransformations();
    }

    public void storeClasses() {
        if (this.destDir.endsWith(".jar") || this.destDir.endsWith(".zip")) {
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.destDir));
                this.basePackage.storeClasses(zipOutputStream);
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                GlobalOptions.err.println("Can't write zip file: " + this.destDir);
                iOException.printStackTrace(GlobalOptions.err);
            }
        } else {
            File file = new File(this.destDir);
            if (!file.exists()) {
                GlobalOptions.err.println("Destination directory " + file.getPath() + " doesn't exists.");
                return;
            }
            this.basePackage.storeClasses(new File(this.destDir));
        }
    }

    public void run() {
        long l;
        if (this.analyzer == null) {
            this.analyzer = new SimpleAnalyzer();
        }
        if (this.preTrafos == null) {
            this.preTrafos = new CodeTransformer[0];
        }
        if (this.postTrafos == null) {
            this.postTrafos = new CodeTransformer[0];
        }
        if (this.renamer == null) {
            ClassBundle classBundle = this;
            if (classBundle == null) {
                throw null;
            }
            this.renamer = new Renamer(classBundle){
                private final /* synthetic */ ClassBundle this$0;

                public Iterator generateNames(Identifier identifier) {
                    String string = identifier.getName();
                    1 v0 = this;
                    if (v0 == null) {
                        throw null;
                    }
                    return new Iterator(v0, string){
                        int last;
                        private final /* synthetic */ 1 this$0;
                        private final /* synthetic */ String val$base;

                        public boolean hasNext() {
                            return true;
                        }

                        public Object next() {
                            return this.last++ == 0 ? this.val$base : this.val$base + this.last;
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                        {
                            this.val$base = string;
                            this.this$0 = var1_1;
                            this.last = 0;
                            this.constructor$0(var1_1);
                        }

                        private final void constructor$0(1 var1_1) {
                        }
                    };
                }
                {
                    this.this$0 = classBundle;
                    this.constructor$0(classBundle);
                }

                private final void constructor$0(ClassBundle classBundle) {
                }
            };
        }
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.freeMemory();
        do {
            l = l2;
            runtime.gc();
            runtime.runFinalization();
        } while ((l2 = runtime.freeMemory()) < l);
        System.err.println("used before: " + (runtime.totalMemory() - l2));
        GlobalOptions.err.println("Loading and preserving classes");
        long l3 = System.currentTimeMillis();
        this.basePackage.loadMatchingClasses(this.loading);
        this.basePackage.applyPreserveRule(this.preserving);
        System.err.println("Time used: " + (System.currentTimeMillis() - l3));
        GlobalOptions.err.println("Computing reachability");
        l3 = System.currentTimeMillis();
        this.analyze();
        System.err.println("Time used: " + (System.currentTimeMillis() - l3));
        l2 = runtime.freeMemory();
        do {
            l = l2;
            runtime.gc();
            runtime.runFinalization();
        } while ((l2 = runtime.freeMemory()) < l);
        System.err.println("used after analyze: " + (runtime.totalMemory() - l2));
        GlobalOptions.err.println("Renaming methods");
        l3 = System.currentTimeMillis();
        if (this.tableFile != null) {
            this.readTable();
        }
        this.buildTable(this.renamer);
        if (this.toTableFile != null) {
            this.writeTable();
        }
        System.err.println("Time used: " + (System.currentTimeMillis() - l3));
        GlobalOptions.err.println("Transforming the classes");
        l3 = System.currentTimeMillis();
        this.doTransformations();
        System.err.println("Time used: " + (System.currentTimeMillis() - l3));
        l2 = runtime.freeMemory();
        do {
            l = l2;
            runtime.gc();
            runtime.runFinalization();
        } while ((l2 = runtime.freeMemory()) < l);
        System.err.println("used after transform: " + (runtime.totalMemory() - l2));
        GlobalOptions.err.println("Writing new classes");
        l3 = System.currentTimeMillis();
        this.storeClasses();
        System.err.println("Time used: " + (System.currentTimeMillis() - l3));
    }

    public ClassBundle() {
        this.basePackage = new PackageIdentifier(this, null, "", "");
        this.basePackage.setReachable();
        this.basePackage.setPreserved();
    }
}

