/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator.modules;

import java.util.Collection;
import jode.obfuscator.Identifier;
import jode.obfuscator.IdentifierMatcher;
import jode.obfuscator.OptionHandler;

public class MultiIdentifierMatcher
implements IdentifierMatcher,
OptionHandler {
    public static boolean OR = true;
    public static boolean AND = false;
    IdentifierMatcher[] matchers;
    boolean isOr;

    public void setOption(String string, Collection collection) {
        if (string.equals("or")) {
            this.isOr = true;
            this.matchers = collection.toArray(new IdentifierMatcher[collection.size()]);
        } else if (string.equals("and")) {
            this.isOr = false;
            this.matchers = collection.toArray(new IdentifierMatcher[collection.size()]);
        } else {
            throw new IllegalArgumentException("Invalid option `" + string + "'.");
        }
    }

    public boolean matches(Identifier identifier) {
        int n = 0;
        while (n < this.matchers.length) {
            if (this.matchers[n].matches(identifier) == this.isOr) {
                return this.isOr;
            }
            ++n;
        }
        return !this.isOr;
    }

    public boolean matchesSub(Identifier identifier, String string) {
        int n = 0;
        while (n < this.matchers.length) {
            if (this.matchers[n].matchesSub(identifier, string) == this.isOr) {
                return this.isOr;
            }
            ++n;
        }
        return !this.isOr;
    }

    public String getNextComponent(Identifier identifier) {
        if (this.isOr == AND) {
            int n = 0;
            while (n < this.matchers.length) {
                String string = this.matchers[n].getNextComponent(identifier);
                if (string != null && this.matchesSub(identifier, string)) {
                    return string;
                }
                ++n;
            }
            return null;
        }
        String string = null;
        int n = 0;
        while (n < this.matchers.length) {
            if (this.matchesSub(identifier, null)) {
                if (string != null && this.matchers[n].getNextComponent(identifier) != string) {
                    return null;
                }
                string = this.matchers[n].getNextComponent(identifier);
                if (string == null) {
                    return null;
                }
            }
            ++n;
        }
        return string;
    }

    public MultiIdentifierMatcher() {
        this.matchers = new IdentifierMatcher[0];
    }

    public MultiIdentifierMatcher(boolean bl, IdentifierMatcher[] identifierMatcherArray) {
        this.isOr = bl;
        this.matchers = identifierMatcherArray;
    }
}

