/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSUtilities;
import java.util.Enumeration;

public class EODatabase
implements NSDisposable {
    protected NSMutableArray _registeredContexts;
    protected NSMutableDictionary _snapshots;
    protected NSMutableArray _models;
    protected NSMutableDictionary _entityCache;
    protected NSMutableDictionary _entityFetchAttributesCache;
    protected EOAdaptor _adaptor;
    protected long _timestamp;
    protected _DatabaseRecord _lastRec;
    protected EOGlobalID _lastGID;
    protected EOEntity _lastEntity;
    static final long DistantPastTimeInterval = NSTimestamp.DistantPast.getTime();
    static final long DistantFutureTimeInterval = NSTimestamp.DistantFuture.getTime();
    static final int DefaultSnapshotCacheSize = 1024;
    private static final NSSelector _globalIDChangedSelector = new NSSelector("_globalIDChanged", _NSUtilities._NotificationClassArray);
    protected static boolean _doesReleaseUnreferencedSnapshots = true;

    public EODatabase(EOAdaptor adaptor) {
        if (adaptor == null) {
            throw new IllegalArgumentException("EODatabase: invalid null value for adaptor\n");
        }
        this._registeredContexts = new NSMutableArray();
        this._models = new NSMutableArray();
        this._adaptor = adaptor;
        this._snapshots = new NSMutableDictionary(1024);
        this._timestamp = DistantPastTimeInterval;
    }

    public EODatabase(EOModel model) {
        this(EOAdaptor.adaptorWithModel(model));
        this.addModel(model);
    }

    public void dispose() {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
    }

    public EOAdaptor adaptor() {
        return this._adaptor;
    }

    protected void _clearLastRecords() {
        this._lastRec = null;
        this._lastGID = null;
    }

    protected _DatabaseRecord _fastHashGet(EOGlobalID gid) {
        if (this._lastGID == gid) {
            return this._lastRec;
        }
        this._lastRec = (_DatabaseRecord)this._snapshots.objectForKey((Object)gid);
        this._lastGID = gid;
        return this._lastRec;
    }

    protected void _fastHashInsert(_DatabaseRecord rec, EOGlobalID gid) {
        this._lastRec = rec;
        this._lastGID = gid;
        rec.recordedGID = gid;
        this._snapshots.setObjectForKey((Object)rec, (Object)gid);
    }

    protected void _fastHashRemove(EOGlobalID gid) {
        this._lastRec = null;
        this._snapshots.removeObjectForKey((Object)gid);
    }

    protected EOGlobalID _recordedGIDForSnapshotWithGid(EOGlobalID gid) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        return rec == null ? null : rec.recordedGID;
    }

    public void setTimestampToNow() {
        this._timestamp = System.currentTimeMillis();
    }

    public NSArray resultCacheForEntityNamed(String name) {
        if (this._entityCache == null) {
            return null;
        }
        return (NSArray)this._entityCache.objectForKey((Object)name);
    }

    protected NSSet _cachedFetchAttributesForEntityNamed(String name) {
        return (NSSet)this._entityFetchAttributesCache.objectForKey((Object)name);
    }

    protected void _setTimestampForCachedGlobalID(EOGlobalID gid) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null) {
            return;
        }
        rec.timestamp = DistantFutureTimeInterval;
    }

    public void setResultCache(NSArray cache, String name) {
        if (this._entityCache == null) {
            this._entityCache = new NSMutableDictionary();
        }
        if (this._entityFetchAttributesCache == null) {
            this._entityFetchAttributesCache = new NSMutableDictionary();
        }
        if (this._entityFetchAttributesCache.objectForKey((Object)name) == null) {
            NSMutableArray fetchAtts = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)this.entityNamed(name).attributesToFetch(), (NSSelector)_NSArrayUtilities._nameSelector);
            NSSet faSet = new NSSet((NSArray)fetchAtts);
            this._entityFetchAttributesCache.setObjectForKey((Object)faSet, (Object)name);
        }
        for (int i = cache.count() - 1; i >= 0; --i) {
            EOGlobalID gid = (EOGlobalID)cache.objectAtIndex(i);
            this.incrementSnapshotCountForGlobalID(gid);
            this._setTimestampForCachedGlobalID(gid);
        }
        this._entityCache.setObjectForKey((Object)cache, (Object)name);
    }

    public void invalidateResultCacheForEntityNamed(String name) {
        NSArray cache;
        if (this._entityCache == null || (cache = (NSArray)this._entityCache.objectForKey((Object)name)) == null) {
            return;
        }
        for (int i = cache.count() - 1; i >= 0; --i) {
            this.decrementSnapshotCountForGlobalID((EOGlobalID)cache.objectAtIndex(i));
        }
        this._entityCache.removeObjectForKey((Object)name);
    }

    public void invalidateResultCache() {
        if (this._entityCache != null) {
            Enumeration objEnum = this._entityCache.objectEnumerator();
            while (objEnum.hasMoreElements()) {
                NSArray cache = (NSArray)objEnum.nextElement();
                for (int i = cache.count() - 1; i >= 0; --i) {
                    this.decrementSnapshotCountForGlobalID((EOGlobalID)cache.objectAtIndex(i));
                }
            }
            this._entityCache = null;
        }
    }

    public int _indexOfRegisteredContext(EODatabaseContext context) {
        for (int i = this._registeredContexts.count() - 1; i >= 0; --i) {
            EODatabaseContext aContext = (EODatabaseContext)((Object)this._registeredContexts.objectAtIndex(i));
            if (aContext != context) continue;
            return i;
        }
        return -1;
    }

    public NSArray registeredContexts() {
        NSMutableArray array = null;
        int count = this._registeredContexts.count();
        if (count != 0) {
            array = new NSMutableArray(count);
            for (int i = 0; i < count; ++i) {
                array.addObject(this._registeredContexts.objectAtIndex(i));
            }
        }
        return array;
    }

    public void registerContext(EODatabaseContext context) {
        if (context.database() != this) {
            throw new IllegalStateException("registerContext: " + this.getClass().getName() + " " + this + " -- illegal attempt to register " + ((Object)((Object)context)).getClass().getName() + " " + (Object)((Object)context) + " with different database value");
        }
        if (this._indexOfRegisteredContext(context) != -1) {
            throw new IllegalStateException("registerContext: " + this.getClass().getName() + " " + this + " -- illegal attempt to register " + ((Object)((Object)context)).getClass().getName() + " " + (Object)((Object)context) + " twice");
        }
        this._registeredContexts.addObject((Object)context);
        int count = this._registeredContexts.count();
        if (count == 1) {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, _globalIDChangedSelector, "EOGlobalIDChangedNotification", (Object)context);
        } else if (count == 2) {
            NSNotificationCenter.defaultCenter().removeObserver((Object)this, "EOGlobalIDChangedNotification", null);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, _globalIDChangedSelector, "EOGlobalIDChangedNotification", (Object)context.coordinator());
        }
    }

    public void unregisterContext(EODatabaseContext context) {
        int i = this._indexOfRegisteredContext(context);
        if (i == -1) {
            throw new IllegalStateException("unregisterContext: " + this.getClass().getName() + " " + this + " -- illegal attempt to unregister unknown " + ((Object)((Object)context)).getClass().getName() + " " + (Object)((Object)context));
        }
        this._registeredContexts.removeObjectAtIndex(i);
    }

    public void addModel(EOModel model) {
        this._models.addObject((Object)model);
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)32768L)) {
            NSLog.debug.appendln((Object)(this + " added model at path \"" + model.pathURL() + "\"."));
        }
    }

    public boolean addModelIfCompatible(EOModel model) {
        if (this._models.indexOfIdenticalObject((Object)model) != -1) {
            return true;
        }
        if (!this.adaptor().name().equals(model.adaptorName())) {
            return false;
        }
        if (!this.adaptor().canServiceModel(model)) {
            return false;
        }
        this.addModel(model);
        return true;
    }

    public void removeModel(EOModel model) {
        int index = this._models.indexOfIdenticalObject((Object)model);
        if (index == -1) {
            throw new IllegalArgumentException("removeModel: attempt to remove unregistered model from EODatabase: " + model.name());
        }
        this._models.removeObjectAtIndex(index);
    }

    public NSArray models() {
        return this._models;
    }

    public EOEntity entityNamed(String entityName) {
        EOEntity lastEntity = this._lastEntity;
        if (lastEntity != null && entityName == lastEntity.name()) {
            return lastEntity;
        }
        int i = this._models.count();
        while (i-- != 0) {
            EOEntity entity = ((EOModel)this._models.objectAtIndex(i)).entityNamed(entityName);
            if (entity == null) continue;
            this._lastEntity = entity;
            return entity;
        }
        return null;
    }

    public EOEntity entityForObject(EOEnterpriseObject object) {
        return this.entityNamed(object.entityName());
    }

    public void handleDroppedConnection() {
        int max = this._registeredContexts.count();
        this._adaptor.handleDroppedConnection();
        for (int i = 0; i < max; ++i) {
            ((EODatabaseContext)((Object)this._registeredContexts.objectAtIndex(i))).handleDroppedConnection();
        }
    }

    public void recordSnapshotForGlobalID(NSDictionary snapshot, EOGlobalID gid) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null) {
            rec = new _DatabaseRecord();
            rec.toManyMap = null;
            rec.retainCount = 0;
            rec.snapshot = null;
            this._fastHashInsert(rec, gid);
        }
        rec.snapshot = snapshot;
        rec.timestamp = this._timestamp;
    }

    public void recordSnapshots(NSDictionary snapshots) {
        NSArray keys = snapshots.allKeys();
        int c = keys.count();
        for (int i = 0; i < c; ++i) {
            EOGlobalID key = (EOGlobalID)keys.objectAtIndex(i);
            this.recordSnapshotForGlobalID((NSDictionary)snapshots.objectForKey((Object)key), key);
        }
    }

    public void recordToManySnapshots(NSDictionary snapshots) {
        NSArray gids = snapshots != null ? snapshots.allKeys() : null;
        int c = gids != null ? gids.count() : 0;
        for (int i = 0; i < c; ++i) {
            EOGlobalID gid = (EOGlobalID)gids.objectAtIndex(i);
            NSDictionary toManySnaps = (NSDictionary)snapshots.objectForKey((Object)gid);
            NSArray relNames = toManySnaps.allKeys();
            int jcnt = relNames.count();
            for (int j = 0; j < jcnt; ++j) {
                Object relName = relNames.objectAtIndex(j);
                Object arraySnap = toManySnaps.objectForKey(relName);
                if (arraySnap == NSKeyValueCoding.NullValue) {
                    arraySnap = null;
                }
                this.recordSnapshotForSourceGlobalID((NSArray)arraySnap, gid, (String)relName);
            }
        }
    }

    public void recordSnapshotForSourceGlobalID(NSArray gids, EOGlobalID gid, String name) {
        _ToManyRecord tmr;
        NSMutableDictionary map;
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null) {
            this.recordSnapshotForGlobalID(null, gid);
            rec = this._fastHashGet(gid);
        }
        if ((map = rec.toManyMap) == null) {
            rec.toManyMap = map = new NSMutableDictionary();
        }
        if ((tmr = (_ToManyRecord)map.objectForKey((Object)name)) == null) {
            tmr = new _ToManyRecord();
            map.setObjectForKey((Object)tmr, (Object)name);
            tmr.gids = null;
        }
        tmr.timestamp = this._timestamp;
        tmr.gids = gids;
    }

    public NSArray snapshotForSourceGlobalID(EOGlobalID gid, String name) {
        return this.snapshotForSourceGlobalID(gid, name, DistantPastTimeInterval);
    }

    public NSArray snapshotForSourceGlobalID(EOGlobalID gid, String name, long timestamp) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null || rec.toManyMap == null) {
            return null;
        }
        _ToManyRecord tmr = (_ToManyRecord)rec.toManyMap.objectForKey((Object)name);
        return tmr != null && tmr.gids != NSKeyValueCoding.NullValue && tmr.timestamp >= timestamp ? (NSArray)tmr.gids : null;
    }

    public long timestampForSourceGlobalID(EOGlobalID gid, String name) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null || rec.toManyMap == null) {
            return DistantPastTimeInterval;
        }
        _ToManyRecord tmr = (_ToManyRecord)rec.toManyMap.objectForKey((Object)name);
        return tmr != null ? tmr.timestamp : DistantPastTimeInterval;
    }

    public void _forgetSnapshotForGlobalID(EOGlobalID gid) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec != null) {
            this._freeToManyMap(rec);
            rec.snapshot = null;
            if (rec.retainCount == 0) {
                this._fastHashRemove(gid);
            }
        }
    }

    public void forgetSnapshotForGlobalID(EOGlobalID gid) {
        this._forgetSnapshotForGlobalID(gid);
        NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)this, new NSDictionary((Object)new NSArray((Object)gid), (Object)"invalidated"));
    }

    public void forgetSnapshotsForGlobalIDs(NSArray array) {
        if (array == null || array.count() == 0) {
            return;
        }
        for (int i = array.count() - 1; i >= 0; --i) {
            EOGlobalID gid = (EOGlobalID)array.objectAtIndex(i);
            _DatabaseRecord rec = this._fastHashGet(gid);
            if (rec == null) continue;
            this._freeToManyMap(rec);
            rec.snapshot = null;
            if (rec.retainCount != 0) continue;
            this._fastHashRemove(gid);
        }
        NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)this, new NSDictionary((Object)array, (Object)"invalidated"));
    }

    public void forgetAllSnapshots() {
        this.forgetSnapshotsForGlobalIDs(this._snapshots.allKeys());
    }

    public long timestampForGlobalID(EOGlobalID gid) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        return rec != null ? rec.timestamp : DistantPastTimeInterval;
    }

    public NSDictionary snapshotForGlobalID(EOGlobalID gid) {
        return this.snapshotForGlobalID(gid, DistantPastTimeInterval);
    }

    public NSDictionary snapshotForGlobalID(EOGlobalID gid, long timestamp) {
        _DatabaseRecord rec = this._fastHashGet(gid);
        return rec != null && rec.timestamp >= timestamp ? rec.snapshot : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _globalIDChanged(NSNotification notification) {
        NSDictionary userInfo = notification.userInfo();
        Enumeration enumerator = userInfo.keyEnumerator();
        Object poster = notification.object();
        boolean didLock = false;
        EODatabaseContext dbc = (EODatabaseContext)((Object)this._registeredContexts.lastObject());
        if (dbc != null) {
            didLock = true;
            dbc.lock();
        }
        try {
            while (enumerator.hasMoreElements()) {
                EOGlobalID gid = (EOGlobalID)enumerator.nextElement();
                _DatabaseRecord rec = this._fastHashGet(gid);
                if (rec == null) continue;
                this._fastHashRemove(gid);
                this._fastHashInsert(rec, (EOGlobalID)userInfo.objectForKey((Object)gid));
            }
        }
        finally {
            if (didLock) {
                dbc.unlock();
            }
        }
    }

    public NSDictionary snapshots() {
        return this._snapshots.immutableClone();
    }

    public int _snapshotCountForGlobalID(EOGlobalID gid) {
        if (!_doesReleaseUnreferencedSnapshots) {
            return 0;
        }
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null || rec.snapshot == null) {
            throw new IllegalStateException("snapshotCountForGlobalID: " + this.getClass().getName() + " " + this + " -- object with global ID " + gid + " - no snapshot exists");
        }
        return rec.retainCount;
    }

    public void incrementSnapshotCountForGlobalID(EOGlobalID gid) {
        if (!_doesReleaseUnreferencedSnapshots) {
            return;
        }
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null || rec.snapshot == null) {
            throw new IllegalStateException("incrementSnapshotCountForGlobalID: " + this.getClass().getName() + " " + this + " -- is unable to increment snapshot count for object with global ID " + gid + " - no snapshot exists");
        }
        ++rec.retainCount;
    }

    public void decrementSnapshotCountForGlobalID(EOGlobalID gid) {
        if (!_doesReleaseUnreferencedSnapshots) {
            return;
        }
        _DatabaseRecord rec = this._fastHashGet(gid);
        if (rec == null || rec.retainCount == 0) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65538L)) {
                NSLog.debug.appendln((Object)("decrementSnapshotCountForGlobalID: " + this.getClass().getName() + " " + this + " -- is unable to decrement snapshot count for object with global ID " + gid + " - count is already 0 or this snapshot doesn't exist"));
                if (NSLog.allowedDebugLevel() > 2) {
                    NSLog.debug.appendln((Throwable)new RuntimeException("Unable to decrement snapshot count for object with global ID " + gid + " - count is already 0 or this snapshot doesn't exist"));
                }
            }
            return;
        }
        --rec.retainCount;
        if (rec.retainCount == 0) {
            if (rec.snapshot != null) {
                this._forgetSnapshotForGlobalID(gid);
            } else {
                this._freeToManyMap(rec);
                this._fastHashRemove(gid);
            }
        }
    }

    public static void disableSnapshotRefCounting() {
        _doesReleaseUnreferencedSnapshots = false;
    }

    protected void _freeToManyMap(_DatabaseRecord rec) {
        NSMutableDictionary map = rec.toManyMap;
        if (map != null) {
            rec.toManyMap = null;
        }
    }

    private static class _ToManyRecord {
        long timestamp = 0L;
        Object gids = null;

        _ToManyRecord() {
        }
    }

    protected static class _DatabaseRecord {
        NSDictionary snapshot = null;
        NSMutableDictionary toManyMap = null;
        long timestamp;
        int retainCount = 0;
        EOGlobalID recordedGID = null;

        _DatabaseRecord() {
        }

        public String toString() {
            return "_DatabaseRecord @" + System.identityHashCode(this) + this.recordedGID;
        }
    }
}

