/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSStringUtilities;
import java.math.BigDecimal;

public final class _EOStringUtil {
    private static final int _DefaultNameLength = 128;

    public static String externalNameForInternalNameSeparatorStringUseAllCaps(String internalName, String separatorString, boolean allCaps) {
        String result = _NSStringUtilities.stringMarkingUpcaseTransitionsWithDelimiter((String)internalName, (String)separatorString);
        return allCaps ? result.toUpperCase() : result.toLowerCase();
    }

    public static String nameForExternalNameSeparatorStringInitialCaps(String externalName, String separatorString, boolean initialCaps) {
        StringBuffer result = new StringBuffer(128);
        if (!externalName.equals(externalName.toLowerCase()) && !externalName.equals(externalName.toUpperCase()) && externalName.indexOf(separatorString) == -1) {
            if (!initialCaps && Character.isUpperCase(externalName.charAt(0))) {
                return externalName.substring(0, 1).concat(externalName.substring(1));
            }
            return externalName;
        }
        NSArray components = NSArray.componentsSeparatedByString((String)externalName, (String)separatorString);
        int count = components.count();
        boolean firstComponent = true;
        for (int i = 0; i < count; ++i) {
            String component = (String)components.objectAtIndex(i);
            if (component.length() <= 0) continue;
            if (!initialCaps && firstComponent) {
                component = component.toLowerCase();
                firstComponent = false;
            } else {
                component = _NSStringUtilities.capitalizedStringAsWord((String)component);
            }
            result = result.append(component);
        }
        return new String(result);
    }

    public static String relationshipPathByDeletingLastComponent(String rel) {
        int index = rel.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return rel.substring(0, index);
    }

    public static String lastComponentFromRelationshipPath(String rel) {
        int index = rel.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return rel.substring(index + 1);
    }

    public static String relationshipPathByDeletingFirstComponent(String rel) {
        int index = rel.indexOf(46);
        if (index < 0) {
            return null;
        }
        return rel.substring(index + 1);
    }

    public static boolean relationshipPathIsMultiHop(String rel) {
        int index = rel.indexOf(46);
        return index >= 0;
    }

    static Number numberWithStringType(String string, char c) {
        switch (c) {
            case 'c': {
                return Integer.valueOf(string);
            }
            case 's': {
                return Short.valueOf(string);
            }
            case 'i': {
                return Integer.valueOf(string);
            }
            case 'l': {
                return Long.valueOf(string);
            }
            case 'f': {
                return Float.valueOf(string);
            }
            case 'd': {
                return Double.valueOf(string);
            }
            case 'B': {
                return new BigDecimal(string);
            }
        }
        throw new IllegalArgumentException("numberWithStringType: value type " + c + " of " + string + " is invalid.");
    }

    public static String firstComponentFromRelationshipPath(String path) {
        int index = path.indexOf(46);
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    static void debugCriticalPrintln(String str) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)65536L)) {
            NSLog.debug.appendln((Object)str);
        }
    }

    static void debugInfoPrintln(String str) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
            NSLog.debug.appendln((Object)str);
        }
    }
}

