/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSJavaArrayListIterator;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSArray<E>
implements Cloneable,
Serializable,
NSCoding,
NSKeyValueCoding,
NSKeyValueCodingAdditions,
_NSFoundationCollection,
List<E> {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime((String)"com.webobjects.foundation.NSArray");
    public static final int NotFound = -1;
    public static final NSArray EmptyArray = new NSArray();
    private static final char _OperatorIndicatorChar = '@';
    public static final String CountOperatorName = "count";
    public static final String MaximumOperatorName = "max";
    public static final String MinimumOperatorName = "min";
    public static final String SumOperatorName = "sum";
    public static final String AverageOperatorName = "avg";
    static final long serialVersionUID = -3789592578296478260L;
    private static final String SerializationValuesFieldKey = "objects";
    private static NSMutableDictionary<String, Operator> _operators = new NSMutableDictionary(8);
    protected static final int _NSArrayClassHashCode = _CLASS.hashCode();
    protected Object[] _objects;
    protected transient int _hashCache;
    private transient boolean _recomputeHashCode = true;
    public static final boolean CheckForNull = true;
    public static final boolean IgnoreNull = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", new Object[0].getClass())};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray<String> operatorNames() {
        NSArray<String> operatorNames;
        NSMutableDictionary<String, Operator> nSMutableDictionary = _operators;
        synchronized (nSMutableDictionary) {
            operatorNames = _operators.allKeys();
        }
        return operatorNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOperatorForKey(String operatorName, Operator arrayOperator) {
        if (operatorName == null) {
            throw new IllegalArgumentException("Operator key cannot be null");
        }
        if (arrayOperator == null) {
            throw new IllegalArgumentException("Operator cannot be null for " + operatorName);
        }
        NSMutableDictionary<String, Operator> nSMutableDictionary = _operators;
        synchronized (nSMutableDictionary) {
            _operators.setObjectForKey(arrayOperator, operatorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Operator operatorForKey(String operatorName) {
        Operator arrayOperator;
        NSMutableDictionary<String, Operator> nSMutableDictionary = _operators;
        synchronized (nSMutableDictionary) {
            arrayOperator = (Operator)_operators.objectForKey(operatorName);
        }
        return arrayOperator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOperatorForKey(String operatorName) {
        if (operatorName != null) {
            NSMutableDictionary<String, Operator> nSMutableDictionary = _operators;
            synchronized (nSMutableDictionary) {
                _operators.removeObjectForKey(operatorName);
            }
        }
    }

    protected void _initializeWithCapacity(int capacity) {
        this._setObjects(capacity <= 0 ? null : new Object[capacity]);
        this._setCount(0);
        this._setMustRecomputeHash(true);
    }

    public NSArray() {
        this(null, 0, 0, false, false);
    }

    public NSArray(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an NSArray");
        }
        this._initializeWithCapacity(1);
        this._objects()[0] = object;
        this._setCount(1);
    }

    private void initFromObjects(Object[] objects, int rangeLocation, int rangeLength, boolean checkForNull, boolean ignoreNull) {
        this.initFromObjects(objects, rangeLocation, rangeLength, 0, checkForNull, ignoreNull);
    }

    private void initFromObjects(Object[] objects, int rangeLocation, int rangeLength, int offset, boolean checkForNull, boolean ignoreNull) {
        if (checkForNull) {
            int maxRange = rangeLocation + rangeLength;
            int validCount = 0;
            Object[] validObjects = new Object[maxRange];
            for (int i = rangeLocation; i < maxRange; ++i) {
                Object o = objects[i];
                if (o != null) {
                    validObjects[validCount++] = o;
                    continue;
                }
                if (ignoreNull) continue;
                throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
            }
            this._initializeWithCapacity(validCount + offset);
            if (validCount > 0) {
                System.arraycopy(validObjects, 0, this._objects(), offset, validCount);
            }
            this._setCount(validCount + offset);
        } else {
            this._initializeWithCapacity(rangeLength + offset);
            if (rangeLength > 0) {
                System.arraycopy(objects, rangeLocation, this._objects(), offset, rangeLength);
            }
            this._setCount(rangeLength + offset);
        }
    }

    private void initFromList(List<? extends E> list, int rangeLocation, int rangeLength, int offset, boolean checkForNull, boolean ignoreNull) {
        int maxRange = rangeLocation + rangeLength;
        if (checkForNull) {
            int validCount = 0;
            Object[] validObjects = new Object[maxRange];
            for (int i = rangeLocation; i < maxRange; ++i) {
                E o = list.get(i);
                if (o != null) {
                    validObjects[validCount++] = o;
                    continue;
                }
                if (ignoreNull) continue;
                throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
            }
            this._initializeWithCapacity(validCount + offset);
            if (validCount > 0) {
                System.arraycopy(validObjects, 0, this._objects(), offset, validCount);
            }
            this._setCount(validCount + offset);
        } else {
            this._initializeWithCapacity(rangeLength + offset);
            System.arraycopy(list.toArray(), rangeLocation, this._objects(), offset, rangeLength);
            this._setCount(rangeLength + offset);
        }
    }

    protected NSArray(Object[] objects, int rangeLocation, int rangeLength, boolean checkForNull, boolean ignoreNull) {
        this.initFromObjects(objects, rangeLocation, rangeLength, checkForNull, ignoreNull);
    }

    public NSArray(E[] objects) {
        this(objects, 0, objects == null ? 0 : objects.length, true, true);
    }

    public NSArray(E object, E ... objects) {
        if (object == null) {
            this.initFromObjects(objects, 0, objects == null ? 0 : objects.length, 0, true, true);
        } else {
            this.initFromObjects(objects, 0, objects == null ? 0 : objects.length, 1, true, true);
            this._objects()[0] = object;
        }
    }

    public NSArray(E[] objects, NSRange range) {
        this(objects, range == null ? 0 : range.location(), range == null ? 0 : range.length(), true, true);
    }

    public NSArray(NSArray<? extends E> otherArray) {
        this(otherArray == null ? null : otherArray.objectsNoCopy(), 0, otherArray == null ? 0 : otherArray.count(), false, false);
    }

    public NSArray(List<? extends E> list, boolean checkForNull) {
        if (list == null) {
            throw new NullPointerException("List cannot be null");
        }
        this.initFromList(list, 0, list.size(), 0, checkForNull, false);
    }

    public NSArray(Collection<? extends E> collection, boolean checkForNull) {
        if (collection == null) {
            throw new NullPointerException("Collection cannot be null");
        }
        Object[] anArray = collection.toArray();
        this.initFromObjects(anArray, 0, anArray.length, checkForNull, false);
    }

    public NSArray(Collection<? extends E> collection) {
        this(collection, true);
    }

    public NSArray(List<? extends E> list, NSRange range, boolean ignoreNull) {
        if (list == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        this.initFromList(list, range != null ? range.location() : 0, range != null ? range.length() : 0, 0, true, ignoreNull);
    }

    public NSArray(Vector<? extends E> vector, NSRange range, boolean ignoreNull) {
        this((List<? extends E>)vector, range, ignoreNull);
    }

    protected void _setCount(int count) {
    }

    protected Object[] _objects() {
        return this._objects;
    }

    protected void _setObjects(Object[] objects) {
        this._objects = objects;
    }

    protected Object[] objectsNoCopy() {
        Object[] objs = this._objects();
        return objs != null ? objs : _NSCollectionPrimitives.EmptyArray;
    }

    public int count() {
        return this._objects != null ? this._objects.length : 0;
    }

    public E objectAtIndex(int index) {
        int count = this.count();
        if (index >= 0 && index < count) {
            return (E)this._objects()[index];
        }
        if (count == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this.count() - 1) + "]");
    }

    public NSArray<E> arrayByAddingObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int count = this.count();
        Object[] objects = new Object[count + 1];
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        objects[count] = object;
        return new NSArray<E>(objects, 0, count + 1, false, false);
    }

    public NSArray<E> arrayByAddingObjectsFromArray(NSArray<? extends E> otherArray) {
        if (otherArray != null) {
            int count = this.count();
            int otherCount = otherArray.count();
            if (count == 0) {
                return otherArray.immutableClone();
            }
            if (otherCount == 0) {
                return this.immutableClone();
            }
            Object[] objects = new Object[count + otherCount];
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
            System.arraycopy(otherArray.objectsNoCopy(), 0, objects, count, otherCount);
            return new NSArray<E>(objects, 0, count + otherCount, false, false);
        }
        return this.immutableClone();
    }

    public Object[] objects() {
        int count = this.count();
        Object[] objects = new Object[count];
        if (count > 0) {
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        }
        return objects;
    }

    public Object[] objects(NSRange range) {
        if (range == null) {
            return _NSCollectionPrimitives.EmptyArray;
        }
        int rangeLength = range.length();
        Object[] objects = new Object[rangeLength];
        System.arraycopy(this.objectsNoCopy(), range.location(), objects, 0, rangeLength);
        return objects;
    }

    public Vector<E> vector() {
        Vector<Object> vector = new Vector<Object>();
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            vector.addElement(objects[i]);
        }
        return vector;
    }

    public ArrayList<E> arrayList() {
        Object[] objects = this.objectsNoCopy();
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    public boolean containsObject(Object object) {
        if (object == null) {
            return false;
        }
        return this._findObjectInArray(0, this.count(), object, false) != -1;
    }

    public E firstObjectCommonWithArray(NSArray<? extends E> otherArray) {
        if (otherArray == null) {
            return null;
        }
        int otherCount = otherArray.count();
        if (otherCount > 0) {
            Object[] objects = this.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                if (!otherArray.containsObject(objects[i])) continue;
                return (E)objects[i];
            }
        }
        return null;
    }

    @Deprecated
    public void getObjects(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, this.count());
    }

    @Deprecated
    public void getObjects(Object[] objects, NSRange range) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        System.arraycopy(this.objectsNoCopy(), range.location(), objects, 0, range.length());
    }

    private final int _findObjectInArray(int index, int length, Object object, boolean identical) {
        if (this.count() > 0) {
            Object[] objects = this.objectsNoCopy();
            int maxIndex = index + length - 1;
            for (int i = index; i <= maxIndex; ++i) {
                if (objects[i] == object) {
                    return i;
                }
                if (identical || !object.equals(objects[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfObject(Object object) {
        if (object == null) {
            return -1;
        }
        return this._findObjectInArray(0, this.count(), object, false);
    }

    public int indexOfObject(Object object, NSRange range) {
        int rangeLength;
        if (object == null || range == null) {
            return -1;
        }
        int count = this.count();
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this.count() - 1) + "]");
        }
        return this._findObjectInArray(rangeLocation, rangeLength, object, false);
    }

    public int indexOfIdenticalObject(Object object) {
        if (object == null) {
            return -1;
        }
        return this._findObjectInArray(0, this.count(), object, true);
    }

    public int indexOfIdenticalObject(Object object, NSRange range) {
        int rangeLength;
        if (object == null || range == null) {
            return -1;
        }
        int count = this.count();
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this.count() - 1) + "]");
        }
        return this._findObjectInArray(rangeLocation, rangeLength, object, true);
    }

    public NSArray<E> subarrayWithRange(NSRange range) {
        if (range == null) {
            return EmptyArray;
        }
        return new NSArray<E>(this.objectsNoCopy(), range.location(), range.length(), false, false);
    }

    public E lastObject() {
        int count = this.count();
        return count != 0 ? (E)this.objectAtIndex(count - 1) : null;
    }

    private boolean _equalsArray(NSArray<?> otherArray) {
        int count = this.count();
        if (count != otherArray.count()) {
            return false;
        }
        if (!this._mustRecomputeHash() && !otherArray._mustRecomputeHash() && this.hashCode() != otherArray.hashCode()) {
            return false;
        }
        Object[] objects = this.objectsNoCopy();
        Object[] otherObjects = otherArray.objectsNoCopy();
        for (int i = 0; i < count; ++i) {
            if (objects[i].equals(otherObjects[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToArray(NSArray<?> otherArray) {
        if (otherArray == this) {
            return true;
        }
        if (otherArray == null) {
            return false;
        }
        return this._equalsArray(otherArray);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSArray) {
            return this._equalsArray((NSArray)object);
        }
        return false;
    }

    public Enumeration<E> objectEnumerator() {
        return new _NSJavaArrayEnumerator(this.objectsNoCopy(), this.count(), false);
    }

    public Enumeration<E> reverseObjectEnumerator() {
        return new _NSJavaArrayEnumerator(this.objectsNoCopy(), this.count(), true);
    }

    @Deprecated
    public NSArray sortedArrayUsingSelector(NSSelector selector) throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray(this);
        NSComparator._NSSelectorComparator comparator = new NSComparator._NSSelectorComparator(selector);
        array.sortUsingComparator((NSComparator)comparator);
        return array;
    }

    public NSArray<E> sortedArrayUsingComparator(NSComparator comparator) throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray(this);
        array.sortUsingComparator(comparator);
        return array;
    }

    public String componentsJoinedByString(String separator) {
        Object[] objects = this.objectsNoCopy();
        StringBuffer buffer = new StringBuffer(objects.length * 32);
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0 && separator != null) {
                buffer.append(separator);
            }
            buffer.append(objects[i].toString());
        }
        return new String(buffer);
    }

    public static NSArray<String> componentsSeparatedByString(String string, String separator) {
        NSMutableArray<int> objects;
        if (string == null || string.length() == 0) {
            return NSArray.emptyArray();
        }
        int stringLength = string.length();
        if (separator == null || separator.length() == 0) {
            return new NSArray<String>(string);
        }
        int separatorLength = separator.length();
        int start = 0;
        int index = 0;
        int count = 0;
        if (separatorLength == 1 && stringLength < 256) {
            char[] parseData = string.toCharArray();
            char charSeparator = separator.charAt(0);
            for (int i = 0; i < stringLength; ++i) {
                if (parseData[i] != charSeparator) continue;
                ++count;
            }
            if (count == 0) {
                return new NSArray<String>(string);
            }
            objects = new NSMutableArray<int>(count + 1);
            int end = stringLength - 1;
            for (index = 0; index <= end; ++index) {
                if (parseData[index] != charSeparator) continue;
                if (start == index) {
                    objects.addObject((int)"");
                } else {
                    objects.addObject((int)string.substring(start, index));
                }
                start = index + 1;
            }
            if (parseData[end] == charSeparator) {
                objects.addObject((int)"");
            } else {
                objects.addObject((int)string.substring(start, stringLength));
            }
        } else {
            objects = new NSMutableArray<int>(4);
            int end = stringLength - separatorLength;
            while (true) {
                if (start >= stringLength) {
                    return objects;
                }
                index = string.indexOf(separator, start);
                if (index < 0) {
                    index = stringLength;
                }
                if (index == end) break;
                objects.addObject((int)string.substring(start, index));
                start = index + separatorLength;
            }
            if (start <= index) {
                objects.addObject((int)string.substring(start, index));
            }
            objects.addObject((int)"");
        }
        return objects;
    }

    public static NSMutableArray<String> _mutableComponentsSeparatedByString(String string, String separator) {
        return NSArray.componentsSeparatedByString(string, separator).mutableClone();
    }

    private Object _valueForKeyPathWithOperator(String keyPath) {
        String operatorPath;
        String operatorName;
        int index = keyPath.indexOf(46);
        if (index < 0) {
            operatorName = keyPath.substring(1);
            operatorPath = "";
        } else {
            operatorName = keyPath.substring(1, index);
            operatorPath = index >= keyPath.length() - 1 ? "" : keyPath.substring(index + 1);
        }
        Operator arrayOperator = NSArray.operatorForKey(operatorName);
        if (arrayOperator != null) {
            return arrayOperator.compute(this, operatorPath);
        }
        throw new IllegalArgumentException("No key operator available to compute aggregate " + keyPath);
    }

    public Object valueForKey(String key) {
        if (key != null) {
            if (key.charAt(0) == '@') {
                return this._valueForKeyPathWithOperator(key);
            }
            if (key.equals(CountOperatorName)) {
                return _NSUtilities.IntegerForInt((int)this.count());
            }
        }
        Object[] objects = this.objectsNoCopy();
        NSMutableArray<int> values = new NSMutableArray<int>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)objects[i], (String)key);
            values.addObject((int)(value == null ? NSKeyValueCoding.NullValue : value));
        }
        return values;
    }

    public void takeValueForKey(Object value, String key) {
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)objects[i], (Object)value, (String)key);
        }
    }

    public Object valueForKeyPath(String keyPath) {
        if (keyPath != null && keyPath.charAt(0) == '@') {
            return this._valueForKeyPathWithOperator(keyPath);
        }
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)keyPath);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)value, (String)keyPath);
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSArray<Object>(coder.decodeObjects());
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObjects(this.objectsNoCopy());
    }

    public void makeObjectsPerformSelector(NSSelector selector, Object ... parameters) {
        if (selector == null) {
            throw new IllegalArgumentException("Selector cannot be null");
        }
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            NSSelector._safeInvokeSelector((NSSelector)selector, (Object)objects[i], (Object[])parameters);
        }
    }

    public int _shallowHashCode() {
        return _NSArrayClassHashCode;
    }

    @Override
    public int hashCode() {
        if (this._mustRecomputeHash()) {
            int hash = 0;
            int max = this.count() <= 16 ? this.count() : 16;
            for (int i = 0; i < max; ++i) {
                E element = this.objectAtIndex(i);
                if (element instanceof _NSFoundationCollection) {
                    hash ^= ((_NSFoundationCollection)element)._shallowHashCode();
                    continue;
                }
                hash ^= element.hashCode();
            }
            this._hashCache = hash;
            this._setMustRecomputeHash(false);
        }
        return this._hashCache;
    }

    public Object clone() {
        return this;
    }

    public NSArray<E> immutableClone() {
        return this;
    }

    public NSMutableArray<E> mutableClone() {
        return new NSMutableArray(this);
    }

    public String toString() {
        if (this.count() == 0) {
            return "()";
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("(");
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i > 0) {
                buffer.append(", ");
            }
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
                continue;
            }
            if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
                continue;
            }
            buffer.append(object == this ? "THIS" : object.toString());
        }
        buffer.append(")");
        return new String(buffer);
    }

    protected boolean _mustRecomputeHash() {
        return this._recomputeHashCode;
    }

    protected void _setMustRecomputeHash(boolean change) {
        this._recomputeHashCode = change;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationValuesFieldKey, this.objects());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        values = values != null ? values : _NSUtilities._NoObjectArray;
        this.initFromObjects(values, 0, values.length, true, false);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptyArray;
        }
        return this;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            throw new NullPointerException("NSArray does not support null values");
        }
        return this.containsObject(element);
    }

    @Override
    public Iterator<E> iterator() {
        return new _NSJavaArrayListIterator(this.objectsNoCopy(), this.count());
    }

    @Override
    public Object[] toArray() {
        return this.objects();
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        if (objects == null) {
            throw new NullPointerException("List.toArray() cannot have a null parameter");
        }
        int count = this.count();
        if (count <= 0) {
            return objects;
        }
        Object[] objs = this.objectsNoCopy();
        if (objects.length < objs.length) {
            objects = (Object[])Array.newInstance(objects.getClass().getComponentType(), objs.length);
        }
        System.arraycopy(objs, 0, objects, 0, objs.length);
        return objects;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] objects = c.toArray();
        if (objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) {
                    return false;
                }
                if (this._findObjectInArray(0, this.count(), objects[i], false) != -1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ListIterator<E> listIterator() {
        Object[] objs = this.objectsNoCopy();
        return new _NSJavaArrayListIterator(objs, this.count());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] objs = this.objectsNoCopy();
        return new _NSJavaArrayListIterator(objs, this.count(), index);
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        return this.objectAtIndex(index);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        throw new UnsupportedOperationException("Set is not a support operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public int indexOf(Object element) {
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        return this.indexOfObject(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        int lastIndex = -1;
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        for (int i = 0; i < this.count(); ++i) {
            if (!this.objectAtIndex(i).equals(element)) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Remove is not a support operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Remove is not a support operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Clear is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("RetainAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("RemoveAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.count() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Illegal index value (fromIndex < 0 || toIndex > size || fromIndex > toIndex)");
        }
        return this.subarrayWithRange(new NSRange(fromIndex, toIndex - fromIndex));
    }

    public static final <T> NSArray<T> emptyArray() {
        return EmptyArray;
    }

    static {
        try {
            NSArray.setOperatorForKey(CountOperatorName, new _CountOperator());
            NSArray.setOperatorForKey(MaximumOperatorName, new _MaxOperator());
            NSArray.setOperatorForKey(MinimumOperatorName, new _MinOperator());
            NSArray.setOperatorForKey(SumOperatorName, new _SumNumberOperator());
            NSArray.setOperatorForKey(AverageOperatorName, new _AvgNumberOperator());
        }
        catch (Throwable e) {
            NSLog.err.appendln((Object)"Exception occurred in initializer");
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.debug.appendln(e);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operator {
        public Object compute(NSArray<?> var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class _CountOperator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            return _NSUtilities.IntegerForInt((int)values.count());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class _Operator {
        protected Object _operationValue(Object object, String keyPath) {
            return keyPath == null || keyPath.length() <= 0 ? object : NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)object, (String)keyPath);
        }

        private BigDecimal _bigDecimalForValue(Object object) {
            if (object != null) {
                if (_NSUtilities._isClassANumberOrABoolean(object.getClass())) {
                    return (BigDecimal)_NSUtilities.convertNumberOrBooleanIntoCompatibleValue((Object)object, (Class)_NSUtilities._BigDecimalClass);
                }
                if (object instanceof String) {
                    return new BigDecimal((String)object);
                }
                throw new IllegalStateException("Can't convert " + object + " (class " + object.getClass().getName() + ") into number");
            }
            return null;
        }

        BigDecimal _sum(NSArray<?> values, String keyPath) {
            BigDecimal sum = BigDecimal.valueOf(0L);
            Object[] objects = values.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                BigDecimal value = this._bigDecimalForValue(this._operationValue(objects[i], keyPath));
                if (value == null) continue;
                sum = sum.add(value);
            }
            return sum;
        }

        Object _minOrMaxValue(Object referenceValue, Object compareValue, boolean trueForMaxAndFalseForMin) {
            int comparison;
            if (referenceValue == null) {
                return compareValue;
            }
            if (compareValue == null) {
                return referenceValue;
            }
            if (_NSUtilities._isClassANumberOrABoolean(referenceValue.getClass())) {
                comparison = _NSUtilities.compareNumbersOrBooleans((Object)referenceValue, (Object)compareValue);
            } else if (referenceValue instanceof NSTimestamp) {
                comparison = ((NSTimestamp)referenceValue).compare((NSTimestamp)compareValue);
            } else if (referenceValue instanceof Comparable) {
                comparison = ((Comparable)referenceValue).compareTo(compareValue);
            } else {
                throw new IllegalStateException("Cannot compare values " + referenceValue + " and " + compareValue + " (they are not instance of Comparable");
            }
            if (trueForMaxAndFalseForMin ? comparison >= 0 : comparison <= 0) {
                return referenceValue;
            }
            return compareValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class _MaxOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            Object max = null;
            Object[] objects = values.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                max = this._minOrMaxValue(max, this._operationValue(objects[i], keyPath), true);
            }
            return max;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class _MinOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            Object min = null;
            Object[] objects = values.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                min = this._minOrMaxValue(min, this._operationValue(objects[i], keyPath), false);
            }
            return min;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class _SumNumberOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            return this._sum(values, keyPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class _AvgNumberOperator
    extends _Operator
    implements Operator {
        @Override
        public Object compute(NSArray<?> values, String keyPath) {
            int count = values.count();
            if (count != 0) {
                BigDecimal sum = this._sum(values, keyPath);
                return sum.divide(BigDecimal.valueOf(count), sum.scale() + 4, 6);
            }
            return null;
        }
    }
}

