/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.RandomAccessSubList;
import com.webobjects.foundation.SubList;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSMutableArray<E>
extends NSArray<E>
implements RandomAccess {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime((String)"com.webobjects.foundation.NSMutableArray");
    static final long serialVersionUID = -3909373569895711876L;
    public static final Object ERX_MARKER = "Wonder";
    protected transient int modCount = 0;
    protected transient int _capacity;
    protected transient Object[] _objectsCache;
    protected transient int _count;

    public NSMutableArray() {
    }

    public NSMutableArray(Collection<? extends E> collection) {
        super(collection);
    }

    public NSMutableArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableArray(E object) {
        super(object);
    }

    public NSMutableArray(E[] objects) {
        super(objects);
    }

    public NSMutableArray(E object, E ... objects) {
        super(object, objects);
    }

    public NSMutableArray(E[] objects, NSRange range) {
        super(objects, range);
    }

    public NSMutableArray(NSArray<? extends E> otherArray) {
        super(otherArray);
    }

    public NSMutableArray(Vector<? extends E> vector, NSRange range, boolean ignoreNull) {
        super(vector, range, ignoreNull);
    }

    public NSMutableArray(List<? extends E> list, NSRange range, boolean ignoreNull) {
        super(list, range, ignoreNull);
    }

    @Override
    protected void _initializeWithCapacity(int capacity) {
        this._capacity = capacity;
        this._objectsCache = null;
        super._initializeWithCapacity(capacity);
    }

    protected void _ensureCapacity(int capacity) {
        if (capacity > this._capacity) {
            if (capacity == 0) {
                this._setObjects(null);
            } else {
                if (capacity < 4) {
                    capacity = 4;
                } else {
                    int testCapacity = 2 * this._capacity;
                    if (testCapacity > capacity) {
                        capacity = testCapacity;
                    }
                }
                Object[] objs = this._objects();
                objs = objs != null ? _NSCollectionPrimitives.copyArray((Object[])objs, (int)capacity) : new Object[capacity];
                this._setObjects(objs);
            }
            this._capacity = capacity;
        }
    }

    public void ensureCapacity(int capacity) {
        this._ensureCapacity(capacity);
    }

    public void trimToSize() {
    }

    @Override
    protected void _setCount(int count) {
        this._count = count;
    }

    public void setArray(NSArray<? extends E> otherArray) {
        if (otherArray != this) {
            if (otherArray == null) {
                this._setCount(0);
            } else {
                Object[] objects = otherArray.objectsNoCopy();
                this._ensureCapacity(objects.length);
                int count = this.count();
                Object[] objs = this._objects();
                if (objects.length > 0) {
                    System.arraycopy(objects, 0, objs, 0, objects.length);
                }
                for (int i = objects.length; i < count; ++i) {
                    objs[i] = null;
                }
                this._setCount(objects.length);
            }
            this.clearCache();
        }
    }

    @Override
    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            int count = this.count();
            this._objectsCache = count == 0 ? _NSCollectionPrimitives.EmptyArray : (this._count == this._capacity ? this._objects() : _NSCollectionPrimitives.copyArray((Object[])this._objects(), (int)count));
        }
        return this._objectsCache;
    }

    @Override
    public int count() {
        return this._count;
    }

    public void addObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
        }
        int count = this.count();
        this._ensureCapacity(count + 1);
        this._objects()[count] = object;
        this._setCount(count + 1);
        this.clearCache();
    }

    public void addObjects(E ... objects) {
        if (objects != null && objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] != null) continue;
                throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
            }
            int count = this.count();
            this._ensureCapacity(count + objects.length);
            System.arraycopy(objects, 0, this._objects(), count, objects.length);
            this._setCount(count + objects.length);
            this.clearCache();
        }
    }

    public void replaceObjectAtIndex(int index, E object) {
        this.replaceObjectAtIndex(object, index);
    }

    public void insertObjectAtIndex(E object, int index) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int count = this.count();
        if (index >= 0 && index <= count) {
            this._ensureCapacity(count + 1);
            Object[] objs = this._objects();
            if (index < count) {
                System.arraycopy(objs, index, objs, index + 1, count - index);
            }
            objs[index] = object;
            this._setCount(count + 1);
            this.clearCache();
            return;
        }
        throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds [0, " + (count - 1) + "]");
    }

    public E removeObjectAtIndex(int index) {
        int count = this.count();
        if (index >= 0 && index < count) {
            Object[] objs = this._objects();
            Object result = objs[index];
            if (index < --count) {
                System.arraycopy(objs, index + 1, objs, index, count - index);
            }
            objs[count] = null;
            this._setCount(count);
            this.clearCache();
            return (E)result;
        }
        if (count == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds [0, " + (count - 1) + "]");
    }

    public void removeAllObjects() {
        if (this.count() > 0) {
            this._setObjects(new Object[this._capacity]);
            this._setCount(0);
            this.clearCache();
        }
    }

    public void sortUsingComparator(NSComparator comparator) throws NSComparator.ComparisonException {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator not specified");
        }
        int count = this.count();
        if (count < 2) {
            return;
        }
        _NSCollectionPrimitives.K2SortArray((Object[])this._objects(), (int)count, (NSComparator)comparator);
        this.clearCache();
    }

    public void addObjectsFromArray(NSArray<? extends E> otherArray) {
        if (otherArray != null) {
            this.addObjects(otherArray.objectsNoCopy());
        }
    }

    public void replaceObjectsInRange(NSRange range, NSArray<? extends E> otherArray, NSRange otherRange) {
        int otherRangeLength;
        if (range == null || otherRange == null) {
            throw new IllegalArgumentException("Both ranges cannot be null");
        }
        if (otherArray == null) {
            throw new IllegalArgumentException("Other array cannot be null");
        }
        int rangeLength = range.length();
        int rangeLocation = range.location();
        int otherRangeLocation = otherRange.location();
        for (otherRangeLength = otherRange.length(); 0 < rangeLength && 0 < otherRangeLength; --otherRangeLength) {
            this.replaceObjectAtIndex(otherArray.objectAtIndex(otherRangeLocation), rangeLocation);
            ++rangeLocation;
            --rangeLength;
            ++otherRangeLocation;
        }
        while (0 < otherRangeLength) {
            this.insertObjectAtIndex(otherArray.objectAtIndex(otherRangeLocation), rangeLocation);
            ++rangeLocation;
            ++otherRangeLocation;
            --otherRangeLength;
        }
        while (0 < rangeLength) {
            this.removeObjectAtIndex(rangeLocation);
            --rangeLength;
        }
    }

    public E removeLastObject() {
        if (this.count() == 0) {
            return null;
        }
        return this.removeObjectAtIndex(this.count() - 1);
    }

    private boolean _removeObject(Object object, int index, int length, boolean identical) {
        boolean wasRemoved;
        block3: {
            Object[] objects;
            block4: {
                wasRemoved = false;
                if (object == null) {
                    throw new IllegalArgumentException("Attempt to remove null from an  " + this.getClass().getName() + ".");
                }
                if (this.count() <= 0) break block3;
                objects = this.objectsNoCopy();
                int maxIndex = index + length - 1;
                if (!identical) break block4;
                for (int i = maxIndex; i >= index; --i) {
                    if (objects[i] != object) continue;
                    this.removeObjectAtIndex(i);
                    wasRemoved = true;
                }
                break block3;
            }
            if (identical) break block3;
            for (int i = maxIndex; i >= index; --i) {
                if (objects[i] != object && !object.equals(objects[i])) continue;
                this.removeObjectAtIndex(i);
                wasRemoved = true;
            }
        }
        return wasRemoved;
    }

    public boolean removeObject(Object object) {
        return this._removeObject(object, 0, this.count(), false);
    }

    public boolean removeObject(Object object, NSRange range) {
        boolean wasRemoved = false;
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (count - 1) + "]");
            }
            wasRemoved = this._removeObject(object, rangeLocation, rangeLength, false);
        }
        return wasRemoved;
    }

    public boolean removeIdenticalObject(Object object) {
        return this._removeObject(object, 0, this.count(), true);
    }

    public boolean removeIdenticalObject(Object object, NSRange range) {
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (count - 1) + "]");
            }
            return this._removeObject(object, rangeLocation, rangeLength, true);
        }
        return false;
    }

    public void removeObjectsInArray(NSArray<?> otherArray) {
        if (otherArray != null) {
            this.removeObjects(otherArray.objectsNoCopy());
        }
    }

    public void removeObjectsInRange(NSRange range) {
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (count - 1) + "]");
            }
            while (rangeLength-- > 0) {
                this.removeObjectAtIndex(rangeLocation);
            }
        }
    }

    @Override
    public Object clone() {
        return new NSMutableArray<E>(this);
    }

    @Override
    public NSArray<E> immutableClone() {
        return new NSArray(this);
    }

    @Override
    public NSMutableArray<E> mutableClone() {
        return (NSMutableArray)this.clone();
    }

    public void _moveObjectAtIndexToIndex(int sourceIndex, int destIndex) {
        int direction;
        int boundary;
        int index;
        if (sourceIndex == destIndex) {
            return;
        }
        int count = this.count();
        if (sourceIndex < 0 || sourceIndex >= count || destIndex < 0 || destIndex >= count) {
            throw new IllegalArgumentException("Either source(" + sourceIndex + ") or destination(" + destIndex + ") is illegal.");
        }
        Object[] objs = this._objects();
        Object temp = objs[sourceIndex];
        if (sourceIndex < destIndex) {
            index = destIndex;
            boundary = sourceIndex;
            direction = 1;
        } else {
            index = sourceIndex;
            boundary = destIndex;
            direction = -1;
        }
        while (index != boundary) {
            objs[index] = objs[index + direction];
            index += direction;
        }
        objs[destIndex] = temp;
        this._objectsCache = null;
    }

    private void clearCache() {
        this._objectsCache = null;
        this._setMustRecomputeHash(true);
    }

    public E replaceObjectAtIndex(E object, int index) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int count = this.count();
        if (index >= 0 && index < count) {
            Object[] objs = this._objects();
            Object result = objs[index];
            objs[index] = object;
            this.clearCache();
            return (E)result;
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (count - 1) + "]");
    }

    public void removeObjects(Object ... otherObjects) {
        int count;
        if (otherObjects != null && (count = this.count()) > 0) {
            int otherCount = otherObjects.length;
            if (count * otherCount > 100) {
                if (count > 0) {
                    NSMutableSet<Object> table = new NSMutableSet<Object>(otherCount);
                    for (int i = 0; i < otherCount; ++i) {
                        Object o = otherObjects[i];
                        if (o == null) continue;
                        table.addObject(o);
                    }
                    int offset = 0;
                    Object[] objs = this._objects();
                    for (int i = 0; i < count; ++i) {
                        Object o = objs[i];
                        objs[i] = null;
                        if (table.containsObject(o)) continue;
                        objs[offset++] = o;
                    }
                    this._setCount(offset);
                    this.clearCache();
                }
            } else {
                for (int i = 0; i < otherObjects.length; ++i) {
                    this.removeObject(otherObjects[i]);
                }
            }
        }
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int i = this.size();
        if (array.length < i) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), i);
        }
        T[] result = array;
        for (int j = 0; j < i; ++j) {
            result[j] = this.objectAtIndex(j);
        }
        if (array.length > i) {
            array[i] = null;
        }
        return array;
    }

    @Override
    public E set(int index, E element) {
        Object old = this.objectAtIndex(index);
        if (element != old) {
            this.replaceObjectAtIndex(element, index);
        }
        return old;
    }

    @Override
    public void add(int index, E element) {
        this.insertObjectAtIndex(element, index);
    }

    @Override
    public boolean add(E element) {
        this.addObject(element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.addObjects(collection.toArray());
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        boolean modified = false;
        if (collection == this) {
            collection = ((NSMutableArray)collection).immutableClone();
        }
        Iterator<E> e = collection.iterator();
        while (e.hasNext()) {
            this.add(index++, e.next());
            modified = true;
        }
        return modified;
    }

    @Override
    public E remove(int index) {
        return this.removeObjectAtIndex(index);
    }

    @Override
    public boolean remove(Object o) {
        boolean modified = false;
        int index = this.indexOf(o);
        if (index != -1) {
            this.removeObjectAtIndex(index);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int count = this.count();
        this.removeObjects(collection.toArray());
        return count != this.count();
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this instanceof RandomAccess ? new RandomAccessSubList(this, fromIndex, toIndex) : new SubList(this, fromIndex, toIndex);
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator<E> it = this.listIterator(fromIndex);
        int n = toIndex - fromIndex;
        for (int i = 0; i < n; ++i) {
            it.next();
            it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                int i = this.cursor - 1;
                Object previous = NSMutableArray.this.get(i);
                this.checkForComodification();
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                NSMutableArray.this.set(this.lastRet, o);
                this.expectedModCount = NSMutableArray.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(Object o) {
            this.checkForComodification();
            try {
                NSMutableArray.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = NSMutableArray.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        protected Itr() {
            this.expectedModCount = NSMutableArray.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != NSMutableArray.this.size();
        }

        @Override
        public E next() {
            try {
                Object next = NSMutableArray.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                NSMutableArray.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = NSMutableArray.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (NSMutableArray.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

