/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.ERXExtensions;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXS;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXDisplayGroup<T>
extends WODisplayGroup {
    private static final Logger log = Logger.getLogger(ERXDisplayGroup.class);
    private NSMutableDictionary<String, EOQualifier> _extraQualifiers = new NSMutableDictionary();

    public ERXDisplayGroup() {
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        return new ERXDisplayGroup(unarchiver);
    }

    private ERXDisplayGroup(EOKeyValueUnarchiver unarchiver) {
        this();
        this.setCurrentBatchIndex(1);
        this.setNumberOfObjectsPerBatch(unarchiver.decodeIntForKey("numberOfObjectsPerBatch"));
        this.setFetchesOnLoad(unarchiver.decodeBoolForKey("fetchesOnLoad"));
        this.setValidatesChangesImmediately(unarchiver.decodeBoolForKey("validatesChangesImmediately"));
        this.setSelectsFirstObjectAfterFetch(unarchiver.decodeBoolForKey("selectsFirstObjectAfterFetch"));
        this.setLocalKeys((NSArray)unarchiver.decodeObjectForKey("localKeys"));
        this.setDataSource((EODataSource)unarchiver.decodeObjectForKey("dataSource"));
        this.setSortOrderings((NSArray)unarchiver.decodeObjectForKey("sortOrdering"));
        this.setQualifier((EOQualifier)unarchiver.decodeObjectForKey("qualifier"));
        this.setDefaultStringMatchFormat((String)unarchiver.decodeObjectForKey("formatForLikeQualifier"));
        NSDictionary insertedObjectDefaultValues = (NSDictionary)unarchiver.decodeObjectForKey("insertedObjectDefaultValues");
        if (insertedObjectDefaultValues == null) {
            insertedObjectDefaultValues = NSDictionary.EmptyDictionary;
        }
        this.setInsertedObjectDefaultValues(insertedObjectDefaultValues);
        this.finishInitialization();
    }

    public void setQualifierForKey(EOQualifier qualifier, String key) {
        if (qualifier != null) {
            this._extraQualifiers.setObjectForKey(qualifier, key);
        } else {
            this._extraQualifiers.removeObjectForKey(key);
        }
    }

    public EOQualifier qualifierFromQueryValues() {
        EOQualifier q1 = super.qualifierFromQueryValues();
        EOAndQualifier q2 = null;
        if (this._extraQualifiers.allValues().count() > 1) {
            q2 = new EOAndQualifier(this._extraQualifiers.allValues());
        } else if (this._extraQualifiers.allValues().count() > 0) {
            q2 = (EOQualifier)this._extraQualifiers.allValues().lastObject();
        }
        return q1 == null ? q2 : (q2 == null ? q1 : new EOAndQualifier(new NSArray<EOQualifier>(new EOQualifier[]{q1, q2})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fetch() {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fetching: " + this.toString()), (Throwable)new RuntimeException("Dummy for Stacktrace"));
        }
        if (this.dataSource() instanceof EODatabaseDataSource) {
            EODatabaseDataSource ds = (EODatabaseDataSource)this.dataSource();
            EOFetchSpecification old = ds.fetchSpecification();
            EOFetchSpecification fs = ERXEOAccessUtilities.localizeFetchSpecification(ds.editingContext(), old);
            ds.setFetchSpecification(fs);
            try {
                result = super.fetch();
            }
            finally {
                ds.setFetchSpecification(old);
            }
        } else {
            result = super.fetch();
        }
        return result;
    }

    public NSArray<T> filteredObjects() {
        EOQualifier q = this.qualifier();
        NSArray result = q != null ? EOQualifier.filteredArrayWithQualifier(this.allObjects(), (EOQualifier)q) : this.allObjects();
        return result;
    }

    public NSArray<T> sortedObjects() {
        return ERXS.sorted(this.filteredObjects(), this.sortOrderings());
    }

    public NSArray<T> selectedObjects() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("selectedObjects@" + ((Object)((Object)this)).hashCode() + ":" + super.selectedObjects().count()));
        }
        return super.selectedObjects();
    }

    public void setSelectedObjects(NSArray nsarray) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setSelectedObjects@" + ((Object)((Object)this)).hashCode() + ":" + (nsarray != null ? Integer.valueOf(nsarray.count()) : "0")));
        }
        super.setSelectedObjects(nsarray);
    }

    public boolean setSelectionIndexes(NSArray nsarray) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setSelectionIndexes@" + ((Object)((Object)this)).hashCode() + ":" + (nsarray != null ? Integer.valueOf(nsarray.count()) : "0")), (Throwable)new RuntimeException("Dummy for Stacktrace"));
        }
        return super.setSelectionIndexes(nsarray);
    }

    public void setNumberOfObjectsPerBatch(int i) {
        NSArray<T> oldSelection = this.selectedObjects();
        super.setNumberOfObjectsPerBatch(i);
        this.setSelectedObjects(oldSelection);
    }

    public void setDataSource(EODataSource eodatasource) {
        EODataSource old = this.dataSource();
        super.setDataSource(eodatasource);
        if (old != null && eodatasource != null && ERXExtensions.safeDifferent(old.classDescriptionForObjects(), eodatasource.classDescriptionForObjects())) {
            this.setSortOrderings(NSArray.EmptyArray);
        }
    }

    public Object displayNextBatch() {
        NSArray<T> oldSelection = this.selectedObjects();
        Object result = super.displayNextBatch();
        this.setSelectedObjects(oldSelection);
        return result;
    }

    public Object displayPreviousBatch() {
        NSArray<T> oldSelection = this.selectedObjects();
        Object result = super.displayPreviousBatch();
        this.setSelectedObjects(oldSelection);
        return result;
    }

    public Object selectFilteredObjects() {
        this.setSelectedObjects(this.filteredObjects());
        return null;
    }

    public void setSortOrderings(NSArray nsarray) {
        super.setSortOrderings(nsarray);
        if (nsarray != null && nsarray.count() > 1 && log.isDebugEnabled()) {
            log.debug((Object)("More than one sort order: " + nsarray));
        }
    }

    public void clearExtraQualifiers() {
        this._extraQualifiers.removeAllObjects();
    }

    public NSArray<T> allObjects() {
        return super.allObjects();
    }

    public NSArray<String> allQualifierOperators() {
        return super.allQualifierOperators();
    }

    public NSArray<T> displayedObjects() {
        return super.displayedObjects();
    }

    public T selectedObject() {
        return (T)super.selectedObject();
    }

    public NSArray<EOSortOrdering> sortOrderings() {
        return super.sortOrderings();
    }

    public int indexOfFirstDisplayedObject() {
        if (this.currentBatchIndex() == 1 && this.displayedObjects().count() == 0) {
            return 0;
        }
        return super.indexOfFirstDisplayedObject();
    }

    public int indexOfLastDisplayedObject() {
        int computedEnd = this.numberOfObjectsPerBatch() * this.currentBatchIndex();
        int realEnd = this.displayedObjects().count();
        if (this.numberOfObjectsPerBatch() == 0) {
            return realEnd;
        }
        if (this.currentBatchIndex() > 1) {
            realEnd += this.numberOfObjectsPerBatch() * (this.currentBatchIndex() - 1);
        }
        return realEnd >= computedEnd ? computedEnd : realEnd;
    }
}

