/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXAssert;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ERXCachingWrapper
extends ERXStatelessComponent {
    private static final Logger log = Logger.getLogger(ERXCachingWrapper.class);
    protected static Map cache = Collections.synchronizedMap(new HashMap(){

        public Object get(Object key) {
            Entry result = (Entry)super.get(key);
            if (result != null && !result.isActive()) {
                this.remove(key);
                result = null;
            }
            return result;
        }
    });
    protected NSArray keys;
    protected String entryName;
    protected Long cacheDuration;
    protected Entry entry;
    protected NSDictionary values;

    public ERXCachingWrapper(WOContext context) {
        super(context);
    }

    public void awake() {
        super.awake();
        this.keys = null;
        this.entryName = null;
        this.cacheDuration = null;
        this.values = null;
        this.entry = (Entry)cache.get(this.values());
    }

    protected NSArray keys() {
        if (this.keys == null) {
            Object value = this.valueForBinding("keys");
            if (value instanceof NSArray) {
                this.keys = (NSArray)value;
            } else if (value instanceof String) {
                this.keys = (NSArray)NSPropertyListSerialization.propertyListFromString((String)((String)value));
            } else if (value != null) {
                throw new IllegalArgumentException("keys must be a NSArray or a property list String");
            }
            if (this.keys == null) {
                this.keys = NSArray.EmptyArray;
            }
        }
        return this.keys;
    }

    public NSKeyValueCoding headers() {
        return new NSKeyValueCoding(){

            public Object valueForKey(String s) {
                return ERXCachingWrapper.this.context().request().headerForKey((Object)s);
            }

            public void takeValueForKey(Object obj, String s) {
            }
        };
    }

    public NSKeyValueCoding formValues() {
        return new NSKeyValueCoding(){

            public Object valueForKey(String s) {
                return ERXCachingWrapper.this.context().request().formValueForKey(s);
            }

            public void takeValueForKey(Object obj, String s) {
            }
        };
    }

    protected String entryName() {
        if (this.entryName == null) {
            this.entryName = (String)this.valueForBinding("entryName");
        }
        ERXAssert.PRE.notNull("cacheEntryName is required", this.entryName);
        return this.entryName;
    }

    protected long cacheDuration() {
        if (this.cacheDuration == null) {
            Number value = (Number)this.valueForBinding("duration");
            this.cacheDuration = value == null ? new Long(60000L) : new Long(value.longValue());
        }
        return this.cacheDuration;
    }

    protected NSDictionary values() {
        if (this.values == null) {
            NSMutableDictionary<String, Object> result = new NSMutableDictionary<String, Object>();
            Enumeration e = this.keys().objectEnumerator();
            while (e.hasMoreElements()) {
                String keyPath = (String)e.nextElement();
                Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)((Object)this), (String)keyPath);
                if (value == null) continue;
                result.setObjectForKey(value, keyPath);
            }
            result.setObjectForKey(this.entryName(), "ERXCachingWrapper.entryName");
            this.values = result.immutableClone();
        }
        return this.values;
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        if (this.entry == null) {
            super.takeValuesFromRequest(request, context);
        }
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        if (this.entry == null) {
            return super.invokeAction(request, context);
        }
        return null;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        if (this.entry == null) {
            WOResponse newResponse = this.application().createResponseInContext(context);
            newResponse.setHeaders(response.headers());
            newResponse.setUserInfo(response.userInfo());
            super.appendToResponse(newResponse, context);
            String content = newResponse.contentString();
            this.entry = new Entry(content, this.cacheDuration(), context.hasSession() ? context.session().sessionID() : null);
            cache.put(this.values(), this.entry);
        }
        String content = this.entry.content(context);
        response.appendContentString(content);
    }

    protected class Entry {
        private long insertTime = System.currentTimeMillis();
        private long duration;
        private String content;
        private String sessionID;

        public Entry(String aContent, long aDuration, String aSessionID) {
            this.content = aContent;
            this.duration = aDuration;
            this.sessionID = aSessionID;
        }

        public boolean isActive() {
            return System.currentTimeMillis() - (this.insertTime + this.duration) < 0L;
        }

        public String content(WOContext arg1) {
            if (this.sessionID != null) {
                return this.content.replaceAll(this.sessionID, arg1.session().sessionID());
            }
            return this.content;
        }
    }
}

