/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.eof.ERXConstant;

public class ERXRadioButtonMatrix
extends ERXStatelessComponent {
    private static final Integer DEFAULT_PADDING = ERXConstant.ZeroInteger;
    private static final Integer DEFAULT_SPACING = ERXConstant.ZeroInteger;
    protected Object currentItem;
    protected Object _selection;
    protected Number index;
    protected Object uniqueID;

    public ERXRadioButtonMatrix(WOContext aContext) {
        super(aContext);
    }

    public void reset() {
        this.invalidateCaches();
    }

    public Object currentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(Object aValue) {
        this.currentItem = aValue;
        this.setValueForBinding(aValue, "item");
    }

    public Number index() {
        return this.index;
    }

    public void setIndex(Number newIndex) {
        this.index = newIndex;
    }

    public Object selection() {
        if (this._selection == null) {
            this._selection = this.valueForBinding("selection");
        }
        return this._selection;
    }

    public void setSelection(String anIndex) {
        if (anIndex != null) {
            NSArray anItemList = (NSArray)this.valueForBinding("list");
            Object aSelectedObject = anItemList.objectAtIndex(Integer.parseInt(anIndex));
            this.setValueForBinding(aSelectedObject, "selection");
        }
        this._selection = null;
    }

    public String isCurrentItemSelected() {
        if (this.selection() != null && this.selection().equals(this.currentItem)) {
            return "checked";
        }
        return "";
    }

    public void awake() {
        super.awake();
        this.uniqueID = this.valueForBinding("uniqueID");
        if (this.uniqueID == null) {
            this.uniqueID = this.context().elementID();
        }
    }

    public void invalidateCaches() {
        this._selection = null;
        this.currentItem = null;
        this.index = null;
        this.uniqueID = null;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        super.appendToResponse(aResponse, aContext);
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this.setSelection(aRequest.stringFormValueForKey(this.uniqueID()));
        super.takeValuesFromRequest(aRequest, aContext);
    }

    public String uniqueID() {
        return this.uniqueID.toString();
    }

    public Object cellpadding() {
        Object v = this.valueForBinding("cellpadding");
        if (v != null) {
            return v;
        }
        return DEFAULT_PADDING;
    }

    public Object cellspacing() {
        Object v = this.valueForBinding("cellspacing");
        if (v != null) {
            return v;
        }
        return DEFAULT_SPACING;
    }
}

