/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import org.apache.log4j.Logger;

public class ERXTolerantWrapper
extends WODynamicGroup {
    private static final Logger log = Logger.getLogger(ERXTolerantWrapper.class);
    private WOAssociation _tolerant;

    public ERXTolerantWrapper(String name, NSDictionary associations, WOElement template) {
        super(name, associations, template);
        this._tolerant = (WOAssociation)((NSMutableDictionary)associations).removeObjectForKey("tolerant");
    }

    private boolean isTolerant(WOComponent component) {
        boolean tolerant = this._tolerant != null ? this._tolerant.booleanValueInComponent(component) : !WOApplication.application().isCachingEnabled();
        return tolerant;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        if (this.isTolerant(component)) {
            try {
                super.appendToResponse(response, context);
            }
            catch (Throwable ex) {
                response.appendContentString(ex.toString());
                context._setCurrentComponent(component);
                log.error((Object)ex, ex);
            }
        } else {
            super.appendToResponse(response, context);
        }
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        WOComponent component = context.component();
        if (this.isTolerant(component)) {
            try {
                return super.invokeAction(request, context);
            }
            catch (Throwable ex) {
                context._setCurrentComponent(component);
                log.error((Object)ex, ex);
                return null;
            }
        }
        return super.invokeAction(request, context);
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        WOComponent component = context.component();
        if (this.isTolerant(component)) {
            try {
                super.takeValuesFromRequest(request, context);
            }
            catch (Throwable ex) {
                context._setCurrentComponent(component);
                log.error((Object)ex, ex);
            }
        } else {
            super.takeValuesFromRequest(request, context);
        }
    }
}

