/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.concurrency;

import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ERXCloneableThreadLocal
extends InheritableThreadLocal {
    protected static final Logger log = Logger.getLogger(ERXCloneableThreadLocal.class);

    protected Object childValue(Object parentValue) {
        Object child = null;
        if (parentValue != null) {
            if (!(parentValue instanceof Cloneable)) {
                throw new IllegalStateException("Using a ERXCloneableThreadLocal with an object: " + parentValue.getClass() + " " + parentValue.toString() + " that does not implement the Cloneable interface ");
            }
            try {
                Method m = parentValue.getClass().getMethod("clone", ERXConstant.EmptyClassArray);
                child = m.invoke(parentValue, ERXConstant.EmptyObjectArray);
            }
            catch (InvocationTargetException ite) {
                log.error((Object)("Invocation exception occurred when invoking clone in ERXClonableThreadLocal:" + ite.getTargetException() + " backtrace: " + ERXUtilities.stackTrace(ite.getTargetException())));
            }
            catch (NoSuchMethodException nsme) {
                log.error((Object)("No clone method for the class: " + parentValue.getClass() + " very strange."));
            }
            catch (IllegalAccessException iae) {
                log.error((Object)("Clone method has protected or private access for the object: " + parentValue.getClass() + " " + parentValue.toString() + " exception: " + iae.getMessage()));
            }
        }
        return child;
    }
}

